<?php

/**
* @version 2.6.7
* @package Joomla 1.5
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

require_once( JPATH_SITE.'/components/com_dtregister/common.php');

$document = & JFactory::getDocument();

$document->addStyleSheet('components/com_dtregister/assets/css/admin.dtregister.css');

class HTML_groups { 

 function editlocation($row){

   include( JPATH_SITE.'/administrator/components/com_dtregister/view/location/edit.php');

 }

 function addlocation(){

	  include( JPATH_SITE.'/administrator/components/com_dtregister/view/location/add.php');

 }

 function listlocation($locations,$pageNav){

   include( JPATH_SITE.'/administrator/components/com_dtregister/view/location/list.php'); 

 }

function showsync($evt_old,$evt_new){

	 $options = array();

	 $options[]=JHTML::_('select.option',"",JText::_( 'DT_SELECT'));

	 foreach($evt_new as $key=>$value){

		$text = $value->text." (".get_date($value->dtstart).") [id=".$value->value."] ";

	  $options[]=JHTML::_('select.option',$value->value,$text);

	}

	  $html = "";

	  foreach($evt_old as $key=>$value){

    $html .= "<tr><td>";		

		$html .= $value->title." (".get_date($value->publish_up).") [id=".$value->id."] <input class=\"evt_old\" type=\"hidden\" name=\"evt_old[]\"  value=\"".$value->id."\"></td><td>";

		$html .=JHTML::_('select.genericlist',$options,"new_evt[]"," class=\"evt_new\"","value","text");

		$message = "";

		$class = "";

		if($value->old_event_id !=""){

			$class = " syncdone";

			$message = JText::_( 'DT_SYNC') ; 

		}

		$html .= "</td><td class =\"message".$class."\">".$message ."</td></tr>";

	}

	?>

    <style>

		.syncdone{

			color:#008B00;

			font-weight:bold;

			font-size:9px;

		}

		.syncerror{

			color:red;

			font-weight:bold;

			font-size:9px;

		}

	</style>

	 <form name="adminForm" method="post" action="index2.php">

     <h2>JEvents Re-Sync Tool</h2>

     This is a simple tool to assist you if you've had problems after upgrading from JEvents 1.4.x to 1.5.x.  Sometimes the eventID does not stay the same 

     using the JEvents legacy event migration tool.  When this happens, DT Register loses connection with the events.  This tool will allow you to re-sync 

     the events.<br /><br />

     DO NOT USE THIS if your events are all okay. This is ONLY to be used if you are having issues such as DT Register no longer showing all or some of your 

     events, or your records and settings are now assigned to incorrect events.<br /><br />

     INSTRUCTIONS: The left column shows the event name date from the old JEvents database.  The ID is shown in [] brackets to the right. Then the dropdown in 

     the right column shows your events that have been migrated into the NEW JEvents 1.5 database. The new ID shows there as well.  If the IDs are the same in 

     both columns, you need to do nothing.  If the IDs are different, select the matching event and date, then click the "SYNC EVENTS" button at the bottom of 

     the list. Please be patient as if you have a large number of events, the sync may take a few minutes. Click the button once and wait. You will see a result 

     to the right of each event.  You only need to select the events that are NOT already in sync.<br /><br />

     <table border="1" style="border-color:#e1e1e1;" cellspacing="1" cellpadding="1">

        <tr><th>OLD JEvents</th><th>NEW JEvents 1.5</th><th>RESULTS</th></tr>

     	  <?php echo $html ;?>

        <tr class="events">

        	<td colspan="2" style="padding:2px;">

        		<input type="button" name="sync" class="sync" id="sync" value="<?php echo JText::_( 'DT_RESYNC') ?>" />

        	</td>

        	<td>&nbsp;</td>

        </tr>

     </table>

     </form>

     <script src="../components/com_dtregister/assets/js/jquery.js" language="javascript" type="text/javascript"></script>

     <script src="../components/com_dtregister/assets/js/form.js" language="javascript" type="text/javascript"></script>

     <script src="../components/com_dtregister/assets/js/block.js" language="javascript" type="text/javascript"></script>

	  <script>

 		  DTjQuery(function(){

			DTjQuery().ajaxStart(DTjQuery.blockUI).ajaxStop(DTjQuery.unblockUI);

			DTjQuery('.sync').click(function(){

				DTjQuery(".evt_old").each(function(i,obj){

					//console.log(DTjQuery(this).val()+" obj =  "+obj+" i= "+i);

					url = "index.php?option=com_dtregister&task=savesync&no_html=1&messagenum="+i+"&evtold="+DTjQuery(this).val()+"&evtnew="+DTjQuery('.evt_new:eq('+i+')').val();

					///console.log(url);

					DTjQuery('.message:eq('+i+')').load(url);

				}) 

			});

	   });

	</script>

  <?php

}

function listdiscountcodes($option,$rows){

	?>

    <form name="adminForm" method="post" action="index2.php">

    <p><?php echo JText::_( 'DT_DISCOUNT_CODE_INSTRUCTIONS'); ?></p>

    <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">

      <tr>

        <th width="20">

          <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" />

        </th>

        <th class="title" nowrap><?php echo JText::_( 'DT_NAME'); ?>:</th>

        <th class="title" nowrap><?php echo JText::_( 'DT_START_DATE'); ?>:</th>

        <th class="title" nowrap><?php echo JText::_( 'DT_END_DATE'); ?>:</th>

        <th class="title" nowrap><?php echo JText::_( 'DT_DISCOUNT_CODE'); ?>:</th>

        <th class="title" nowrap><?php echo JText::_( 'DT_PUBLISH'); ?>:</th>

        <th class="title" nowrap><?php echo JText::_( 'DT_DISCOUNT_CODE_LIMIT'); ?>:</th>

        <th class="title" nowrap><?php echo JText::_( 'DT_DISCOUNT_CODE_USED'); ?>:</th>

      </tr>

<?php

    $k = 0;

	$n=count( $rows );

    if ($n>0){

    for ($i=0, $n=count( $rows ); $i < $n; $i++ ) {

      $row = &$rows[$i];

	    $link 	= 'index2.php?option='.$option.'&task=editA_customfield&hidemainmenu=1&id='. $row->id;

			$task 	= $row->publish ? 'unpublish_discountcode' : 'publish_discountcode';

			$img 	= $row->publish ? 'publish_g.png' : 'publish_x.png';

			$alt 	= $row->publish ? JText::_( 'DT_PUBLISHED' ) : JText::_( 'DT_UNPUBLISHED' );

	    $d_code =  new DiscountCode($row->id);

?>

      <tr class="<?php echo "row$k"; ?>">

        <td width="20">

          <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" />

        </td>

        <td align="left">

          <a href="index2.php?option=com_dtregister&task=edit_discount_code&id=<?php echo $row->id; ?>" >

            <?php echo $row->name;?>

          </a>

	  </td>

        <td align="left"><?php echo (strtotime($row->start)!="")?get_date($row->start):JText::_( 'DT_NOT_SPECIFIED' ); ?></td>

        <td align="left"><?php echo (strtotime($row->end)!="")?get_date($row->end):JText::_( 'DT_NOT_SPECIFIED' ); ?></td>

		    <td align="left"><?php echo $row->code; ?></td>

        <td align="center">

				<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $task;?>')">

				<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />

				</a>

				</td>

         <td align="left"><?php echo ($row->limit !=='0')?$row->limit:JText::_( 'DT_DISCOUNT_CODE_UNLIMITED'); ?></td>

         <td align="left"><?php echo ($d_code->used())?$d_code->uses:0; ?></td>

      <?php    $k = 1 - $k; echo  "</tr>" ; }

    } else { ?>

		<td align="center" colspan="9"><?php echo '<b>'. JText::_( 'DT_NO_DISCOUNT_CODE') . '</b>'; ?></td>

	<?php } ?>

    </table>

    <input type="hidden" name="option" value="<?php echo $option;?>" />

    <input type="hidden" name="task" value="" />

    <input type="hidden" name="boxchecked" value="" />

    </form>

    <?php 

}

function editDiscountCode($option,$dt_code){

	$tip = '/components/com_dtregister/assets/images/tooltip.png';

	?>

    <form name="adminForm" id="updateDiscountCode" method="post" action="index2.php">

   <table width="100%" class="adminform" border="1">

			<tbody>

			<tr>

				<th colspan="3"><?php echo JText::_( 'DT_DETAILS');?></th>

			</tr>

			<tr>

				<td width="20%" align="left" valign="top"><?php echo JText::_( 'DT_NAME');?>:</td>

				<td valign="top" align="left" width="30%">

				<input class="text_area" type="text" name="name" size="30" maxlength="50" value="<?php echo $dt_code->name?>"  />

				</td>

					<td valign="top" align="left">
                       <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_NAME_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow  type1 type3 type4" >

				<td><?php echo JText::_( 'DT_START_DATE');?>:</td>

				<td align="center">

				<?php echo JHTML::_("calendar",$dt_code->start,"start","start",'%Y-%m-%d %H:%M:%S',array('size'=>'25','showsTime'=>'true')); ?>

				</td>

					<td valign="top" align="left">
                       <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_STARTDATE_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow type1 type3 type4">

				<td><?php echo JText::_( 'DT_END_DATE');?>:</td>

				<td align="center">

					<?php echo JHTML::_("calendar", $dt_code->end,"end","end",'%Y-%m-%d %H:%M:%S',array('size'=>25,'showsTime'=>'true')); ?>

				</td>

					<td valign="top" align="left">
                     <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_ENDDATE_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

            <tr class="typeshow type1 type3 type4">

				<td><?php echo JText::_( 'DT_DISCOUNT_CODE_LIMIT');?>:</td>

				<td align="center">

                    <input class="text_area" type="text" name="limit" size="10" maxlength="4" value="<?php echo $dt_code->limit;?>" />

				</td>

					<td valign="top" align="left">
                      <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_CODE_LIMIT_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow type1 type3 type4">

				<td><?php echo JText::_( 'DT_PUBLISH');?>:</td>

				<td>

                  <?php

					   			  $options=array();

								   $options[]=JHTML::_('select.option',"0",JText::_( 'NO'));

								   $options[]=JHTML::_('select.option',"1",JText::_( 'YES'));

								   echo JHTML::_('select.genericlist',$options,"publish","","value","text",$dt_code->publish);

								   ?>

				</td>

				</td>

					<td valign="top" align="left">
                     <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_PUBLISH_HELP' )), '', 'tooltip.png', '', ''); ?>
					
				</td>

			</tr>
            
            <tr class="typeshow type1 type3 type4">

				<td><?php echo JText::_( 'DT_ENABLE_FOR');?>:</td>

				<td>

                  <?php

					   			  $options=array();

								   $options[]=JHTML::_('select.option',"0",JText::_( 'DT_PER_EVENT'));

								   $options[]=JHTML::_('select.option',"1",JText::_( 'DT_ALL_EVENT'));

								   echo JHTML::_('select.genericlist',$options,"events_enable","","value","text",$dt_code->events_enable);

								   ?>

				</td>

				</td>

					<td valign="top" align="left">
                     <?php echo JHTML::tooltip((JText::_( 'DT_ENABLE_FOR_HELP' )), '', 'tooltip.png', '', ''); ?>
					
				</td>

			</tr>

			<tr class="typeshow  type1 type3 type4">

				<td><?php echo JText::_( 'DT_CODE_DISCOUNT_TYPE');?>:</td>

				<td align="center">

               <?php

				 $options=array();

								   $options[]=JHTML::_('select.option',"1",JText::_( 'DT_AMOUNT'));

								   $options[]=JHTML::_('select.option',"2",JText::_( 'DT_PERCENTAGE'));

								   echo JHTML::_('select.genericlist',$options,"discount_type","","value","text",$dt_code->discount_type);

				?>

				</td>

					<td valign="top" align="left">
                          <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_TYPE_HELP' )), '', 'tooltip.png', '', ''); ?>
				
					</td>

			</tr>

			<tr class="typeshow  type2">

				<td><?php echo JText::_( 'DT_AMOUNT');?>:</td>

				<td align="center">

					<input class="text_area" type="text" name="amount" size="10" maxlength="250" value="<?php echo $dt_code->amount; ?>" />

				</td>

					<td valign="top" align="left">
                      <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_AMOUNT_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow  type2">

				<td><?php echo JText::_( 'DT_DISCOUNT_CODE');?>:</td>

				<td align="center">

					<input class="text_area" type="text" name="code" size="10" maxlength="250" value="<?php echo $dt_code->code; ?>" />

				</td>

					<td valign="top" align="left">
                     <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_CODE_HELP' )), '', 'tooltip.png', '', ''); ?>
				
					</td>

			</tr>

			</tbody>

		</table>

    <input type="hidden" name="option" value="<?php echo $option;?>" />

	 <input type="hidden" name="id" value="<?php echo $dt_code->id?>" />

     <input type="hidden" name="task" value="" />

    </form>

     <script src="../components/com_dtregister/assets/js/jquery.js" language="javascript" type="text/javascript"></script>

     <script src="../components/com_dtregister/assets/js/form.js" language="javascript" type="text/javascript"></script>

     <script language="JavaScript" type="text/javascript">

	   DTjQuery(function(){

	   });

		 function submitbutton(pressbutton)

		{

			data = DTjQuery('#updateDiscountCode').formSerialize()+pressbutton+'&no_html=1';

			DTjQuery.post('index2.php', data,function(){},'script');

			return false;

		}

		</script>

    <?php 

}

function newDiscountCode($option){

	$tip = 'components/com_dtregister/assets/images/tooltip.png';

	?>

    <form name="adminForm" id="newDiscountCode" method="post"  action="index2.php">

    <table width="100%" class="adminform" border="1">

			<tbody>

			<tr>

				<th colspan="3"><?php echo JText::_( 'DT_DETAILS');?></th>

			</tr>

			<tr>

				<td width="20%" align="left" valign="top"><?php echo JText::_( 'DT_NAME');?>:</td>

				<td valign="top" align="left" width="30%">

				<input class="text_area" type="text" name="name" size="50" maxlength="50" value=""  />

				</td>

					<td valign="top" align="left">
                       <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_NAME_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow  type1 type3 type4" >

				<td><?php echo JText::_( 'DT_START_DATE');?>:</td>

				<td align="center">

				<?php echo JHTML::_("calendar",null,"start","start",'%Y-%m-%d %H:%M:%S',array('size'=>'25')); ?>

				</td>

					<td valign="top" align="left">
                    <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_STARTDATE_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow type1 type3 type4">

				<td><?php echo JText::_( 'DT_END_DATE');?>:</td>

				<td align="center">

					<?php echo JHTML::_("calendar",null,"end","end",'%Y-%m-%d %H:%M:%S',array('size'=>'25')); ?>

				</td>

					<td valign="top" align="left">
                      <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_ENDDATE_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

            <tr class="typeshow type1 type3 type4">

				<td><?php echo JText::_( 'DT_DISCOUNT_CODE_LIMIT');?>:</td>

				<td align="center">

                    <input class="text_area" type="text" name="limit" size="10" maxlength="4" value="" />

				</td>

					<td valign="top" align="left">
                    <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_CODE_LIMIT_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow type1 type3 type4">

				<td><?php echo JText::_( 'DT_PUBLISH');?>:</td>

				<td>

                  <?php

					   			  $options=array();

								   $options[]=JHTML::_('select.option', "0",JText::_( 'NO'));

								   $options[]=JHTML::_('select.option', "1",JText::_( 'YES'));

								   echo JHTML::_('select.genericlist',$options,"publish","","value","text");

								   ?>

				</td>

				</td>

					<td valign="top" align="left">
                     <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_PUBLISH_HELP' )), '', 'tooltip.png', '', ''); ?>
					
				</td>

			</tr>
             <tr class="typeshow type1 type3 type4">

				<td><?php echo JText::_( 'DT_ENABLE_FOR');?>:</td>

				<td>

                  <?php

					   			  $options=array();

								   $options[]=JHTML::_('select.option',"0",JText::_( 'DT_PER_EVENT'));

								   $options[]=JHTML::_('select.option',"1",JText::_( 'DT_ALL_EVENT'));

								   echo JHTML::_('select.genericlist',$options,"events_enable","","value","text");

								   ?>

				</td>

				</td>

					<td valign="top" align="left">
                     <?php echo JHTML::tooltip((JText::_( 'DT_ENABLE_FOR_HELP' )), '', 'tooltip.png', '', ''); ?>
					
				</td>

			</tr>

			<tr class="typeshow  type1 type3 type4">

				<td><?php echo JText::_( 'DT_CODE_DISCOUNT_TYPE');?>:</td>

				<td align="center">

         <?php

				 $options=array();

								   $options[]=JHTML::_('select.option', "1",JText::_( 'DT_AMOUNT'));

								   $options[]=JHTML::_('select.option', "2",JText::_( 'DT_PERCENTAGE'));

								   echo JHTML::_('select.genericlist',$options,"discount_type","","value","text");

				 ?>

				</td>

					<td valign="top" align="left">
                      <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_TYPE_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow  type2">

				<td><?php echo JText::_( 'DT_AMOUNT');?>:</td>

				<td align="center">

					<input class="text_area" type="text" name="amount" size="10" maxlength="250" value="" />

				</td>

					<td valign="top" align="left">
                      <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_AMOUNT_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			<tr class="typeshow  type2">

				<td><?php echo JText::_( 'DT_DISCOUNT_CODE');?>:</td>

				<td align="center">

					<input class="text_area" type="text" name="code" size="10" maxlength="250" value="" />

				</td>

					<td valign="top" align="left">
                      
                      <?php echo JHTML::tooltip((JText::_( 'DT_DISCOUNT_CODE_HELP' )), '', 'tooltip.png', '', ''); ?>
					
					</td>

			</tr>

			</tbody>

		</table>

    <input type="hidden" name="option" value="<?php echo $option;?>" />

    <input type="hidden" name="task" value="" />

    </form>

     <script src="../components/com_dtregister/assets/js/jquery.js" language="javascript" type="text/javascript"></script>

     <script src="../components/com_dtregister/assets/js/form.js" language="javascript" type="text/javascript"></script>

     <script language="JavaScript" type="text/javascript">

	   DTjQuery(function(){

	   });

		 function submitbutton(pressbutton)

		{

			data = DTjQuery('#newDiscountCode').formSerialize()+pressbutton+'&no_html=1';

			DTjQuery.post('index2.php', data,function(){},'script');

			return false;

		}

		</script>

    <?php 

}

function discount_codes_list($eventID=null){

	$dt_code =  new DiscountCode();

	$data = $dt_code->getcodes(' publish=1 ');

	 if($eventID!=null){

		$event = new Event($eventID);

		$dt_codes = $event->getdiscount_codes();

	 }else{

	 	$dt_codes = array();

	 }

	$chunk = array_chunk($data,4);

	$html = "<tr><th colspan='4' style='background: #d3e8c1; padding:5px;'>". JText::_( 'DT_DISCOUNT_CODES') ."</th></tr>";

	foreach($chunk as $data){

		$html .='<tr>';

		foreach($data as $value){

			if(in_array($value->id,$dt_codes)){

				$checked = 'checked';

			}else{

				$checked = '';

			}

						$html .='<td><input type="checkbox" name="discount_code_id[]" '.$checked .' value="'.$value->id.'" />&nbsp; '.$value->name.'</td>';

		}

		$html .='</tr>';

	}

	return $html;

}

function showEventEmailForm($option,$lists)

{

	global $mainframe;

?>

	<form name="adminForm" id="emailRegitration" method="post" action="index2.php">

	  <table cellpadding="4" cellspacing="1" border="0" >

    <tr><td colspan="4"><?php echo JText::_( 'DT_EMAIL_REG_INSTRUCTIONS' ); ?></td></tr>

	  <tr><td><?php echo JText::_( 'DT_FROM_NAME' ); ?>:</td><td><input type="text" name="from_name" size="50" value="<?php echo $mainframe->getCfg('fromname');?>" /></td>
     <td></td>
       <td rowspan="6" valign="bottom">
    
          <div style="padding:5px 5px 5px 15px;">
                 
                 <br />[TITLE] - <?php echo JText::_( 'DT_TAG_TITLE' );?>

                 <br />[NAME] - <?php echo JText::_( 'DT_TAG_NAME' );?>
                 
                 <br />[FIRSTNAME] - <?php echo JText::_( 'DT_TAG_FIRSTNAME' );?>

                 <br />[ORGANIZATION] - <?php echo JText::_( 'DT_TAG_ORGANIZATION' );?>

                 <br />[EVENT_NAME] - <?php echo JText::_( 'DT_TAG_EVENT_NAME' );?>

                 <br />[EVENT_DATE] - <?php echo JText::_( 'DT_TAG_EVENT_DATE' );?>
                 
                 <br />[LOCATION] - <?php echo JText::_( 'DT_TAG_LOCATION' );?>
                 
                 <br />[LOCATION_DETAILS] - <?php echo JText::_( 'DT_TAG_LOCATION_DETAILS' );?>

                 <br />[CONTACT_DETAILS] - <?php echo JText::_( 'DT_TAG_CONTACT_DETAILS' );?>

                 <br />[GROUP_NAMES] - <?php echo JText::_( 'DT_TAG_GROUP_NAMES' );?>

                 <br />[GROUP_NUMBER] - <?php echo JText::_( 'DT_TAG_GROUP_NUMBER' ); ?>

                 <br />[AMOUNT] - <?php echo JText::_( 'DT_TAG_AMOUNT' );?>
                 
                 <br />[AMOUNT_PAID] - <?php echo JText::_( 'DT_TAG_AMOUNT_PAID' );?>
                 
                 <br />[AMOUNT_DUE] - <?php echo JText::_( 'DT_TAG_AMOUNT_DUE' );?>

                 <br />[PAYMENT_TYPE] - <?php echo JText::_( 'DT_TAG_PAYMENT_TYPE' );?>

                 <br />[CONTACT_CUSTOM_FIELDS] - <?php echo  JText::_( 'DT_TAG_CONTACT_CUSTOM_FIELDS' );?>

                 <br />[GROUP_CUSTOM_FIELDS] - <?php echo  JText::_( 'DT_TAG_GROUP_CUSTOM_FIELDS' );?>

                 <br />[FIELDX] - <?php echo JText::_( 'DT_TAG_FIELDS' );?>

                 <br />[CONFIRM_NUM] - <?php echo JText::_( 'DT_TAG_CONFIRM_NUM' );?>
                 
                 <br />[STATUS] - <?php echo JText::_( 'DT_TAG_STATUS' );?>
                 
                 <br />[PAID_STATUS] - <?php echo JText::_( 'DT_TAG_PAID_STATUS' );?>
                 
                 <br />[USERNAME] - <?php echo JText::_( 'DT_TAG_USERNAME' );?>

                 </div>
                 
        </td>
    
    </tr>

	  <tr><td><?php echo JText::_( 'DT_FROM_EMAIL' ); ?>:</td><td><input type="text" name="from_email" size="50" value="<?php echo $mainframe->getCfg('mailfrom');?>" /></td><td></td></tr>

		<tr><td><?php echo JText::_( 'DT_SELECT_EVENT' ); ?>:</td><td><?php echo $lists['event_list'];?></td><td></td></tr>

		<tr><td><?php echo JText::_( 'DT_SUBJECT' ); ?>:</td><td><input type="text" name="subject" size="50" /></td><td></td></tr>
        
        <tr><td><?php echo JText::_( 'DT_BCC' ); ?>:</td><td><input type="text" name="bcc" size="50" /> &nbsp; &nbsp;<?php echo JHTML::tooltip((JText::_( 'DT_BCC_HELP' )), '', 'tooltip.png', '', ''); ?></td><td>
         
        </td></tr>

		<tr>

			<td valign="top" style="width:100px;"><?php echo JText::_( 'DT_MESSAGE' ); ?>:</td>

			<td >

				<?php

					$editor =& JFactory::getEditor();

					if ($mainframe->getCfg('com_show_editor_buttons')) {

                    	$t_buttons = explode(',', $mainframe->getCfg('com_editor_button_exceptions'));

                    } else {

                    	// hide all

                        $t_buttons = false;

                    }

                    echo $editor->display( 'content', isset($row->content)?$row->content:'',  "100%", 250, '70', '10',  $t_buttons) ;

				?>

			</td>

		</tr>

	</table>

	<input type="hidden" name="option" value="<?php echo $option?>" />

	<input type="hidden" name="task" value="" />

</form>

     <script src="../components/com_dtregister/assets/js/jquery.js" language="javascript" type="text/javascript"></script>

     <script src="../components/com_dtregister/assets/js/form.js" language="javascript" type="text/javascript"></script>

     <script language="JavaScript" type="text/javascript">

	   DTjQuery(function(){

	   });

		 function submitbutton(pressbutton)

		{

			data = DTjQuery('#emailRegitration').formSerialize()+pressbutton+'&no_html=1';

			DTjQuery.post('index2.php', data,function(){},'script');

			return false;

		}

		</script>

<?php

}

function editmember($option, &$rows,$lists,$dt_event){

 $user = &JFactory::getUser();

 $database = &JFactory::getDBO();

 $mosConfig_live_site = JURI::base( true );

 foreach($rows as $row){

 $userid=$row->userId;
 
 $firstname=$row->userFirstName;

 $lastname=$row->userLastName;

 $organization=$row->userOrganization;

 $address=$row->userAddress;

 $address2=$row->userAddress2;

 $city=$row->userCity;

 $state=$row->userState;

 $country=$row->userCountry;

 $zip=$row->userZip;

 $phone=$row->userPhone;

 $email=$row->userEmail;
 
 $paid_amount =numberFormat($row->paid_amount,2);

 require("../components/com_dtregister/config.dtregister.php");

 $event = tmpl_event_name($event_show_date,$row->summary,get_date($row->dtstart,$row->dtend));

 $gtype=$row->userType;

 $paymentType=$row->payment_type;

 $pay_later_paid=$row->pay_later_paid;

 if(!$pay_later_paid)

 $pay_later_paid=0;

 //if($paymentType=="Pay Later")

if(1)

 {

 	$lists["pay_later_paid"]=JHTMLSelect::booleanlist("pay_later_paid","",$pay_later_paid);

 }

 }

 $eventId = $row->eventId;

 $sql="Select use_discountcode from #__dtregister_group_event where eventId=$eventId limit 0,1";

 $database->setQuery($sql);

 require_once("../components/com_dtregister/class.dtregister.php");

 $use_discountcode=$database->loadResult();

 $dt_code = new DiscountCode($row->discount_code_id);

 $discount_code = $dt_code->code;

 ?>
<script src="<?php echo JURI::root(true) ?>/components/com_dtregister/assets/js/jquery.js" type="text/javascript"></script>
<script src="<?php echo JURI::root(true) ?>/components/com_dtregister/assets/js/textareaCounter.js" type="text/javascript"></script>
  <script type="text/javascript">

  function submitbutton(pressbutton){

  if(document.adminForm.eventId.value==""){

  alert("Please Select Event");

  document.adminForm.eventId.focus();

  return;

  }

  if(document.adminForm.firstname.value==""){

  alert("Please enter first name");

  document.adminForm.firstname.select();

  document.adminForm.firstname.focus();

  return;

  }

  if(document.adminForm.lastname.value==""){

  alert("Please enter last name");

  document.adminForm.lastname.select();

  document.adminForm.lastname.focus();

  return;

  }

  if(document.adminForm.payment_type.value==''){

  alert('Please Select Payment Type');

  frm.payment_type.focus();

  return;

  }

  if(pressbutton =="savememberapply"){

  document.adminForm.redirect.value = 'no';

  pressbutton = "savemember" ;

  }

  submitform(pressbutton);

  }

 </script>


 <form name="adminForm" method="post" action="index2.php"  enctype="multipart/form-data">

  <table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminlist"  >
<tbody>
<tr><td><?php echo JText::_( 'DT_EVENT' ); ?>:</td><td><?php echo  $lists["events"];?></td>
<td>&nbsp;</td>
</tr>

<tr><td><?php echo JText::_( 'DT_STATUS' ); ?>:</td><td><?php echo $lists["status"]; ?></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_USERID' ); ?>:</td><td><?php echo $lists["users"]; ?></td><td>&nbsp;</td></tr>

<?php if($use_discountcode){ ?>

<tr><td><?php echo JText::_( 'DT_DISCOUNT_CODE' ); ?>:</td><td><input type="text" name="discount_code"  class="inputbox" value="<?php echo $discount_code; ?>" /></td><td>&nbsp;</td></tr>

<?php } ?>

<tr><td><?php echo JText::_( 'DT_TRANSACTION_ID' ); ?>:</td><td><input type="text" name="transaction_id"  class="inputbox" value="<?php echo $row->transaction_id; ?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_TITLE' ); ?>:</td><td><?php echo $lists['titles'];?></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_FIRSTNAME' ); ?>:</td><td><input type="text" name="firstname" value="<?php echo stripslashes($firstname);?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_LASTNAME' ); ?>:</td><td><input type="text" name="lastname" value="<?php echo stripslashes($lastname);?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_ORGANIZATION' ); ?>:</td><td><input type="text" name="organization" value="<?php echo stripslashes(htmlspecialchars($organization));?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_ADDRESS' ); ?>:</td><td><input type="text" name="address" value="<?php echo stripslashes($address);?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_ADDRESS2' ); ?>:</td><td><input type="text" name="address2" value="<?php echo stripslashes($address2);?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_CITY' ); ?>:</td><td><input type="text" name="city" value="<?php echo stripslashes($city);?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_STATE' ); ?>:</td><td><input type="text" name="state" value="<?php echo stripslashes($state);?>" /></td><td>&nbsp;</td></tr>

<?php require("../components/com_dtregister/country.htm")?>

<tr><td><?php echo JText::_( 'DT_ZIPCODE' ); ?>:</td><td><input type="text" name="zip" value="<?php echo stripslashes($zip);?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_PHONE' ); ?>:</td><td><input type="text" name="phone" value="<?php echo stripslashes($phone);?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_EMAIL' ); ?>:</td><td><input type="text" name="email" value="<?php echo stripslashes($email);?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_AMOUNT_PAID'); ?>:</td><td><input type="text" name="paid_amount" value="<?php echo stripslashes($paid_amount);?>" /></td><td>&nbsp;</td></tr>

<?php 

//if($paymentType=="Pay Later")	{ 

if(1){

?>

		<tr><td><?php echo JText::_( 'DT_PAY_LATER_PAID' ) ;?></td><td><?php echo $lists["pay_later_paid"]; ?></td><td>&nbsp;</td></tr>

<?php	} ?>

<tr><td><?php echo JText::_( 'DT_PAYMENT_METHOD' ); ?>:</td><td><?php echo $lists['payment_type'];?></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_AMOUNT' ); ?>:</td><td><input type="text" name="amount" value="<?php echo $row->amount;?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_CONFIRMATION_NUMBER' ); ?>:</td><td><input type="text" name="confirmNum" value="<?php echo $row->confirmNum;?>" /></td><td>&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_ATTENDED' ); ?>:</td><td><?php echo $lists['attend'];?></td><td>&nbsp;</td></tr>

<?php

echo $dt_event->field_html(($gtype == 'I')?'I':'B',$rows[0],true,'adminForm'); 


$dt_user = new DT_user($row->userId);

$html = $dt_user->barCodeImg() ;

if($html!=""){
   ?>
   <tr>
      <td><?php echo JText::_( 'DT_BARCODE' ); ?>:</td>
      
      <td><?php echo $html; ?></td>
   </tr>
 <?php  
}

?>

<tr>
 <td colspan="3">
    <input type="hidden" name="task" value="savemember">

 <input type="hidden" name="option" value="<?php echo $option;?>">

 <input type="hidden" name="uid" value="<?php echo $userid; ?>">
 
 <input type="hidden" name="type" value="">

 <input type="hidden"  name="gtype" value="<?php echo $gtype;?>">

  <input type="hidden"  name="redirect" value="yes">
 </td>
</tr>
 </tbody>
 </table>

</form>

<script>
    
	DTjQuery(function(){
  DTjQuery('.upload').live('click',function(){
	   
	   DTjQuery(this.form).attr('target','fileupload');
	   prevtask = DTjQuery(this.form.task).val();
	   prevtype = DTjQuery(this.form.type).val();
	   var filesizes = DTjQuery(this).attr('filesize');
	   var filetype = DTjQuery(this).attr('filetype');
	   var name = DTjQuery(this).attr('filename');
	  
	   DTjQuery(this.form.type).val(name+'|'+filesizes+'|'+filetype);
	   
	   DTjQuery(this.form.task).val('fileupload');
	   DTjQuery(this.form.option).val('com_dtregister');
	   DTjQuery(this.form.option).val('com_dtregister');
	   
	   DTjQuery(this.form).submit();
	   
	   DTjQuery(this.form.task).val(prevtask);
	   DTjQuery(this.form.type).val(prevtype);
	   DTjQuery(this.form).attr('target','');
	   return false;
	});
})
	document.adminForm.country.value = "<?php echo $country; ?>";
</script>
	<?php

   }

   function showregistrations($option, &$rows, $pageNav,$eventId ,$lists,$sort){

		global $mainframe;

   		include(JPATH_SITE."/components/com_dtregister/config.dtregister.php");

		?>

		<form action="index2.php" method="post" name="adminForm">

		<table class="adminheading" border="0" width="100%">

		<tr>
      <td colspan="12">
      <table>
      <tr>
			<th colspan="4" style="width:250px;"><?php echo JText::_( 'DT_REGISTRATION_MANAGER' ); ?></th>

			<td><?php echo JText::_( 'DT_SELECT_EVENT' ); ?>:</td>

			<td><?php echo $lists["event_list"];?></td>

			<td><?php echo JText::_( 'DT_SHOW_FAILED' ); ?>:</td>

			<td><?php echo $lists['show_failed'];?></td>
      <td><?php echo JText::_( 'DT_ATTENDED' ); ?>:</td>

			<td><?php echo $lists['show_attend'];?></td>
      <td><?php echo $lists['status'];?></td>
      <td>
      <?php

		  $options=array();

      $options[]=JHTML::_('select.option',"-1",JText::_( 'DT_HIDE_ARCHIVE' ));

	    $options[]=JHTML::_('select.option',"1",JText::_( 'DT_SHOW_ARCHIVE' ));

	    $options[]=JHTML::_('select.option',"0",JText::_( 'DT_ALL_EVENT' ));

      $archive = JRequest::getVar('archive',-1) ;

	    echo JHTML::_('select.genericlist', $options,"archive",' onchange="submit()" ',"value","text",$archive);

			?>
      </td>
      </tr>
      </table>
      </td>
		</tr>

		<tr>
      <td colspan="12">
      <table>
      <tr>
		  <td colspan="9">

		  <ul>

      <li>Use the "Select Event" dropdown filter above to show records from only a specific event.

      <li>To see records of failed Authorize.net registration attempts due to failed payments, select "Yes" on the "Show Failed Attempts" dropdown filter above.</li>

      <li>To add new records manually, click either "Group Registration" or "Individual Registration" in the top right after first selecting an event in the dropdown.</li>

      <li>To sort the records, click the column title.  Click it again to re-sort the opposite direction.</li>

      </ul>

		  </td>
          <td width="200px">
           &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;
          </td>
          <td colspan="2" >
           <?php $search = JRequest::getVar('search','') ; ?>
            <?php echo JText::_('DT_SEARCH');?>:<input type="text" size="30" name="search" value="<?php echo addslashes($search);?>" /><input type="submit" value="Go" />
          </td>
          </tr>
          </table>
          </td>
		</tr>

		</table>

		<table class="adminlist">

		<tr>

			<th width="5">#</th>

			<th width="20">

				<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" />

			</th>

			<th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=name&dir='.$sort.'>' . JText::_( 'DT_ADMIN_REGISTRANT_NAME' ) . "</a>"; ?></th>

			<th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=email&dir='.$sort.'>' . JText::_( 'DT_EMAIL' ) . "</a>"; ?></th>

			<th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=event&dir='.$sort.'>' . JText::_( 'DT_EVENT' ) . "</a>"; ?></th>

			<th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=amount&dir='.$sort.'>' . JText::_( 'DT_AMOUNT' ) . "</a>"; ?></th>

			<th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=date&dir='.$sort.'>' . JText::_( 'DT_REGISTER_DATE' ) . "</a>"; ?></th>

      <th><?php echo '<a href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=confirmNum&dir='.$sort.'>' .   JText::_( 'DT_CONFIRMATION_NUMBER' ). "</a>"; ?></th>

      <th><?php echo "<a class=\"sortheader\" href=".$mainframe->getSiteURL()."administrator/index2.php?option=com_dtregister&act=registrations&order=discount_code&dir=$sort>" .  JText::_( 'DT_DISCOUNT_CODE'). "</a>"; ?></th>

      <th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=type&dir='.$sort.'>' . JText::_( 'DT_PAYMENT_TYPE' ) . "</a>"; ?></th>

			<th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=paid&dir='.$sort.'>' . JText::_( 'DT_PAY_LATER_PAID' ) . "</a>"; ?></th>

			<th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=attend&dir='.$sort.'>' . JText::_( 'DT_ATTENDED' ) . "</a>"; ?></th>

			<th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=members&dir='.$sort.'>' . JText::_( 'DT_MEMBERS' ) . "</a>"; ?></th>

        <th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=due_amount&dir='.$sort.'>' . JText::_( 'DT_DUE_AMOUNT' ) . "</a>"; ?></th>
        
         <th><?php echo '<a class="sortheader" href='.$mainframe->getSiteURL().'administrator/index2.php?option=com_dtregister&act=registrations&order=cancel&dir='.$sort.'>' . JText::_( 'DT_STATUS' ) . "</a>"; ?></th>

		</tr>

		<?php

		$k = 0;

		for ($i=0, $n=count( $rows ); $i < $n; $i++) {

			$row = &$rows[$i];

			$link = 'index2.php?option=com_dtregister&task=editmemberA&hidemainmenu=1&id='. $row->id;

			// Paid Status

				$img 	= $row->pay_later_paid ? 'publish_g.png' : 'publish_x.png';

				$alt 	= $row->pay_later_paid ? 'Paid' : 'Un paid';

				$task 	= $row->pay_later_paid ? 'un_paid' : 'paid';

			?>

			<tr class="<?php echo "row$k"; ?>">

				<td>

				<?php echo $pageNav->getRowOffset( $i ); ?>

				</td>

				<td>

				 <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" />

				</td>

				<td align="center"><a href="<?php echo $link?>"><?php  echo str_replace("''","'",stripslashes($row->userFirstName));?>&nbsp;<?php echo str_replace("''","'",stripslashes($row->userLastName));?></a></td>

				<td align="center"><a href="mailto:<?php echo stripslashes($row->userEmail);?>"><?php echo stripslashes($row->userEmail);?></a></td>

				<td align="center"><?php echo tmpl_event_name($event_show_date,$row->summary,get_date($row->dtstart,$row->dtend));?> </td>

				<td align="center"><?php echo numberFormat($row->amount,2);?></td>

				<td align="center"><?php echo get_date($row->register_date);?></td>

        <td align="center"><?php echo $row->confirmNum;?></td>

        <td align="center"><?php echo isset($row->code)?$row->code:'';?></td>

        <td align="center">

					<?php
             global $lang_var ;
					if($row->payment_type=='Pay Later'){

							$paylater_values = array(1=>'At_door',2=>'Mail',3=>'Phone');

							$row->payment_type = $paylater_values[$row->pay_later_option];

						}

						if($row->payment_type==JText::_( 'DT_SELECT_PAY_OPTIONS' ))

						{

							$payLaterOption=$row->pay_later_option;

							$arrPaymentType=array();

							$arrPaymentType[]=JText::_( 'DT_PAY_AT_DOOR' );

							$arrPaymentType[]=JText::_( 'DT_MAILIN_PAYMENT' );

							$arrPaymentType[]=JText::_( 'DT_CALLIN_PAYMENT' );

							echo $row->payment_type."(".$arrPaymentType[$payLaterOption-1].")";

						}

						else

						{

            echo $lang_var[$row->payment_type];	

            }

            ?>

				</td>

				<td align="center">

					<?php

						if($row->payment_type=="Mail" || $row->payment_type=="Phone" || $row->payment_type=="At_door")

						{

						?>

							<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $task;?>')">

							<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />

							</a>

						<?php	} elseif($row->payment_type=="Paypal" || $row->payment_type=="PayPal" || $row->payment_type=='ideal' || $row->payment_type=='GoogleCheckout' || $row->payment_type=='NetDeposit' || $row->payment_type=='Eway'){ ?>

							<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $task;?>')">

							<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />

							</a>

						<?php

						} elseif(strstr($lang_var[$row->payment_type],"Authorize.net")!== false ){

								$img = $row->pay_later_paid 	 ? 'publish_g.png' : 'publish_x.png';

								$alt = $row->pay_later_paid 	 ? 'Paid' : 'Un paid';

							  $task = $row->pay_later_paid 	 ? 'un_paid' : 'paid';

								?>

							<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $task;?>')">

							<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />

							</a>

						<?php	}	?>

				</td>

				<td align="center">
                              
                            <?php
							  $task =($row->attend==0)?'attended':'un_attended';

							  $img =($row->attend==0)?'publish_x.png' : 'publish_g.png';
							
							?>

							<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $task;?>')">

							<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />

							</a>

				</td>

				<td align="center">

					<?php if($row->userType=='G'){?>

					<a href="<?php echo $mainframe->getSiteURL();?>administrator/index2.php?option=com_dtregister&task=showmembers&gid=<?php echo $row->groupId;?>&event_id=<?php echo $row->eventId?>"><?php echo $row->numberOfPerson;?> Members</a>

					<?php } ?>

				</td>

                <td align="center"><?php 
				  if($row->cancel == 1){
				    echo numberFormat($row->due_payment,2) ;
				  }else{
				    echo numberFormat(($row->amount-$row->paid_amount),2) ;
				  }
				
				?>
                
                </td>
                
                <td align="center"><?php 
				   switch ($row->cancel){
				       
					   case 0:
					      echo  JText::_( 'DT_ACTIVE' );
					   break;
					   
					   case 1:
					      echo  JText::_( 'DT_CANCELLED' );
					   break;
					   
					   case 2:
					      echo  JText::_( 'DT_PENDING' );
					   break;
				   }
				?></td>

			</tr>

			<?php $k = 1 - $k; }	?>

		</table>

		<?php echo $pageNav->getListFooter(); ?>

		<input type="hidden" name="option" value="<?php echo $option;?>" />

		<input type="hidden" name="task" value="listregistrations" />

        <input type="hidden" name="order" value="<?php echo Jrequest::getVar('order');?>" />

        <input type="hidden" name="dir" value="<?php echo Jrequest::getVar('dir');?>" />

		<input type="hidden" name="boxchecked" value="0" />

		<input type="hidden" name="hidemainmenu" value="0">

		</form>
         <script src="../components/com_dtregister/assets/js/jquery.js" language="javascript" type="text/javascript"></script>
		<script>
            
			  DTjQuery(function(){
			  
			    DTjQuery('.sortheader').click(function(){
					 
				  var href = DTjQuery(this).attr('href');
				  
                  var start = href.lastIndexOf('order') + 6;
				  var end = href.lastIndexOf('&');
				  document.adminForm.order.value = href.substring(start,end);
				  
				 var dirstart = href.lastIndexOf('=') + 1;
				 document.adminForm.dir.value = href.substring(dirstart);
				 
				 document.adminForm.submit();
				   return false;
				
				});
			});
			function submitbutton(pressbutton)

			{

				if(pressbutton=='newmember' || pressbutton=='new_group_registration')

				{

					var selectTag=document.adminForm.event_id;

					if(selectTag.value==0)

					{

						alert('You must select an event to create a new registration record');

						return;

					}

					else

					{

						submitform(pressbutton);

					}

				}

				else

				{

					submitform(pressbutton);

				}

			}

		</script>

		<?php

   }

 function editgroupmember(){

		//insertTable($arrMemberFields,$arrMemberValues,'#__dtregister_group_member');

   }

   function showmembers($option,$rows,$rowCustoms){
      
	   include( JPATH_SITE.'/administrator/components/com_dtregister/view/member/list.php');
   
   }

  function showGroups( $option, &$rows, &$search, &$pageNav,$lists) {
  
   include( JPATH_SITE.'/administrator/components/com_dtregister/view/events/list.php');

}

function editGroups( $option, $memberArr, $amountArr, $amountArrI, $amountArrPer, $lateFee, $dateLateFee, $eventtitle, $eventid,$email,$event_Id ,$maxRegistrations,$registrationType,$topmsg,$cutOffDate,$discount_type,$discount_amount,$thksmsg,$thksmsg_set,$event_describe,$event_describe_set,$terms_conditions_set,$terms_conditions_msg,$category,$waiting_list,$max_group_size,$public,$use_discountcode,$startdate,$bird_discount_date,$bird_discount_type,$bird_discount_amount,$publish,$payment_option,$partial_payment,$partial_amount,$partial_minimum_amount,$pay_later_thk_msg_set,$pay_later_thk_msg){
  include( JPATH_SITE.'/administrator/components/com_dtregister/view/events/edit.php');

}

##############################################################################

##############################################################################

function newGroups( $option, &$row, &$eventcopy =  array() ) {

  include( JPATH_SITE.'/administrator/components/com_dtregister/view/events/newgroup.php');

}

  // Here are functions for custom fields

  function showCustomFields( $option, &$rows, &$search, &$pageNav ) {
     
	 include( JPATH_SITE.'/administrator/components/com_dtregister/view/fields/list.php');
     
  }

	function editCustomfield( &$row,$option,$lists) {
	    
	    include( JPATH_SITE.'/administrator/components/com_dtregister/view/fields/edit.php');
	}

	//Added function heres

	function showEventWaiting($rows, $pageNav, $option,$lists) {
         
		 global $displaytime ,$option ,$mainframe ;
		 
		 include (JPATH_SITE.'/components/com_dtregister/config.dtregister.php');
		 if($displaytime < 1)
		  $displaytime = 2 ;
		
		$order_Dir = Jrequest::getVar('filter_order_Dir','asc');
	    $order     = Jrequest::getVar('filter_order','name');
        
		?>

		<form action="index2.php" method="post" name="adminForm">

		<table class="adminheading">

		<tr>

			<th style="width:300px;"><?php echo JText::_( 'DT_WAITING_LIST_MANAGER' );?></th>

			<td><?php echo JText::_( 'DT_SELECT_EVENT' );?></td>

			<td><?php	echo $lists["event_list"]; ?></td>

		</tr>

		</table>

		<table class="adminlist">

		<tr>

			<th width="2%" class="title">#</th>

			<th width="20px" class="title">

			<input type="checkbox" name="toggle" value="" onClick="checkAll(<?php echo count($rows); ?>);" />

			</th>

			<th  width="15%"><?php echo JHTML::_( 'grid.sort', JText::_( 'DT_EVENT_NAME' ), "summary", $order_Dir, $order); ?></th>

			<th><?php echo JHTML::_( 'grid.sort', JText::_( 'DT_ADMIN_REGISTRANT_NAME' ), "name", $order_Dir, $order); ?></th>

			<th><?php echo JHTML::_( 'grid.sort', JText::_( 'DT_REGISTER_DATE' ), "created", $order_Dir, $order); ?></th>

			<th><?php echo JHTML::_( 'grid.sort', JText::_( 'DT_PHONE' ), "phone", $order_Dir, $order); ?></th>

			<th><?php echo JHTML::_( 'grid.sort', JText::_( 'DT_EMAIL' ), "email", $order_Dir, $order); ?></th>

			<th><?php echo JHTML::_( 'grid.sort', JText::_( 'DT_COUNTRY' ), "country", $order_Dir, $order); ?></th>

			<th><?php echo JHTML::_( 'grid.sort', JText::_( 'DT_ZIPCODE' ), "zip", $order_Dir, $order); ?></th>

			<th><?php echo JHTML::_( 'grid.sort', JText::_( 'DT_REGISTRANTS' ), "number_registrants", $order_Dir, $order); ?></th>
            
		</tr>

		<?php

		$k = 0;

		for ($i = 0; $n = count($rows), $i < $n; $i++) {

			$row = $rows[$i];

			//$link = "";

			?>

			<tr class="<?php echo "row$k"; ?>">

				<td align="center">

				<?php echo $i+1+$pageNav->limitstart; ?>

				</td>

				<td width="20px">

				<input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" />

				</td>

				<td align="center">

				<?php echo $row->summary." (".get_date($row->dtstart,$row->dtend).")"; ?>

				</td>

				<td align="center">

				<a href="index.php?option=com_dtregister&task=detail_event_waiting&cid[]=<?php echo $row->id ; ?>"><?php echo $row->fname.' '.$row->lname; ?></a>

				</td>

				<td align="center">

				<?php echo get_date($row->created); ?>

				</td>

				<td align="center">

				<?php echo $row->phone; ?>

				</td>

				<td align="center">

				<?php echo $row->email; ?>

				</td>

				<td align="center">

				<?php echo $row->country; ?>

				</td>

				<td align="center">

				<?php echo $row->zip; ?>

				</td>

				<td align="center">

				<?php echo $row->number_registrants; ?>

				</td>
               
			</tr>

			<?php

			$k = 1 - $k;

		}

		?>

		</table>

		<?php echo $pageNav->getListFooter(); ?>

		<input type="hidden" name="option" value="<?php echo $option;?>" />

		<input type="hidden" name="task" value="show_event_waiting"/>

		<input type="hidden" name="boxchecked" value="0" />
        
        <input type="hidden" name="filter_order" value="<?php echo $order; ?>" />
        <input type="hidden" name="filter_order_Dir" value="<?php echo $order_Dir; ?>" />

		</form>

		<?php

	}

	function viewEventWaiting($row, $option) {
        
		$dt_event =  new Event($row->event_id);
		
		?>

		<form action="index2.php" method="post" name="adminForm" id="adminForm">

		<table class="adminheading">

		<tr>

			<th><?php echo JText::_( 'DT_WAITING_LIST_MANAGER' );?></th>

		</tr>

		</table>

		<table width="100%">

		<tr>

			<td width="60%" valign="top">

				<table class="adminform">

				<tr>

					<th colspan="2"><?php echo JText::_( 'DT_REGISTRATION_DETAILS' );?>:</th>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo (!isset($dt_event->summary))?JText::_( 'DT_EVENTID' ):JText::_( 'DT_EVENT_NAME' ) ; ?>:</td>

					<td><?php echo (!isset($dt_event->summary))?$row->event_id:$dt_event->summary ; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_FIRSTNAME' );?>:</td>

					<td><?php echo $row->fname; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_LASTNAME' );?>:</td>

					<td><?php echo $row->lname; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_PHONE' );?>:</td>

					<td><?php echo $row->phone; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_EMAIL' );?>:</td>

					<td><?php echo $row->email; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_ADDRESS' );?>:</td>

					<td><?php echo $row->address; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_STATE' );?>:</td>

					<td><?php echo $row->state; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_COUNTRY' );?>:</td>

					<td><?php echo $row->country; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_ZIPCODE' );?>:</td>

					<td><?php echo $row->zip; ?></td>

				</tr>

				<tr>

					<td width="20%" align="right"><?php echo JText::_( 'DT_REGISTRANTS' );?>:</td>

					<td><?php echo $row->number_registrants; ?></td>

				</tr>

				</table>

			</td>

		</tr>

		</table>

		</form>

		<?php

	}

	/* Code added here for manually created registration record */

function newMember($option,$eventId,$lists,$rowProfile,$dt_event)

{

 $mosConfig_live_site = JURI::base( true );

 $database = &JFactory::getDBO();

 //Get event title

  $sql='Select summary From #__jevents_vevdetail where evdet_id=' . $database->Quote( $eventId );

 $database->setQuery($sql);

 $event=$database->loadResult();

  $sql="Select use_discountcode from #__dtregister_group_event where eventId=$eventId limit 0,1";

$database->setQuery($sql);

require_once("../components/com_dtregister/class.dtregister.php");

 $use_discountcode=$database->loadResult();

 ?>
<script src="<?php echo Juri::root();  ?>/components/com_dtregister/assets/js/jquery.js" type="text/javascript"></script>
<script src="<?php echo Juri::root();  ?>/components/com_dtregister/assets/js/textareaCounter.js" type="text/javascript"></script>
  <script type="text/javascript">
 
DTjQuery(function(){
  DTjQuery('.upload').live('click',function(){
	   
	   DTjQuery(this.form).attr('target','fileupload');
	   prevtask = DTjQuery(this.form.task).val();
	   prevtype = DTjQuery(this.form.type).val();
	   var filesizes = DTjQuery(this).attr('filesize');
	   var filetype = DTjQuery(this).attr('filetype');
	   var name = DTjQuery(this).attr('filename');
	  
	   DTjQuery(this.form.type).val(name+'|'+filesizes+'|'+filetype);
	   
	   DTjQuery(this.form.task).val('fileupload');
	   DTjQuery(this.form.option).val('com_dtregister');
	   DTjQuery(this.form.option).val('com_dtregister');
	   
	   DTjQuery(this.form).submit();
	   
	   DTjQuery(this.form.task).val(prevtask);
	   DTjQuery(this.form.type).val(prevtype);
	   DTjQuery(this.form).attr('target','');
	   return false;
	});
})
  function submitbutton(pressbutton){

  if(pressbutton=="cancel_new_member")

  {

  	submitform(pressbutton);

  	return;

  }

   var frm= document.adminForm;

  if(document.adminForm.firstname.value==""){

  alert("Please enter first name");

  document.adminForm.firstname.select();

  document.adminForm.firstname.focus();

  return;

  }

   if(document.adminForm.lastname.value==""){

  alert("Please enter last name");

  document.adminForm.lastname.select();

  document.adminForm.lastname.focus();

  return;

  }

if(frm.payment_type.value==''){

  alert('Please Select Payment Type');

  frm.payment_type.focus();

  return;

  }

  	submitform(pressbutton);

  }

  </script>
<!-- Beginning of form in backend for manual insertion of registrants -->
<div style="display:none">
<iframe name="fileupload">

</iframe>
</div>
  <form name="adminForm" method="post" action="index2.php">

  <table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminlist"  >
  
<tr><td><?php echo JText::_( 'DT_EVENT' ); ?>:</td><td><b><?php echo $event;?></b></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_SELECT_USER' ); ?>:</td><td><b><?php echo $lists["user_list"] ;?></b></td><td  >&nbsp;</td></tr>

<?php if($use_discountcode){ ?>

<tr><td><?php echo JText::_( 'DT_DISCOUNT_CODE' ); ?>:</td><td><input type="text" name="discount_code" value="" class="inputbox" /></td><td  >&nbsp;</td></tr>

<?php } ?>
<tr><td width="30%" class="contentdescription"><?php echo JText::_( 'DT_TITLE' );?>:

	</td>

			<td width="68%" align="left" >
            <?php echo  $lists["titles"]; ?>
            </td>
            <td>&nbsp;</td>

</tr>
<tr><td><?php echo JText::_( 'DT_FIRSTNAME' ); ?>:</td><td><input type="text" name="firstname" value="<?php echo isset($rowProfile->firstname)?$rowProfile->firstname:''?>" /></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_LASTNAME' ); ?>:</td><td><input type="text" name="lastname" value="<?php echo isset($rowProfile->lastname)?$rowProfile->lastname:''?>" /></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_ORGANIZATION' ); ?>:</td><td><input type="text" name="organization" value="<?php echo isset($rowProfile->cb_company)?$rowProfile->cb_company:''?>" /></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_ADDRESS' ); ?>:</td><td><input type="text" name="address" value="<?php echo isset($rowProfile->cb_address)?$rowProfile->cb_address:''?>" /></td></tr>

<tr><td><?php echo JText::_( 'DT_ADDRESS2' ); ?>:</td><td><input type="text" name="address2" value="<?php echo isset($rowProfile->cb_address2)?$rowProfile->cb_address2:''?>" /></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_CITY' ); ?>:</td><td><input type="text" name="city" value="<?php echo isset($rowProfile->cb_city)?$rowProfile->cb_city:''?>" /></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_STATE' ); ?>:</td><td><input type="text" name="state" value="<?php echo isset($rowProfile->cb_state)?$rowProfile->cb_state:''?>" /></td></tr>

<?php require("../components/com_dtregister/country.htm")?>

<!--tr><td><?php echo JText::_( 'DT_COUNTRY' ); ?>:</td><td><input type="text" name="country" value="<?php echo isset($rowProfile->cb_country)?$rowProfile->cb_country:''?>" /></td></tr-->

<tr><td><?php echo JText::_( 'DT_ZIPCODE' ); ?>:</td><td><input type="text" name="zip" value="<?php echo isset($rowProfile->cb_zipcode)?$rowProfile->cb_zipcode:''?>" /></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_PHONE' ); ?>:</td><td><input type="text" name="phone" value="<?php echo isset($rowProfile->cb_phone)?$rowProfile->cb_phone:''?>" /></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_EMAIL' ); ?>:</td><td><input type="text" name="email" value="<?php echo isset($rowProfile->email)?$rowProfile->email:''?>" /></td><td  >&nbsp;</td></tr>
<tr><td><?php echo JText::_( 'DT_AMOUNT_PAID' ); ?>:</td><td><input type="text" name="paid_amount" value="" /></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_PAYMENT_METHOD' ); ?>:</td>

<td><?php echo $lists['payment_type'];?></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_PAY_LATER_PAID' ); ?>:</td>

<td><?php echo $lists['pay_later_paid'];?></td><td  >&nbsp;</td></tr>

<tr><td><?php echo JText::_( 'DT_SEND_EMAIL' ); ?>:</td><td><input checked="checked" type="checkbox" name="sendemail" value="1" /></td><td  >&nbsp;</td></tr>

<!-- Here are the code for showing custom fields-->
<?php
echo  $dt_event->field_html('I',null,true,'adminForm');
?>
<!-- End custom fields showing -->

 </table>

 <input type="hidden" name="task" value="newmember">

 <input type="hidden" name="option" value="<?php echo $option;?>">

 <input type="hidden" name="event_id" value="<?php echo $eventId ;?>" />

</form>

	<?php

}

//Added new function for group registration

function newGroupRegistration($option,$eventId,$rowEvent)

{

	// mosCommonHTML::loadOverlib();

	?>

	<script language="javascript" type="text/javascript">

	function submitbutton(pressbutton) {

		var form = document.adminForm;

		if (pressbutton == 'cancel_registration') {

			submitform( pressbutton );

			return;

		}

		if(!parseInt(form.memtot.value))

		{

			alert("Number of registrants must be an integer value");

			return;

		}

		if(form.memtot.value < 2)

		{

			alert("Number of registrants must be 2 or more");

			return;

		}

		//Submit form with pre-defined button

		submitform( pressbutton );

	}

	</script>

	<form action="index2.php" method="post" name="adminForm" id="adminForm">

	<table class="adminheading">

	<tr>

		<th>

			<?php echo JText::_( 'DT_GROUP_REGISTRATION' ); ?>:

		<small>

		<?php if(isset($row->id)){ echo $row->id ? 'Edit' : 'New';}?>

		</small>

		</th>

	</tr>

	</table>

	<table width="60%">

			<table class="adminform">

			<tr>

				<td width="20%" align="right">

				 	<?php echo JText::_( 'DT_REGISTRANTS' ); ?>

				</td>

				<td width="80%">

				<input class="text_area" type="text" name="memtot" size="30" maxlength="250"/>

				</td>

			</tr>

			</table>

		</td>

	</tr>

	</table>

	<input type="hidden" name="event_id" value="<?php echo $eventId ?>" />

	<input type="hidden" name="option" value="<?php echo $option;?>" />

	<input type="hidden" name="task" value="" />

	</form>

	<?php

}

function showcategories($option,$rows,&$pageNav) {

   		$mosConfig_live_site = JURI::base( true );

		?>

<script language="javascript">

			function savecategoryOrder(n,task)

			{

				for ( var j = 0; j <= n; j++ )

				{

					box = eval( "document.adminForm.cb" + j );

					if ( box ) {

						if ( box.checked == false ) {

							box.checked = true;

						}

					} else {

						alert("You cannot change the order of items, as an item in the list is `Checked Out`");

						return;

					}

				}

				submitform(task);

			}

		</script>

   <script language="javascript" type="text/javascript">

        function hideMainMenu()

       {

    window.location = "index2.php?option=com_dtregister&task=newcategory&hidemainmenu=1";

        }

function submitbutton(pressbutton) {

var form = document.adminForm;

		if (pressbutton) {

			submitform( pressbutton );

			return;

		}

// window.location = "index2.php?option=com_dtregister&task=newcategory&hidemainmenu=1";

}

</script>

		<form action="index2.php" method="post" name="adminForm">

    <p><?php echo JText::_( 'DT_CATEGORY_INSTRUCTIONS'); ?></p>

		<table class="adminheading">

	  <tr>

		<th colspan="5" style="width:500px;"><?php echo JText::_( 'DT_CATEGORY_MANAGER' ); ?></th>

		</tr>

		</table>

		<table class="adminlist" align="left">

		<tr>

			<th width="20"><input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" /></th>

			<th width="5" align="left">#</th>

			<th width="5" align="left" ><?php echo JText::_( 'DT_CATEGORY_ID' ); ?></th>

			<th width="255" align="left"><?php echo JText::_( 'DT_CATEGORY_NAME' ); ?></th>
            
            <th width="255" align="left"><?php echo JText::_( 'DT_PARENT_CATEGORY' ); ?></th>

	    <th class="title" colspan="2" nowrap width="5%"><?php echo JText::_( 'DT_REORDER' ); ?>:</th>

      <th width="2%"><?php echo JText::_( 'DT_ORDER' );?>       		<a href="javascript:savecategoryOrder( <?php echo count( $rows )-1; ?>,'saveorder_category')"><img src="images/filesave.png" border="0" width="16" height="16" alt="<?php echo JText::_( 'DT_SAVE_ORDER' ); ?>" /></a></th>

      <th width="5" align="left"><?php echo JText::_( 'DT_DELETE' ); ?></th>

		</tr>

		<?php
         $children = array();
        foreach ($rows as $v )
		{
			$pt = $v->parent_id;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}
		
	    $catlist=array();
		  if(isset($children[0]) && is_array($children[0]))
		  foreach($children[0] as $pcategory){
		   $catlist[]=$pcategory;
		   if(isset($children[$pcategory->categoryId])){
		       foreach($children[$pcategory->categoryId] as $childcat){
			       
				   $childcat->categoryName = "|_".$childcat->categoryName ;
			       $catlist[]=$childcat;
			   }
		   }
		}
		$rows = $catlist ;
		$k = 0;
        for ($i=0, $n=count( $rows ); $i < $n; $i++) {

       	$row = &$rows[$i];

	$link1 = 'index2.php?option=com_dtregister&task=editcategory&hidemainmenu=1&id='. $row->categoryId;

    $link2 = 'index2.php?option=com_dtregister&task=deletecategory&hidemainmenu=1&id='. $row->categoryId;

		?>

	<tr class="<?php echo "row$k"; ?>">

    <td>

      <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->categoryId; ?>" onclick="isChecked(this.checked);" />

    </td>

		<td><?php echo $k+1; ?></td>

    <td><?php echo $row->categoryId;?></td>

		<td><a href="<?php echo $link1?>"><?php echo $row->categoryName;?></a></td>
        
        <td>
         <?php
		  $database = &JFactory::getDBO();
          $parent =  new mosDtCategory($database);
		  $parent->load($row->parent_id);
		  echo $parent->categoryName;
		 ?>
        
        </td>
        
    <td>

        <span><?php echo $pageNav->orderUpIcon( $i, true, 'orderup_category', 'Move Up' ); ?></span>

    </td>

		<td>

        <span><?php echo $pageNav->orderDownIcon( $i, $n ,true,'orderdown_category', 'Move Down'); ?></span>

    </td>

    <td align="center" >

				<input type="text" name="order[]" size="5" value="<?php echo $row->ordering; ?>" class="text_area" style="text-align: center" />

		</td>

    <td><a href="<?php echo $link2?>"><strong>X</strong></a></td>

	  <?php $k = $k+ 1; } ?>

	  </td>

	</tr>

	</table>

  <input type="hidden" name="option" value="<?php echo $option;?>" />

	<input type="hidden" name="task"  value="" />

  <input type="hidden" name="boxchecked" value="0" />

	</form>

	<?php

	}

function editingcategory($option, $row){

 $mosConfig_live_site = JURI::base( true );

 $database = &JFactory::getDBO();
 
 $dtcat = new mosDtCategory($database);
 $dtcat->load($row[0]->categoryId);
 $catid=$row[0]->categoryId;
 
 $catname=$row[0]->categoryName;
 $query = "Select * from #__dtregister_categories where parent_id=0 and categoryId <> $catid";
   
   $database->setQuery($query);
   $rows=$database->loadObjectList();
   $options = array();
   $options[] = JHTML::_('select.option',0,JText::_( 'DT_SELECT_PARENT' ));
   if(!$dtcat->hasChild())
   foreach($rows as $cat){
      
	  $options[] = JHTML::_('select.option',$cat->categoryId,$cat->categoryName);
	  
   }
   $list['parent_id'] = JHTML::_('select.genericlist', $options,"parent_id","","value","text",$row[0]->parent_id);

?>

<form action="index2.php" method="post" name="adminForm" id="adminForm">

<table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminlist"  >

<tr><td><?php echo JText::_( 'DT_CATEGORY_ID' ); ?>:</td><td><?php echo $catid;?></td>

<td><?php echo JText::_( 'DT_CATEGORY_NAME' ); ?>:</td><td><input type="text" name="catname" size="80" value="<?php echo stripslashes($catname);?>" /></td>
<td><?php echo $list['parent_id']; ?></td>
</tr>

</table>

 <input type="hidden" name="task" value="savecategory">

 <input type="hidden" name="option" value="<?php echo $option;?>">

 <input type="hidden" name="catid" value="<?php echo $catid;?>">

</form>

	<?php

}

function new_category($option,$list){

 $mosConfig_live_site = JURI::base( true );

		?>

<script language="javascript" src="<?php echo $mosConfig_live_site ?>/includes/js/joomla.javascript.js"></script>

<form action="index2.php" method="post" name="adminForm" id="adminForm">

<p><?php echo JText::_( 'DT_CATEGORY_INSTRUCTIONS' ); ?></p>

<table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminlist"  >
<tr>
<td width="200"><?php echo JText::_( 'DT_PARENT_CATEGORY' ); ?>:</td><td><?php echo $list['parent_id'] ?></td></tr>
<tr>
<td width="200"><?php echo JText::_( 'DT_CATEGORY_NAME' ); ?>:</td><td><input type="text" name="catname" size="80" /></td></tr>

</table>

<input type="hidden" name="task" value="savenewcategory">

<input type="hidden" name="option" value="<?php echo $option;?>">

<input type="hidden" name="hidemainmenu" value="0">

</form>

	<?php

 }

function deletingcategory($option, $value){

 $mosConfig_live_site = JURI::base( true );

 if($value == 0 )

    echo JText::_( 'DT_CATEGORY_DELETE_WARNING' );

 else

    echo JText::_( 'DT_CATEGORY_DELETED' );

 $link = "index2.php?option=com_dtregister&act=categories";

 echo "<br /><br /><br /><br /><a href='" .  $link .  "'><strong>".JText::_( 'DT_BACK' )."</strong></a>";

 }

  function exportEventSettings($option,$events){

	$columns = 5;

	$rows = array_chunk($events,$columns);

    require("../components/com_dtregister/config.dtregister.php");

	?>

    <script src="../components/com_dtregister/assets/js/jquery.js"></script>

    <script type="text/javascript" src="<?php echo JURI::root(true); ?>/media/system/js/mootools.js"></script>

	<form action="index2.php" method="post" name="adminForm">

		<table cellpadding="5" cellspacing="5" width="100%">

        <tr>

        	<td colspan="<?php echo $columns;?>">

            <?php echo JText::_('DT_EXPORT_INSTRUCTIONS_PT1'); ?>

        	</td>

        </tr>

 		   <tr>

        	<td colspan="<?php echo $columns;?>">

            	 <input type="checkbox" id="checkall" /> <?php echo JText::_('DT_CHECKALL'); ?> <br />

        	</td>

        </tr>

          <?php

          	foreach($rows as $col){

				     echo "<tr>";

				    foreach($col as $value){

				     echo "<td>";

					 ?>

                     <input name="export_events[]" type="checkbox" <?php echo $value->export?'checked':''; ?> value="<?php echo $value->eventId?>" />&nbsp; <?php echo tmpl_event_name($event_show_date,$value->summary,get_date($value->dtstart,$value->dtend)) ?>

                     <input name="events[]" type="hidden" value="<?php echo $value->eventId?>" />

                     <?php

					echo "</td>";

				}

				echo "</tr>";

			}

		  ?>

        <input name="option" type="hidden" value="com_dtregister" />

		<input name="task" type="hidden" value="" />

        </table>

    </form>

  <script src="../components/com_dtregister/assets/js/jquery.js"></script>

  <script src="../media/system/js/mootools.js"></script>

    <script>

	  DTjQuery(function(){

    	 DTjQuery("#checkall").click(function(){

		   if(this.checked){

		   		DTjQuery("form input[type=checkbox]").attr("checked", 'checked');

		   }else{

		   		DTjQuery("form input[type=checkbox]").attr("checked", false);

		   }

		 });

	  });

    </script>

	<?php

 }

  function exportFieldSettings($option,$fields){

	?>

  <script type="text/javascript" src="<?php echo JURI::root(true); ?>/media/system/js/mootools.js"></script>

	<form action="index2.php" method="post" name="adminForm">

	<table cellpadding="10" cellpadding="10" width="100%">

    <tr>

    <td colspan="3">

      <?php echo JText::_('DT_EXPORT_INSTRUCTIONS_PT2'); ?>

    </td>

    </tr>
   <tr>

    <td colspan="3">
      <table>
        <tr>
        <td>
        <?php echo JText::_('DT_START_DATE'); ?> : <?php 
          echo JHTML::_('calendar','', 'datefrom', 'datefrom',$format = '%Y-%m-%d',array('class'=>'inputbox datetype', 'size'=>'25',  'maxlength'=>'19')); ?>
          &nbsp;&nbsp;<?php echo JText::_('DT_END_DATE'); ?> : 
          <?php 
          echo JHTML::_('calendar','', 'dateto', 'dateto',$format = '%Y-%m-%d',array('class'=>'inputbox datetype', 'size'=>'25',  'maxlength'=>'19')); ?>
          <!--input type="text" name="datefrom" />&nbsp;&nbsp;<input type="text" name="dateto" /-->
          </td>
        </tr>
       </table>
    </td>

    </tr>
    <tr>

    <td colspan="3">

   		 <input type="checkbox" id="checkall" /> <?php echo JText::_('DT_CHECKALL'); ?>

    </td>

    </tr>

     <tr>

     	<td valign="top">

        <table>

        <tr><td colsapn="2" ><strong><?php echo JText::_('DT_GENERAL_INFO'); ?></strong></td></tr>

        <?php

			$fields['general_fields'][] = array('userType', JText::_('DT_USER_TYPE'));

			$fields['general_fields'][] = array('amount', JText::_('DT_AMOUNT'));

			$fields['general_fields'][] = array('payment_type', JText::_('DT_PAYMENT_TYPE'));

			$fields['general_fields'][] = array('paid', JText::_('DT_PAYMENT_STATUS'));

			$fields['general_fields'][] = array('groupId', 'GroupId');

			$fields['general_fields'][] = array('numberOfPerson', JText::_('DT_NUMBER_MEMBERS'));

			$fields['general_fields'][] = array('confirmNum', JText::_('DT_CONFIRMATION_NUMBER'));
            $fields['general_fields'][] = array('attend', JText::_('DT_ATTENDED'));
			$fields['general_fields'][] = array('cancel', JText::_('DT_STATUS'));
			$fields['general_fields'][] = array('code', JText::_('DT_DISCOUNT_CODE'));
            $fields['general_fields'][] = array('category', JText::_('DT_CATEGORY'));
			 $fields['general_fields'][] = array('location', JText::_('DT_LOCATION'));
			$fields['general_fields'][] = array('user_id', JText::_('DT_JOOMLA_USERID'));
			
			foreach($fields['general_fields'] as $value){

				echo "<tr>";

				   echo "<td>";

					 ?>

          <input name="general_export_fields[]" type="checkbox" <?php echo in_array($value[0],$fields['general_export_fields'])?'checked':'' ?> value="<?php echo $value[0]?>" />&nbsp;<?php echo $value[1]; ?>

          <input name="general_fields[]" type="hidden" value="<?php echo $value[0];?>" />

          <?php

					echo "</td>";

				  echo "</tr>";

			}

		?>

        <input name="option" type="hidden" value="com_dtregister" />

		    <input name="task" type="hidden" value="" />

        </table>

        </td>

        <td valign="top">

		<table>

 		  <tr><td colsapn="2" ><strong><?php echo JText::_('DT_INDIVIDUAL_GROUP_OPTIONS'); ?></strong></td></tr>

          <?php

          	foreach($fields['fields'] as $value){

				    echo "<tr>";

				    echo "<td>";

					 ?>

                     <input name="individual_export_fields[]" type="checkbox" <?php echo in_array($value[0],$fields['individual_fields'])?'checked':'' ?> value="<?php echo $value[0]?>" />&nbsp;<?php echo $value[1]; ?>

                     <input name="individual_fields[]" type="hidden" value="<?php echo $value[0];?>" />

                     <?php

					echo "</td>";

				  echo "</tr>";

			}
			
			   echo "<tr>";

				    echo "<td>";

					 ?>

                     <input name="individual_export_fields[]" type="checkbox" <?php echo in_array("paid_amount",$fields['individual_fields'])?'checked':'' ?> value="paid_amount" />&nbsp;<?php echo JText::_('DT_AMOUNT_PAID'); ?>

                     <input name="individual_fields[]" type="hidden" value="paid_amount" />

                     <?php

					echo "</td>";

				  echo "</tr>";
			 
		  ?>

          <?php

          	foreach($fields['custom_fields'] as $value){

				    echo "<tr>";

				    echo "<td>";

					 ?>

                     <input name="individual_custom_export_fields[]" type="checkbox" <?php echo $value->export_individual?'checked':'' ?> value="<?php echo $value->id?>" />&nbsp;<?php echo $value->label; ?>

                     <input name="individual_custom_fields[]" type="hidden" value="<?php echo $value->id?>" />

                     <?php

					echo "</td>";

				  echo "</tr>";

			}

		  ?>

         </table>

        </td>

        <td  valign="top">

         <table>

          <tr><td colsapn="2" ><strong><?php echo JText::_('DT_GROUP_MEMBER_DETAILS'); ?></strong></td></tr>

          <?php

          	foreach($fields['fields'] as $value){

				    echo "<tr>";

				    echo "<td>";

					 ?>

                     <input name="group_export_fields[]" type="checkbox" <?php echo in_array($value[0],$fields['group_fields'])?'checked':'' ?> value="<?php echo $value[0]?>" />&nbsp;<?php echo $value[1]; ?>

                     <input name="group_fields[]" type="hidden" value="<?php echo $value[0];?>" />

                     <?php

					echo "</td>";

				  echo "</tr>";

			}

		  ?>

          <?php

          	foreach($fields['custom_fields'] as $value){

				     echo "<tr>";

				     echo "<td>";

					 ?>

                     <input name="group_custom_export_fields[]" type="checkbox" <?php echo $value->export_group?'checked':'' ?> value="<?php echo $value->id?>" />&nbsp;<?php echo $value->label; ?>

                     <input name="group_custom_fields[]" type="hidden" value="<?php echo $value->id?>" />

                     <?php

					echo "</td>";

				  echo "</tr>";

			}

		  ?>

          </table>

        </td>

      </tr>

     </table>

    </form>

     <script src="../components/com_dtregister/assets/js/jquery.js"></script>

    <script>

	  DTjQuery(function(){

    	 DTjQuery("#checkall").click(function(){

		   if(this.checked){

		   		DTjQuery("form input[type=checkbox]").attr("checked", 'checked');

		   }else{

		   		 DTjQuery("form input[type=checkbox]").attr("checked", false);

		   }

		 });

	  });

    </script>

	<?php

 }

}

?>