<?php

/**
* @version 2.8.14
* @package Joomla 2.5
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

require_once( JPATH_SITE.'/components/com_dtregister/lib/class.payment.php');

class authorizenet_sim extends Payment {   

    public $x_address;
    public $x_amount;
    public $x_background_url;
    public $x_card_num;
    public $x_city;
    public $x_color_background;
    public $x_color_link;
    public $x_color_text;
    public $x_company;
    public $x_country;
    public $x_cust_id;
    public $x_customer_ip;
    public $x_description;
    public $x_delim_data;
    public $x_duplicate_window;
    public $x_duty;
    public $x_email;
    public $x_email_customer;
    public $x_fax;
    public $x_first_name;
    public $x_footer_email_receipt;
    public $x_footer_html_payment_form;
    public $x_footer_html_receipt;
    public $x_fp_hash;
    public $x_fp_sequence;
    public $x_fp_timestamp;
    public $x_freight;
    public $x_header_email_receipt;
    public $x_header_html_payment_form;
    public $x_header_html_receipt;
    public $x_invoice_num;
    public $x_last_name;
    public $x_line_item;
    public $x_login;
    public $x_logo_url;
    public $x_method;
    public $x_phone;
    public $x_po_num;
    public $x_receipt_link_method;
    public $x_receipt_link_text;
    public $x_receipt_link_url;
    public $x_recurring_billing;
    public $x_relay_response;
    public $x_relay_url;
    public $x_rename;
    public $x_ship_to_address;
    public $x_ship_to_company;
    public $x_ship_to_country;
    public $x_ship_to_city;
    public $x_ship_to_first_name;
    public $x_ship_to_last_name;
    public $x_ship_to_state;
    public $x_ship_to_zip;
    public $x_show_form;
    public $x_state;
    public $x_tax;
    public $x_tax_exempt;
    public $x_test_request;
    public $x_trans_id;
    public $x_type;
    public $x_version;
    public $x_zip;
	public $x_cancel_url;
	
	public $bywebservice = false;
	
	public $retry = false;
	
	function __construct() {

        global $merchid,$authnetmode,$transkey;

		parent::__construct();

		//$this->paymentmode = 'test';

		$this->url = ($this->paymentmode=='test')?"https://test.authorize.net/gateway/transact.dll":"https://secure2.authorize.net/gateway/transact.dll";
 $this->url = "https://secure2.authorize.net/gateway/transact.dll";
        if($this->paymentmode=='test'){
		$this->add_field('x_test_request',($this->paymentmode=='test')?'TRUE':'FALSE'); 
		}
		
        $this->add_field('x_login', $merchid);
		$this->add_field('x_version', "3.1");
		//$this->add_field('x_tran_key', $transkey);
		//txnkey
		$this->add_field('x_type', "AUTH_CAPTURE");
		$this->add_field('x_method', "CC");
		//$this->add_field('x_relay_response', "FALSE");
		//$this->add_field('x_delim_data', "FALSE");
		$this->add_field('x_show_form', "PAYMENT_FORM");
		 
		//$this->x_version  = "3.1";
		
   }
	
    function add_field($field, $value) {

      $this->fields["$field"] = $value;

   }
   
      function process(){

	   global $currency_code,$Itemid;
       global $merchid,$authnetmode,$transkey;
	   $mosConfig_live_site = JURI::root( false );

	   if($currency_code==""){$currency_code='USD';}

	  $session_id = $this->saveSession();

	  $amount = $this->cart->getAmount();

	   $this->add_field('x_cancel_url', "{$mosConfig_live_site}components/com_dtregister/success.php?return=$session_id&Itemid=$Itemid&task=cancel");

	  $this->add_field('x_amount', $amount);
	  $this->add_field('x_description',$this->description);
	  $this->add_field('x_cust_id',$session_id);
	 
		$fp_timestamp = time();
		$fp_sequence = $session_id;
		$fp_hash = $this->getFingerprint($merchid,$transkey,$amount,$fp_sequence,$fp_timestamp);
		$this->add_field('x_fp_sequence',$fp_sequence);
		$this->add_field('x_fp_hash',$fp_hash);
		$this->add_field('x_fp_timestamp',$fp_timestamp);
		$x_invoice_num = 	 (!isset($this->confirmNum)|| $this->confirmNum=="")?'':$this->confirmNum;
		$this->add_field('x_invoice_num', $x_invoice_num);
		
	  if(isset($this->firstname) && $this->firstname !="" ){
	  	 $this->add_field('x_first_name', $this->firstname);
	  }
	  
	   if(isset($this->lastname) && $this->lastname !="" ){
	  	  $this->add_field('x_last_name', $this->lastname);
	  }
	  
	   if(isset($this->address) && $this->address !="" ){
	  	  $this->add_field('x_address', $this->address);
	  }
	  
	   if(isset($this->city) && $this->city !="" ){
	  	  $this->add_field('x_city', $this->city);
	  }
	  if(isset($this->state) && $this->state !="" ){
	  	 $this->add_field('x_state', $this->state);
	  }
	  
	   if(isset($this->zip) && $this->zip !="" ){
	  	 $this->add_field('x_zip', $this->zip);
	  }
	  if(isset($this->phone) && $this->phone !="" ){
	  	 $this->add_field('x_phone', $this->phone);
	  }
	  
	   if(isset($this->email) && $this->email !="" ){
	  	  $this->add_field('x_email', $this->email);
	  }

	   //$this->add_field('x_currency_code', "$currency_code");

	   $this->submit_post();

   }

   function submit_post() {
ob_start();
      echo "<center><h3>".JText::_( 'DT_AUTHORIZENET_REDIRECT_MSG')."</h3></center>\n";

      echo "<form method=\"post\" name=\"formRegister\" action=\"".$this->url."\">\n";

      foreach ($this->fields as $name => $value) {
         if($name=="x_cust_id") {
			// $value = "99999999-9999";
			//echo "<br /> CUSTOMER ID sent is".$value."<br />";
	     }
         echo "<input type=\"hidden\" name=\"$name\" value=\"$value\"> <br />";

      }

?>

		<script language="javascript">

			function rg_direc(){

				document.formRegister.submit();

			}

			setTimeout("rg_direc()",5000);

		</script>

<?php

      echo "</form>\n";
	  
	  $html = ob_get_clean();
	  
	  echo $html;

   }
   
   /**
     * Verify the request is AuthorizeNet.
     *
     * @return bool
     */
    public function isAuthorizeNet()
    {
        return count($_POST) && $this->md5_hash && ($this->generateHash() == $this->md5_hash);
    }
	
	/**
     * Generates an Md5 hash to compare against Authorize.Net's.
     *
     * @return string Hash
     */
    public function generateHash()
    {
        $amount = ($this->amount ? $this->amount : "0.00");
        return strtoupper(md5($this->md5_setting . $this->api_login_id . $this->transaction_id . $amount));
    }
   
   /**
     * Generates a fingerprint needed for a hosted order form or DPM.
     *
     * @param string $api_login_id    Login ID.
     * @param string $transaction_key API key.
     * @param string $amount          Amount of transaction.
     * @param string $fp_sequence     An invoice number or random number.
     * @param string $fp_timestamp    Timestamp.
     *
     * @return string The fingerprint.
     */
    public function getFingerprint($api_login_id, $transaction_key, $amount, $fp_sequence, $fp_timestamp)
    {
        $api_login_id = ($api_login_id ? $api_login_id : (defined('AUTHORIZENET_API_LOGIN_ID') ? AUTHORIZENET_API_LOGIN_ID : ""));
        $transaction_key = ($transaction_key ? $transaction_key : (defined('AUTHORIZENET_TRANSACTION_KEY') ? AUTHORIZENET_TRANSACTION_KEY : ""));
        if (function_exists('hash_hmac')) {
            return hash_hmac("md5", $api_login_id . "^" . $fp_sequence . "^" . $fp_timestamp . "^" . $amount . "^", $transaction_key); 
        }
        return bin2hex(mhash(MHASH_MD5, $api_login_id . "^" . $fp_sequence . "^" . $fp_timestamp . "^" . $amount . "^", $transaction_key));
    }
   
    function notify(){
	   
	   if($_REQUEST['x_response_code']=='1'){
		   $this->transactionId = $_REQUEST['x_trans_id'];
		   $process = DT_Session::get('Setting.process');
		   DT_Session::set($process.'.payment.transactionId', $this->transactionId);
				   return true;
			   }else{
				   
				   return false;
	   }
	      
   }
   
   function success(){
	  
	    if($_REQUEST['x_response_code']=='1'){
		   $this->transactionId = $_REQUEST['x_trans_id'];
		   $process = DT_Session::get('Setting.process');
		   DT_Session::set($process.'.payment.transactionId', $this->transactionId);
				   return true;
	    }elseif($_REQUEST['x_response_code']=='2'){
		   $this->retry  =  true;
		   $this->errorMsg = $_REQUEST['x_response_reason_text'];
		   return false;
	    } else {
			//$this->retry = true;
			//$this->errorMsg = $_REQUEST['x_response_reason_text'];
		   return false;
		}
  }
  
 function afterFailed(){

	   $this->tryagaintask = "form";	

    }
   
}

?>