<?php

/**
* @version 2.8.9
* @package Joomla 2.5
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

require_once( JPATH_SITE.'/components/com_dtregister/lib/class.payment.php');

class epdq extends Payment{

   var $last_error;                 // holds the last error encountered
   
   var $fields = array();           // array holds the fields to submit to paypal

   var $bywebservice = false;

   function __construct() {

      // initialization constructor.  Called when class is created.
     global $epdq_id ,$epdq_pass;
      parent::__construct();
      
      $this->url = ($this->paymentmode=='test')?'https://mdepayments.epdq.co.uk/ncol/test/orderstandard.asp':'https://payments.epdq.co.uk/ncol/prod/orderstandard.asp';

      $this->add_field('PSPID',$epdq_id);  
	  
	  $this->add_field('LANGUAGE','en_US');
	  
	 // $this->add_field('PM','Credit Card');
	  
	  $this->sha_pass = $epdq_pass;       

   }

   function add_field($field, $value) {

      $this->fields["$field"] = $value;

   }

   function process(){

	   global $currency_code,$Itemid;

	   $mosConfig_live_site = JURI::root( false );

	   if($currency_code==""){$currency_code='USD';}

	   $this->add_field('CURRENCY', "$currency_code");
	   $session_id = $this->saveSession();

	   $this->add_field('ACCEPTURL', "{$mosConfig_live_site}components/com_dtregister/success.php?return=$session_id&Itemid=$Itemid&task=restore");

	   $this->add_field('DECLINEURL', "{$mosConfig_live_site}components/com_dtregister/success.php?return=$session_id&Itemid=$Itemid&task=cancel");

       $this->add_field('CANCELURL', "{$mosConfig_live_site}components/com_dtregister/success.php?return=$session_id&Itemid=$Itemid&task=cancel");

	   //$this->add_field('notify_url', "{$mosConfig_live_site}components/com_dtregister/success.php?return=$session_id&Itemid=$Itemid&task=notification");
	   
       $lastname = "";
	    if(isset($this->lastname) && $this->lastname !="" ){
	  	 $lastname = $this->lastname;
	  }
		
	   if(isset($this->firstname) && $this->firstname !="" ){
	  	 $this->add_field('CN', trim($this->firstname." ".$lastname));
	  }
	  
	   if(isset($this->address) && $this->address !="" ){
	  	 $this->add_field('OWNERADDRESS', $this->address);
	  }
	  
	   if(isset($this->city) && $this->city !="" ){
	  	 $this->add_field('OWNERTOWN', $this->city);
	  }
	  
	   if(isset($this->zip) && $this->zip !="" ){
	  	 $this->add_field('OWNERZIP', $this->zip);
	  }
	   if(isset($this->country) && $this->country !="" ){
	  	 $this->add_field('OWNERCTY', $this->country);
	  }
	   if(isset($this->phone) && $this->phone !="" ){
	  	 $this->add_field('OWNERTELNO', $this->phone);
	  }
	   if(isset($this->email) && $this->email !="" ){
	  	 $this->add_field('EMAIL', $this->email);
	  }
	  $x_invoice_num = 	 (!isset($this->confirmNum)|| $this->confirmNum=="")?'':$this->confirmNum;
	  $this->add_field('ORDERID', rand());
	  $this->add_field('AMOUNT', $this->cart->getAmount()*100);
	   
	  $this->add_field('SHASIGN', $this->sha1key());

	  $this->submit_post();

   }
   
   function sha1key(){
      $sha_parts = array($this->fields['AMOUNT'],
	                     $this->fields['CURRENCY'],
						 $this->fields['LANGUAGE'],
						 $this->fields['ORDERID'],
						 $this->fields['PSPID']);
	  
	 $sha_str = "AMOUNT=".$this->fields['AMOUNT'].$this->sha_pass."CURRENCY=".$this->fields['CURRENCY'].$this->sha_pass."
LANGUAGE=".$this->fields['LANGUAGE'].$this->sha_pass."ORDERID=".$this->fields['ORDERID'].$this->sha_pass."
PSPID=".$this->fields['PSPID'].$this->sha_pass."";

// echo "<pre>";
// print_r($this->fields);
ksort ($this->fields);
// print_r($this->fields);
// echo "</pre>";

$sha_str = "";
foreach($this->fields as $key => $value) {
   if($value!=''){
		$value = trim($value);
		
		$sha_str.=strtoupper($key).'='.$value.trim($this->sha_pass);
	}
}
// echo $sha_str;
	  return strtoupper(hash("sha1", $sha_str));
	  //$str = implode($this->sha_pass,$sha_parts);
	  return sha1($str);
   }

   function submit_post() {

      echo "<center><h3>".JText::_( 'DT_EPDQ_REDIRECT_MSG')."</h3></center>\n";

      echo "<form method=\"post\" name=\"formRegister\" action=\"".$this->url."\">\n";

      foreach ($this->fields as $name => $value) {

         echo "<input type=\"hidden\" name=\"$name\" value=\"$value\">";

      }
	  
	  // echo '<input name="submit" type="submit" value="submit" />';

?>

		<script language="javascript">

			function rg_direc(){

				document.formRegister.submit();

			}

			setTimeout("rg_direc()",5000);

		</script>

<?php

      echo "</form>\n";

   }

   function success(){
	  
	    if($_REQUEST['STATUS']=='5' || $_REQUEST['STATUS']=='9'){
		   $this->transactionId = $_REQUEST['PAYID'];
		   $process = DT_Session::get('Setting.process');
		   DT_Session::set($process.'.payment.transactionId', $this->transactionId);
				   return true;
			   }else{
				   
				   return false;
	   }	
  }
   
   function dump_fields() {

      echo "<h3>paypal_class->dump_fields() Output:</h3>";

      echo "<table width=\"95%\" border=\"1\" cellpadding=\"2\" cellspacing=\"0\">

            <tr>

               <td bgcolor=\"black\"><b><font color=\"white\">Field Name</font></b></td>

               <td bgcolor=\"black\"><b><font color=\"white\">Value</font></b></td>

            </tr>";

      ksort($this->fields);

      foreach ($this->fields as $key => $value) {

         echo "<tr><td>$key</td><td>".urldecode($value)."&nbsp;</td></tr>";

      }

      echo "</table><br>";

   }

}

?>