
CREATE TABLE IF NOT EXISTS `#__dtregister_captcha` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `user_ip` VARCHAR(50) NULL,
  `code` VARCHAR(50) NULL,
  PRIMARY KEY(id)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_categories` (
  `categoryId` int(11) NOT NULL auto_increment,
  `categoryName` varchar(100) NOT NULL default '',
  `ordering` tinyint(3) UNSIGNED NULL,
  `parent_id` int(11) default '0',
  PRIMARY KEY  (`categoryId`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_codes` (
  `id` bigint(11) NOT NULL auto_increment,
  `name` varchar(100) default NULL,
  `start` datetime default NULL,
  `end` datetime default NULL,
  `publish` int(11) default '0',
  `discount_type` int(3) default '1',
  `amount` float default '0',
  `code` varchar(20) default NULL,
  `limit` int(4) default '0',
  `events_enable` int(2) default '0',
  PRIMARY KEY  (`id`)
)ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_config` (
  `id` int(11) NOT NULL auto_increment,
  `config_key` varchar(50) default NULL,
  `config_value` text,
  `title` varchar(50) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_events_codes` (
  `id` bigint(11) NOT NULL auto_increment,
  `event_id` bigint(11) default NULL,
  `discount_code_id` bigint(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_event_config` (
  `eventId` bigint(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_export_fields` (
  `group_export_fields` text NOT NULL,
  `individual_export_fields` text NOT NULL,
  `general_export_fields` text NOT NULL
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_fields` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `label` varchar(255) default NULL,
  `field_size` tinyint(3) unsigned default NULL,
  `description` varchar(255) default NULL,
  `ordering` tinyint(3) unsigned default NULL,
  `published` tinyint(3) unsigned default NULL,
  `required` tinyint(4) default '0',
  `values` text default NULL,
  `type` int(4) NOT NULL default '0',
  `selected` varchar(255) default NULL,
  `rows` tinyint(4) NOT NULL default '0',
  `cols` tinyint(4) NOT NULL default '0',
  `fee_field` tinyint(4) NOT NULL default '0',
  `fees` text default NULL,
  `new_line` tinyint(4) NOT NULL default '0',
  `textual` text NOT NULL,
  `export_individual` int(2) NULL default '1',
  `export_group` int(2) NULL default '1',
  `attendee_list` tinyint(2) NOT NULL default '0',
  `usagelimit` text default NULL,
  `fee_type` tinyint(2) NOT NULL default '1',
  `filetypes` text default NULL,
  `upload` tinyint(2) default NULL,
  `filesize` int(4) default NULL,
  `hidden` tinyint(2) default NULL,
  `group_behave` tinyint(2) NOT NULL default '1',
  `allevent` tinyint(2) NOT NULL default '0',
  `showed` tinyint(3) default NULL,
  `maxlength` int(4) default NULL,
  `date_format` varchar(25) default NULL,
  `parent_id` int(7) default '0',
  `selection_values` text default NULL,
  `textareafee` text default NULL,
  `showcharcnt` int(2) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_field_event` (
  `id` int(11) NOT NULL auto_increment,
  `field_id` int(11) default NULL,
  `event_id` int(11) default NULL,
  `showed` tinyint(3) default NULL,
  `group_behave` mediumint(11) NOT NULL default '1',
  `required` tinyint(1) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_files` (
  `id` bigint(11) NOT NULL auto_increment,
  `path` varchar(255) default NULL,
  `event_id` bigint(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_group` (
  `groupId` int(11) NOT NULL auto_increment,
  `useid` int(11) default NULL,
  PRIMARY KEY  (`groupId`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_group_amount` (
  `groupId` int(11) NOT NULL default '0',
  `numberOfPerson` int(11) NOT NULL default '0',
  `amount` decimal(8,2) NOT NULL default '0',
  PRIMARY KEY  (`groupId`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_group_event` (
  `slabId` int(11) NOT NULL auto_increment,
  `eventId` int(11) NOT NULL default '0',
  `memberTotal` int(3) NOT NULL default '0',
  `regGroupRate` decimal(10,2) NOT NULL default '0.00',
  `regGroupPerRate` decimal(10,2) NOT NULL default '0.00',
  `registerAmountIndividual` decimal(10,2) NOT NULL default '0.00',
  `latefee` decimal(10,2) NOT NULL default '0.00',
  `latefeedate` date NOT NULL default '0000-00-00',
  `email` text default NULL,
  `max_registrations` int(11) NOT NULL default '0',
  `registration_type` varchar(50) default 'individual',
  `topmsg` text default NULL,
  `cut_off_date` date default NULL,
  `discount_type` tinyint(4) NOT NULL default '0',
  `discount_amount` decimal(10,2) NOT NULL default '0.00',
  `thksmsg` text default NULL,
  `thksmsg_set` tinyint(4) NOT NULL default '0',
  `event_describe` text default NULL,
  `event_describe_set` tinyint(4) default NULL,
  `terms_conditions_set` tinyint(4) NOT NULL default '0',
  `terms_conditions_msg` text default NULL,
  `category` int(11) default NULL,
  `max_group_size` smallint(5) UNSIGNED NULL,
  `ordering` tinyint(3) unsigned default '1',
  `waiting_list` tinyint(1) NULL,
  `public` tinyint(1) NOT NULL default '1',
  `export` int(2) NOT NULL default '1',
  `use_discountcode` int(3) default '0',
  `article_id` bigint(11) default '0',
  `detail_link_show` int(2) NOT NULL default '0',
  `show_registrant` int(4) default '0',
  `publish` int(4) NOT NULL default '0',
  `startdate` date default '0000-00-00',
  `bird_discount_type` tinyint(2) default '0',
  `bird_discount_amount` varchar(12) default NULL,
  `bird_discount_date` date default '0000-00-00',
  `payment_option` tinyint(2) NOT NULL default '1',
  `location_id` int(11) default NULL,
  `archive` int(2) default '0',
  `partial_payment` int(2) default '0',
  `partial_amount` varchar(20) default NULL,
  `partial_minimum_amount` varchar(20) default NULL,
  `edit_fee` int(2) default '0',
  `cancelfee_enable` int(2) default NULL,
  `cancel_date` varchar(30) default NULL,
  `cancel_refund_status` int(1) default '0',
  `excludeoverlap` int(2) default '0',
  `pay_later_thk_msg_set` tinyint(2) NOT NULL default '0',
  `pay_later_thk_msg` text default NULL,
  `thanksmsg_set` tinyint(2) NOT NULL default '0',
  `thanksmsg` text default NULL,
  `change_date` varchar(20) default NULL,
  `detail_itemid` int(4) default NULL,
  `tax_enable` int(2) default '0',
  `tax_amount` float default '0',
  PRIMARY KEY  (`slabId`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_group_member` (
  `groupMemberId` int(11) NOT NULL auto_increment,
  `groupUserId` int(11) NOT NULL default '0',
  `title` varchar(10) default NULL,
  `firstname` varchar(100) NOT NULL default '',
  `lastname` varchar(100) default NULL,
  `organization` varchar(255) default NULL,
  `address` varchar(255) default NULL,
  `address2` varchar(255) default NULL,
  `city` varchar(100) default NULL,
  `state` varchar(50) default NULL,
  `country` varchar(100) default NULL,
  `zip` varchar(50) default NULL,
  `phone` varchar(50) default NULL,
  `email` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`groupMemberId`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_history` (
  `id` int(7) NOT NULL auto_increment,
  `type` varchar(255) default NULL,
  `amount` float default '0',
  `payment_date` date default NULL,
  `user_id` int(7) default '0',
  `reason` varchar(100) default NULL,
  `transaction_id` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_locations` (
  `id` bigint(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `address` varchar(255) default NULL,
  `address2` varchar(255) default NULL,
  `city` varchar(100) default NULL,
  `state` varchar(100) default NULL,
  `zip` varchar(20) default NULL,
  `country` varchar(100) default NULL,
  `phone` varchar(50) default NULL,
  `email` varchar(100) default NULL,
  `website` varchar(255) default NULL,
  `image` varchar(255) NOT NULL,
  `showimage` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_prerequisite` (
  `id` int(7) NOT NULL auto_increment,
  `event_id` int(7) default '0',
  `prerequisite_id` int(7) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_prerequisite_category` (
  `id` int(7) NOT NULL auto_increment,
  `event_id` int(7) default '0',
  `prerequisite_id` int(7) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_session` (
  `id` bigint(11) NOT NULL auto_increment,
  `session_id` varchar(255) default NULL,
  `data` longtext default NULL,
  `user_id` bigint(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_sync` (
  `id` bigint(11) NOT NULL auto_increment,
  `old_event_id` bigint(12) default NULL,
  `new_event_id` bigint(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__dtregister_user` (
  `userId` int(11) NOT NULL auto_increment,
  `eventId` int(11) NOT NULL default '0',
  `userType` enum('I','G') default 'I',
  `userTitle` varchar(10) NOT NULL default '',
  `userFirstName` varchar(50) NOT NULL default '',
  `userLastName` varchar(50) NOT NULL default '',
  `userOrganization` varchar(250) NOT NULL default '',
  `userAddress` varchar(250) NOT NULL default '',
  `userAddress2` varchar(250) NOT NULL default '',
  `userCity` varchar(50) NOT NULL default '',
  `userState` varchar(50) NOT NULL default '',
  `userCountry` varchar(100) NOT NULL default '0',
  `userZip` varchar(50) default NULL,
  `userPhone` varchar(50) NOT NULL default '',
  `userEmail` varchar(100) NOT NULL default '',
  `register_date` DATETIME NULL,
  `payment_type` varchar(100) default NULL,
  `due_amount` decimal(10,2) NOT NULL default '0.00',
  `pay_later_option` tinyint(4) NOT NULL default '0',
  `confirmNum` varchar(50) default NULL,
  `user_id` int(11) NOT NULL default '0',
  `payment_verified` tinyint(4) NOT NULL default '1',
  `pay_later_paid` tinyint(4) NOT NULL default '0',
  `discount_code_id` bigint(11) default '0',
  `billing_firstname` varchar(150) default NULL,
  `billing_lastname` varchar(150) default NULL,
  `billing_address` varchar(255) default NULL,
  `billing_city` varchar(150) default NULL,
  `billing_state` varchar(150) default NULL,
  `billing_zipcode` varchar(10) default NULL,
  `billing_email` varchar(150) default NULL,
  `due_payment` decimal(10,2) default '0.00',
  `cancel` int(11) default '0',
  `attend` int(2) default '0',
  `paid_amount` varchar(30) default NULL,
  `transaction_id` varchar(255) default NULL,
  PRIMARY KEY  (`userId`)
) ENGINE=MyISAM;
