<?php

/**
* @version 2.6.8
* @package Joomla 1.5
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

global $jeventDateOffset , $barCodeTypes , $barCodeImagetype , $barCodeResolutions , $barcodeRotation,$barCodeImagetypeToExt;

$config =& JFactory::getConfig();
$config->getValue('config.offset');
$totalOffest =   $config->getValue('config.offset')*3600 ;
$table =& JTable::getInstance('component');
$table->loadByOption("com_jevents" );

$path	= JPATH_ADMINISTRATOR.DS.'components'.DS.'com_jevents'.DS.'config.xml';

if (file_exists( $path )) {
	$instance = new JParameter( $table->params, $path );
} else {
	$instance = new JParameter( $table->params );
}

$jeventTimeZone = $instance->get("icaltimezonelive","");
if($jeventTimeZone != ""){
   $winter = new DateTime('2010-12-21', new DateTimeZone(date('e')));
  $jeventDateOffset = ($totalOffest - $winter->getOffset());
   $jeventDateOffset = 0 ;
  if (is_callable("date_default_timezone_set")){
	$timezone= date_default_timezone_get();
	date_default_timezone_set($jeventTimeZone);
  
  }
}else{
	$jeventDateOffset  = 0 ;
}

$barCodeTypes =  array(
                    'code39'=>JText::_('DT_CODE39'),
					'code39extended'=>JText::_('DT_CODE39_EXTENDED'),
					'code93'=>JText::_('DT_CODE93'),
					'code128'=>JText::_('DT_CODE128')
				);
$barCodeImagetype =  array('png'=>JText::_('DT_BARCODE_PNG'),'jpg'=>JText::_('DT_BARCODE_JPEG'));
$barCodeImagetypeToExt =  array('png'=>'png','jpg'=>'jpeg');
$barCodeResolutions =  array('1'=>1,'2'=>'2','3'=>'3' );
$barcodeRotation =  array(0=>JText::_('DT_DEGREE_ZERO'),90=>JText::_('DT_DEGREE_90'),180=>JText::_('DT_DEGREE_180'),270=>JText::_('DT_DEGREE_270')) ;
function pr($data=array()){ 
    //return ;
  	echo "<pre>";
	
	 $backtrace =  debug_backtrace() ;
	 $index = 0 ;
	
	if(basename($backtrace[0]['file'])=="common.php"){
	   $index = 1;	
	}
	
	echo "<br /><b>called in file ".$backtrace[$index]['file']." at line number ".$backtrace[$index]['line']."</b><br />";
	if(empty($data)){
	    var_dump($data);
		
	}else{
	
	  print_r($data);
	}
	echo "</pre>";
	
}

function prd($data=null){
 // return ;
  pr($data);
  die ;	
}
function amount_filter($amount){
   
   $return = "";
   for($i = 0;$i<strlen($amount);$i++){
      
	  if(is_numeric($amount[$i]) || $amount[$i]=="," || $amount[$i] == "." ){
	     $return .= $amount[$i];
	  }
	  
   }
   
   return $return ;
   
}

function getTextareaFee($count=0,$textareafee=""){
   	
	$arrfee = explode('|',$textareafee) ;
	$retrunfee = 0 ;
	foreach($arrfee as $feestr){
	   	$fee = explode("=",$feestr);
		$chrlimit = $fee[0];
		
		$retrunfee = $fee[1];
		if($chrlimit >= $count){
		    
			break ;
		}
		
	}
	return $retrunfee ;
	
}

function currency_symbol($currency_code){
   
    $arrCode=array(

     		'USD'=>'$',

     		'BRL'=>'R$',

     		'ZAR'=>'R',

     		'GBP'=>'&#163;',

     		'EUR'=>'&#128;',

     		'JPY'=>'&#165;'

     	);

		foreach($arrCode as $arKey=>$arValue){

			if ($arKey === $currency_code){

				$currency_symbol = $arValue;

				break;

			} else {
	
				$currency_symbol = "";
	
			}

		}
		
		return $currency_symbol;

}

function get_date( $date = 'now', $end=null,$format = null, $offset = true )  {
    $offset =  false ;
	global $database,$mosConfig_live_site,$mosConfig_absolute_path,$DT_mailfrom,$DT_fromname,$Itemid,$my,$jeventDateOffset;

	

	$mosConfig_absolute_path = JPATH_SITE;

	include (JPATH_SITE.'/components/com_dtregister/config.dtregister.php');
	if(is_numeric($date )){
	   
	   $date += $jeventDateOffset ;
	if($end != ""){
	  $end += $jeventDateOffset ;
	}
	   
	}
     
   $format  = "";

   $end_time = "";
   if($date==""){
     return "";
   }
  
   if($displaytime > 0){

	 if($timeformat==1){

		$format = "%I:%M %p";

	 }else{

		$format = "%H:%M";

	 }

	 $end_time = "";

	 $offset = false ;
     if($displaytime==1){

	   $end_time = "";

	 }elseif($end!="" && $date !="" ){ //

	   	$start_date =JFactory::getDate($date)->toFormat('%b %d, %Y');

		$end_date  = JFactory::getDate($end)->toFormat('%b %d, %Y');

	   if($start_date == $end_date){

	     $end_time = " - ".JHTML::_('date',$end,$format ,$offset);

	   }

	 }
	 
   }

	return trim(JHTML::_('date',$date,$date_format." ".$format ,$offset)." ".$end_time);

}

function get_time( $date = 'now', $end=null,$format = null, $offset = true )  {
     $offset =  false ;
	global $database,$mosConfig_live_site,$mosConfig_absolute_path,$DT_mailfrom,$DT_fromname,$Itemid,$my,$jeventDateOffset;

	

	$mosConfig_absolute_path = JPATH_SITE;
     $date += $jeventDateOffset ;
	if($end != ""){
	  $end += $jeventDateOffset ;
	}
	include (JPATH_SITE.'/components/com_dtregister/config.dtregister.php');

   $format  = "";

   $end_time = "";

   if($displaytime > 0){

	 if($timeformat==1){

		$format = "%I:%M %p";

	 }else{

		$format = "%H:%M";

	 }

	 $end_time = "";

	 $offset = false ;

	 if($displaytime==1){

	   $end_time = "";

	 }elseif($end!=""){

	   	$start_date =JFactory::getDate($date)->toFormat('%b %d, %Y');

		$end_date  = JFactory::getDate($end)->toFormat('%b %d, %Y');

	   if($start_date == $end_date){

	     $end_time = " - ".JHTML::_('date',$end,$format ,$offset);

	   }

	 }

   }else{
      
	   if($timeformat==1){

		$format = "%I:%M %p";

	 }else{

		$format = "%H:%M";

	 }
	   
   }

	return trim(JHTML::_('date',$date,$format ,$offset)."".$end_time);

}

function get_date_only( $date = 'now', $end=null,$format = null, $offset = true )  {

	global $database,$mosConfig_live_site,$mosConfig_absolute_path,$DT_mailfrom,$DT_fromname,$Itemid,$my;

	

	$mosConfig_absolute_path = JPATH_SITE;

	include (JPATH_SITE.'/components/com_dtregister/config.dtregister.php');

   $format  = "";

   $end_time = "";

   if($displaytime > 0){

	 if($timeformat==1){

		$format = "%I:%M %p";

	 }else{

		$format = "%H:%M";

	 }

	 $end_time = "";

	 $offset = false ;

	 if($displaytime==1){

	   $end_time = "";

	 }elseif($end!=""){

	   	$start_date =JFactory::getDate($date)->toFormat('%b %d, %Y');

		$end_date  = JFactory::getDate($end)->toFormat('%b %d, %Y');

	   if($start_date == $end_date){

	     $end_time = " - ".JHTML::_('date',$end,$format ,$offset);

	   }

	 }

   }

	return trim(JHTML::_('date',$date,$date_format ,$offset));

}

function register_link($eventId ) {

	global $database,$mosConfig_live_site,$Itemid , $now;

	$database= & Jfactory::getDBO();

    include(JPATH_SITE."/components/com_dtregister/config.dtregister.php");

	$color = $button_color ;

//	$sql="Select distinct(a.id),if(CURDATE()>b.cut_off_date,'y','n') as cut_off,a.*,b.cut_off_date from #__events a ,#__dtregister_group_event b where a.id=$eventId And a.id = b.eventId AND a.publish_up >= NOW()  ORDER by a.publish_up";

	$sql="select distinct(a.evdet_id) , if(b.startdate > '".$now->toFormat('%Y-%m-%d')."' and b.startdate is not null,'y','n') as future_event,a.dtstart,if('".$now->toFormat('%Y-%m-%d')."'>b.cut_off_date,'y','n') as cut_off,a.*,b.cut_off_date, b.waiting_list from #__jevents_vevdetail a ,#__dtregister_group_event b where a.evdet_id=$eventId And a.evdet_id = b.eventId  AND a.state=1 ORDER by a.dtstart";

	$database->setQuery($sql);

	$database->getErrorMsg();

	$row = $database->loadObject();

	if($row==null)

		return "";

   if($row->future_event=='y'){

     return "";

   }

	$sql="Select max_registrations From #__dtregister_group_event Where eventId=$eventId limit 0,1";

	$database->setQuery($sql);

	$row->max_registrations=$database->loadResult();

	$sql="Select sum(c.numberOfPerson)

		  From #__dtregister_user As a

		  Inner Join #__dtregister_group As b

		  on a.userId=b.useid

		  Inner join #__dtregister_group_amount As c

		  On b.groupId=c.groupId

		  Where a.eventId=$eventId

		  Group by a.eventId

		";

	$database->setQuery($sql);

	$row->registered=$database->loadResult();

	//Create the task

	if(($row->cut_off=='y') && ($row->cut_off_date!='0000-00-00'))

		$task="cut_off_date";

	elseif(($row->registered>=$row->max_registrations)&&($row->max_registrations)&&($row->waiting_list=='0'))

		$task="full_event_page";

	elseif(($row->registered>=$row->max_registrations)&&($row->max_registrations)&&($row->waiting_list=='1'))

		$task="full_event_page_msg";

	else

		$task="event_register";

	  $queryReg = "SELECT eventID,registration_type FROM #__dtregister_group_event WHERE eventID = " . $row->evdet_id;

	  $database->setQuery( $queryReg );

    $eventReg = $database->loadResult();

    $event = $database->loadObject();

    $eventId = $row->evdet_id;

    $eventReg ;

  if ($eventReg != 0)

	{

      switch ($event->registration_type) {

         case "individual" :

  		      $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_individual",$xhtml_url);

          	  break;

        case "group" :

              $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_group_num",$xhtml_url);

      		  break;

        case "both" :

            $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_options",$xhtml_url);

    	    break;

      }

      }

		 $reglink=JRoute::_($reglink);

		  if($front_link_type){

		   	 $register = '<img src="components/com_dtregister/assets/images/'.$color.'/register_now_195.png" border="0" alt= " " />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

			  $all_link=JRoute::_("index.php?option=com_dtregister&Itemid=".$Itemid);

			$text = "";

				 if($front_link_type){

				 	$separater = "";

					$back  = '<img src="components/com_dtregister/assets/images/'.$color.'/view_events_195.png" border="0" alt= " " />'; 

				 }else{

					$back  = JText::_( 'DT_VIEW_ALL_EVENTS');

				 	$separater = " | ";

				 }

				  $text .= " <a href=\"".$all_link."\">".$back." </a> ".$separater;

				//$text = "yes";

	$text ="<a href='$reglink'>".$register."</a>";

	return $text;

}

function change_fee($amount=0){
   
   include (JPATH_SITE.'/components/com_dtregister/config.dtregister.php');
   if($amount == 0){
     //return 0;
   }
   
   if($changefee_enable){
     
	 if($changefee_type==1){
	   return $changefee ;
	 }else if($changefee_type==2){
	   return ($amount*$changefee)/100 ;
	 }else{
	   return 0;
	 }
	 
   }
   
}

function register_href($eventId){

	global $database,$mosConfig_live_site,$Itemid , $now;

	$database= & Jfactory::getDBO();

    include(JPATH_SITE."/components/com_dtregister/config.dtregister.php");

	$color = $button_color ;

//	$sql="Select distinct(a.id),if(CURDATE()>b.cut_off_date,'y','n') as cut_off,a.*,b.cut_off_date from #__events a ,#__dtregister_group_event b where a.id=$eventId And a.id = b.eventId AND a.publish_up >= NOW()  ORDER by a.publish_up";

	$sql="select distinct(a.evdet_id), if(b.startdate > '".$now->toFormat('%Y-%m-%d')."' and b.startdate is not null,'y','n') as future_event , a.dtstart,if('".$now->toFormat('%Y-%m-%d')."'>b.cut_off_date,'y','n') as cut_off,a.*,b.cut_off_date, b.waiting_list from #__jevents_vevdetail a ,#__dtregister_group_event b where a.evdet_id=$eventId And a.evdet_id = b.eventId  AND a.state=1 ORDER by a.dtstart";

	$database->setQuery($sql);

	$database->getErrorMsg();

	$row = $database->loadObject();

	if($row==null)

		return "";

	$sql="Select max_registrations From #__dtregister_group_event Where eventId=$eventId limit 0,1";

	$database->setQuery($sql);

	$row->max_registrations=$database->loadResult();

	$sql="Select sum(c.numberOfPerson)

		  From #__dtregister_user As a

		  Inner Join #__dtregister_group As b

		  on a.userId=b.useid

		  Inner join #__dtregister_group_amount As c

		  On b.groupId=c.groupId

		  Where a.eventId=$eventId and a.cancel <> 1

		  Group by a.eventId

		";

	$database->setQuery($sql);

	$row->registered=$database->loadResult();

	//Create the task

   if($row->future_event=='y' && $show_past_event==1){

        $task="cut_off_date";

		 if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/closed_62x14.png" border="0" alt="'.JText::_('DT_CLOSED').'" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

   }elseif(($row->cut_off=='y') && ($row->cut_off_date!='0000-00-00')){

		$task="cut_off_date";

		 if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/closed_62x14.png" border="0" alt="'.JText::_('DT_CUT_OFF').'" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

	}elseif(($row->registered>=$row->max_registrations)&&($row->max_registrations)&&($row->waiting_list=='0')){

		$task="full_event_page";

		if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/full_62x14.png" border="0" alt="'.JText::_('DT_FULL').'" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

	}elseif(($row->registered>=$row->max_registrations)&&($row->max_registrations)&&($row->waiting_list=='1')){

		$task="full_event_page_msg";

		if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/full_62x14.png" border="0" alt="'.JText::_('DT_WAITING').'" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

	}else{

		$task="event_register";

		if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/register_62x14.png" border="0" alt="'.JText::_('DT_REGISTER').'" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

	}

	  $queryReg = "SELECT eventID,registration_type FROM #__dtregister_group_event WHERE eventID = " . $row->evdet_id;

	  $database->setQuery( $queryReg );

    $eventReg = $database->loadResult();

    $event = $database->loadObject();

    $eventId = $row->evdet_id;

    $eventReg ;

  if ($eventReg != 0)

	{

      switch ($event->registration_type) {

         case "individual" :

  		      $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_individual",$xhtml_url);

          	  break;

        case "group" :

              $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_group_num",$xhtml_url);

      		  break;

        case "both" :

            $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_options",$xhtml_url);

    	    break;

      }

      }

		 $reglink=JRoute::_($reglink,$xhtml_url);

          return $reglink ;

}

function getcomItemId($option){
		
		global $mainframe;
				
        $database = &JFactory::getDBO();
		$query = " SELECT m.id
					FROM #__components c
					INNER JOIN #__menu m ON c.id = m.componentid
					WHERE c.option = '$option' 
					AND c.parent= 0
					LIMIT 1 ";
	
		$database->setQuery( $query );
	    
		 $Itemid = $database->loadResult();
		 return $Itemid ; 

}

function register_link_small($eventId,$class="" ) {

	global $database,$mosConfig_live_site,$Itemid , $now;

	$database= & Jfactory::getDBO();

    include(JPATH_SITE."/components/com_dtregister/config.dtregister.php");

	$color = $button_color ;

//	$sql="Select distinct(a.id),if(CURDATE()>b.cut_off_date,'y','n') as cut_off,a.*,b.cut_off_date from #__events a ,#__dtregister_group_event b where a.id=$eventId And a.id = b.eventId AND a.publish_up >= NOW()  ORDER by a.publish_up";

	$sql="select distinct(a.evdet_id),a.dtstart, 

if(b.startdate > '".$now->toFormat('%Y-%m-%d')."' and b.startdate is not null,'y','n') as future_event ,if('".$now->toFormat('%Y-%m-%d')."' >b.cut_off_date,'y','n') as cut_off,a.*,b.cut_off_date, b.waiting_list from #__jevents_vevdetail a ,#__dtregister_group_event b where a.evdet_id=$eventId And a.evdet_id = b.eventId  AND a.state=1 ORDER by a.dtstart";

	$database->setQuery($sql);

	$database->getErrorMsg();

	$row = $database->loadObject();

	if($row==null)

		return "";

	$sql="Select max_registrations From #__dtregister_group_event Where eventId=$eventId limit 0,1";

	$database->setQuery($sql);

	$row->max_registrations=$database->loadResult();

	$sql="SELECT SUM(c.numberOfPerson)

				  FROM #__dtregister_user AS a

				  INNER JOIN #__dtregister_group AS b

				  ON a.userId=b.useid

				  INNER JOIN #__dtregister_group_amount AS c

				  ON b.groupId=c.groupId

				  WHERE a.eventId=$row->evdet_id and a.cancel <> 1 

				  GROUP BY a.eventId

		";

	$database->setQuery($sql);

	$row->registered=$database->loadResult();

	//Create the task

   if($row->future_event=='y' ){ // && $show_past_event==1

        //$task="cut_off_date";

		 if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/closed_62x14.png" border="0" alt="'.JText::_('DT_CLOSED').'" />';

			 $separater = " ";

             return $register ;

		   }else{

	    		$register = JText::_( 'DT_CLOSED');

                return $register ;

		   }

   }elseif(($row->cut_off=='y') && ($row->cut_off_date!='0000-00-00')){

		$task="cut_off_date";

		 if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/closed_62x14.png" border="0" alt="'.JText::_('DT_CLOSED').'" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

	}elseif(($row->registered>=$row->max_registrations)&&($row->max_registrations)&&($row->waiting_list=='0')){

		$task="full_event_page";

		if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/full_62x14.png" border="0" alt="'.JText::_('DT_FULL').'" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

	}elseif(($row->registered>=$row->max_registrations)&&($row->max_registrations)&&($row->waiting_list=='1')){

		$task="full_event_page_msg";

		if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/full_62x14.png" alt="'.JText::_('DT_FULL').'" border="0" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

	}else{

		$task="event_register";

		if($front_link_type){

		   	 $register = '<img class="event_button" src="components/com_dtregister/assets/images/'.$color.'/register_62x14.png" border="0" alt="'.JText::_('DT_REGISTER').'" />';

			 $separater = " ";

		   }else{

	    		$register = JText::_( 'DT_REGISTER');

		   }

	}

	  $queryReg = "SELECT eventID,registration_type FROM #__dtregister_group_event WHERE eventID = " . $row->evdet_id;

	  $database->setQuery( $queryReg );

    $eventReg = $database->loadResult();

    $event = $database->loadObject();

    $eventId = $row->evdet_id;

    $eventReg ;

  if ($eventReg != 0)

	{

      switch ($event->registration_type) {

         case "individual" :

  		      $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_individual",$xhtml_url);

          	  break;

        case "group" :

              $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_group_num",$xhtml_url);

      		  break;

        case "both" :

            $reglink=JRoute::_("index.php?option=com_dtregister&eventId=$eventId&Itemid=$Itemid&task=$task&type=reg_options",$xhtml_url);

    	    break;

      }

      }

		 $reglink=JRoute::_($reglink,$xhtml_url);

			$text = "";

	$text ='<a '.$class.' href="'.$reglink.'">'.$register.'</a>';

	return $text;

}

function parse_tags_new($text,$data){
   preg_match_all('/\[[^\]]*\]/',$text,$matches);
  
   $fields = new Custom_field();
   $dtfields  = $fields->getfields();
  
   $keys = array();
   foreach($dtfields as $key=>$field){
      $keys['FIELD'.$field->id] = $field->name  ;
   }
    $keys['USERNAME'] = 'username' ;
	$keys['PASSWORD'] = 'password' ;
	$keys['LOCATION_DETAILS'] = 'location_details' ;
	$keys['BARCODE'] = 'barCodeHtml';
	$keys['AMOUNT_NOTAX'] = 'amountNoTax';
	$keys['TAX'] = 'tax';
	$keys['DATE_REGISTERED'] = 'register_date';
	$dt_evt = new Event($data->eventId );
	
	if($dt_evt->location_id !=""){
	  $location =  new DTlocation();
      $location->load($dt_evt->location_id);
	  if($location->address2 !=""){

	   $location->address2 = "<br />".$location->address2;

	   }
	  $data->location_details = $location->address.$location->address2.'<br /> '.$location->city.', '.$location->state.' '.$location->zip."<br />".$location->country."<br />".$location->phone."<br />".$location->email."<br />".$location->website ;
	}else{
	  $data->location_details = "" ;
	}
	
	if(isset($_SESSION['register']['joomlauser'])){
	   $data->password = $_SESSION['register']['joomlauser']['password'] ;
	}else{
	   $data->password = "" ;
	}
    foreach($matches[0] as $value){
       $str_replace_value = "";
	   $str_replace_key =  substr($value,1,-1);

	   if(isset($keys[$str_replace_key]) && is_array($keys[$str_replace_key])){

		  foreach($keys[$str_replace_key] as $Kkey=>$Kvalue){
               if(!isset($data->{$Kvalue})){
			   continue;
		     }
		     $str_replace_value[] = $data->{$Kvalue};

		  }

		  $str_replace_value = implode(" ",$str_replace_value);

	   }elseif(isset($keys[$str_replace_key])){
          if(isset($data->{$keys[$str_replace_key]})){
		    $str_replace_value = $data->{$keys[$str_replace_key]};
		  }else{
		    $str_replace_value = "";
		  }
	      
	   }

	    $text = str_replace($value,stripslashes($str_replace_value),$text);

	   unset($str_replace_value);

	 }
     
	return $text ;
}

function cancel_email($dt_user,$history,$cancel_fee=0){
  global $currency_code , $email_cancel_confirm  ;
  include( JPATH_SITE.'/components/com_dtregister/config.dtregister.php');
 
   if(isset($history['type']) && $history['type'] != "")
   $dt_user->payment_type = $history['type'];
  $arrCode=array(

     		'USD'=>'$',

     		'BRL'=>'R$',

     		'ZAR'=>'R',

     		'GBP'=>'&#163;',

     		'EUR'=>'&#128;',

     		'JPY'=>'&#165;'

     	);

		foreach($arrCode as $arKey=>$arValue){

			if ($arKey === $currency_code){

				$currency_symbol = $arValue;

				break;

			} else {
	
				$currency_symbol = NULL;
	
			}

		}
	    if($currency_symbol!=""){
		   $currency_code = "";
		}
		global $lang_var ;
		
  $dt_evt =  new Event($dt_user->eventId);
  
  $msg .= '<p>'.$dt_user->userFirstName.' '.$dt_user->userLastName.' '.JText::_('DT_ADMIN_MSG_CANCEL').' '.$dt_evt->summary.'</p>';
  $msg .= '<table class="message">';
    
  $msg.="<tr><td>".JText::_('DT_CONFIRMATION_NUMBER').": </td><td>".$dt_user->confirmNum."</td></tr>";
  $msg.="<tr><td>".JText::_('DT_REGISTRATION_FEE').": </td><td>".$currency_symbol.numberFormat($dt_user->get_amount())." ".$currency_code."</td></tr>";
  $msg.="<tr><td>".JText::_('DT_AMOUNT_PAID').": </td><td>".$currency_symbol.numberFormat($dt_user->paid_amount)." ".$currency_code."</td></tr>";
  $msg.="<tr><td>".JText::_('DT_PAYMENT_TYPE').": </td><td>".$lang_var[$dt_user->payment_type]."</td></tr>";

  $amount = $dt_user->get_amount();
  if($cancel_fee >0 ){
     
	  $msg.="<tr><td>".JText::_('DT_CANCEL_FEE').": </td><td>".$currency_symbol.numberFormat($cancel_fee)." ".$currency_code."</td></tr>";
      if($dt_user->due_payment > 0){
	     $label = JText::_('DT_AMOUNT_DUE') ;
	  }else{
	     $label = JText::_('DT_REFUND_DUE') ;
	  }
	   if(($amount - $dt_user->paid_amount) > 0){
	     $amount = 0 ;
	  }else{
	     $amount = $amount - $dt_user->paid_amount ;
	  }
      $msg.="<tr><td>".$label.": </td><td>".$currency_symbol.numberFormat(abs($dt_user->due_payment),2)." ".$currency_code."</td></tr>";
	  
  }
  
  $msg .="</table>";
  $emails = explode(";",$dt_evt->email) ;
  $conf = &JFactory::getConfig();
  if($DT_mailfrom == ""){
     $DT_mailfrom = $conf->_registry['config']['data']->mailfrom;
  }
  if($DT_fromname==""){
     $DT_fromname =$conf->_registry['config']['data']->fromname;
  }
 // $mosConfig_mailfrom = $conf->_registry['config']['data']->mailfrom;
 // $mosConfig_fromname =$conf->_registry['config']['data']->fromname;
  foreach($emails as $email){
   
    JUTility::sendMail( $DT_mailfrom, $DT_fromname,$email,JText::_('DT_ADMIN_SUBJECT_CANCEL'),$msg,1,null,null);
  }
  $dt_user->event = new Event($dt_user->eventId);
  $message = thanks_email_tags($dt_user,$email_cancel_confirm);
  $status =  array(JText::_('DT_ACTIVE'),JText::_('DT_CANCELLED'),JText::_('DT_PENDING'));
  $paid_status = array(0=>JText::_('DT_NOT_PAID'),1=>JText::_('DT_PAID'));
  $upsubcancelemail = str_replace('[EVENT_NAME]',$dt_user->event->summary,$upsubcancelemail);
  
  $upsubcancelemail = str_replace('[EVENT_DATE]',get_date($dt_user->event->dtstart,$dt_user->event->dtend),$upsubcancelemail);
  $upsubcancelemail = str_replace('[STATUS]',$status[$dt_user->cancel],$upsubcancelemail);
  $upsubcancelemail = str_replace('[PAID_STATUS]',$paid_status[$dt_user->pay_later_paid],$upsubcancelemail);
    
  JUTility::sendMail( $DT_mailfrom, $DT_fromname,$dt_user->userEmail,$upsubcancelemail,$message,1,null,null);
  
}

function due_email($dt_user,$history){
   global $currency_code , $payment_confirm ;
   global $lang_var ;
   include( JPATH_SITE.'/components/com_dtregister/config.dtregister.php');
   if(isset($history['type']) && $history['type'] != "")
   $dt_user->payment_type = $history['type'];
   
  $arrCode=array(

     		'USD'=>'$',

     		'BRL'=>'R$',

     		'ZAR'=>'R',

     		'GBP'=>'&#163;',

     		'EUR'=>'&#128;',

     		'JPY'=>'&#165;'

     	);

		foreach($arrCode as $arKey=>$arValue){

			if ($arKey === $currency_code){

				$currency_symbol = $arValue;

				break;

			} else {
	
				$currency_symbol = NULL;
	
			}

		}
	    if($currency_symbol!=""){
		   $currency_code = "";
		}
 
  $dt_evt =  new Event($dt_user->eventId);
  $msg .= '<p>'.$dt_user->userFirstName.' '.$dt_user->userLastName.' '.JText::_('DT_ADMIN_MSG_PAYMENT').' '.$dt_evt->summary.' ('.get_date($dt_evt->dtstart,$dt_evt->dtend).')</p>';
  $msg .= '<table class="message">';
    
  $msg.="<tr><td>".JText::_('DT_CONFIRMATION_NUMBER').": </td><td>#".$dt_user->confirmNum."</td></tr>";

  $amount = $dt_user->get_amount();
 
	  $msg.="<tr><td>".JText::_('DT_AMOUNT_PAID').": </td><td>".$currency_symbol.numberFormat($history['amount'],2)." ".$currency_code."</td></tr>";

      $msg.="<tr><td>".JText::_('DT_AMOUNT_DUE').": </td><td>".$currency_symbol.numberFormat(($amount - $dt_user->paid_amount),2)." ".$currency_code."</td></tr>";
	  
	   $msg.="<tr><td>".JText::_('DT_PAYMENT_TYPE').": </td><td>".$lang_var[$dt_user->payment_type]."</td></tr>";
  
  $msg .="</table>";
  $emails = explode(";",$dt_evt->email) ;
  $conf = &JFactory::getConfig();
  if($DT_mailfrom == ""){
     $DT_mailfrom = $conf->_registry['config']['data']->mailfrom;
  }
  if($DT_fromname==""){
     $DT_fromname =$conf->_registry['config']['data']->fromname;
  }
 // $mosConfig_mailfrom = $conf->_registry['config']['data']->mailfrom;
 // $mosConfig_fromname =$conf->_registry['config']['data']->fromname;
  
  foreach($emails as $email){
    
    JUTility::sendMail( $DT_mailfrom, $DT_fromname,$email,JText::_('DT_ADMIN_SUBJECT_PAYMENT'),$msg,1,null,null);
  }

  $dt_user->event = $dt_evt ; 
  
  $message = thanks_email_tags($dt_user,$payment_confirm);
  
  $status =  array(JText::_('DT_ACTIVE'),JText::_('DT_CANCELLED'),JText::_('DT_PENDING'));
  $paid_status = array(JText::_('DT_NOT_PAID'),JText::_('DT_PAID'));
  $upsubpaymentemail = str_replace('[EVENT_NAME]',$dt_user->event->summary,$upsubpaymentemail);
  
  $upsubpaymentemail = str_replace('[EVENT_DATE]',get_date($dt_user->event->dtstart,$dt_user->event->dtend),$upsubpaymentemail);
  $upsubpaymentemail = str_replace('[STATUS]',$status[$dt_user->cancel],$upsubpaymentemail);
  $upsubpaymentemail = str_replace('[PAID_STATUS]',$paid_status[$dt_user->pay_later_paid],$upsubpaymentemail);
 
  JUTility::sendMail( $DT_mailfrom, $DT_fromname,$dt_user->userEmail,$upsubpaymentemail,$message,1,null,null);
  
}

function change_email($dt_user,$history,$old_fee){
   global $currency_code , $email_cancel_confirm ,$subchangestatusemail , $lang_var ;
   $dt_user =  new DT_User($dt_user->id);
   include( JPATH_SITE.'/components/com_dtregister/config.dtregister.php');
   if(isset($history['type']) && $history['type'] != "")
   $dt_user->payment_type = $history['type'];
  $arrCode=array(

     		'USD'=>'$',

     		'BRL'=>'R$',

     		'ZAR'=>'R',

     		'GBP'=>'&#163;',

     		'EUR'=>'&#128;',

     		'JPY'=>'&#165;'

     	);

		foreach($arrCode as $arKey=>$arValue){

			if ($arKey === $currency_code){

				$currency_symbol = $arValue;

				break;

			} else {
	
				$currency_symbol = NULL;
	
			}

		}
	    if($currency_symbol!=""){
		   $currency_code = "";
		}

  $dt_evt =  new Event($dt_user->eventId);
  $msg = "" ;
  $msg .= '<p>'.$dt_user->userFirstName.' '.$dt_user->userLastName.' '.JText::_('DT_ADMIN_MSG_CHANGE').' '.$dt_evt->summary.'</p>';
  $msg .= '<table class="message">';
  
  $msg.="<tr><td>".JText::_('DT_ORIGINAL_FEE').": </td><td>".$old_fee."</td></tr>";
  $msg.="<tr><td>".JText::_('DT_NEW_FEE').": </td><td>".$dt_user->get_amount()."</td></tr>";
  $msg.="<tr><td>".JText::_('DT_CONFIRMATION_NUMBER').": </td><td>".$dt_user->confirmNum."</td></tr>";
  if((float)$history['amount'] > 0){
     
	$msg.="<tr><td>".JText::_('DT_TRANSACTION_ID').": </td><td>".$history['transaction_id']."</td></tr>";
    $msg.="<tr><td>".JText::_('DT_PAYMENT_TYPE').": </td><td>".$lang_var[$history['type']]."</td></tr>";
    $msg.="<tr><td>".JText::_('DT_AMOUNT_PAID').": </td><td>".$history['amount']."</td></tr>";
	 
  }
  if($cancel_fee >0 ){
     
	  $msg.="<tr><td>".JText::_('DT_CANCEL_FEE').": </td><td>".$currency_symbol.numberFormat($cancel_fee,2)." ". $currency_code ."</td></tr>";

      $msg.="<tr><td>".JText::_('DT_AMOUNT_DUE').": </td><td>".$currency_symbol.numberFormat(($amount - $dt_user->paid_amount),2)." ". $currency_code ."</td></tr>";
  }
  
  $msg.=userdata($dt_user->userId);
  
  $msg .="</table>";
  
  $emails = explode(";",$dt_evt->email) ;
  $conf = &JFactory::getConfig();
   if($DT_mailfrom == ""){
     $DT_mailfrom = $conf->_registry['config']['data']->mailfrom;
  }
  if($DT_fromname==""){
     $DT_fromname =$conf->_registry['config']['data']->fromname;
  }
  //$mosConfig_mailfrom = $conf->_registry['config']['data']->mailfrom;
  //$mosConfig_fromname =$conf->_registry['config']['data']->fromname;
  foreach($emails as $email){
    
    JUTility::sendMail( $DT_mailfrom, $DT_fromname,$email,JText::_('DT_ADMIN_SUBJECT_CHANGE'),$msg,1,null,null);
	
  }
  $debugmsg = ob_get_clean();
 
  $dt_user->event = $dt_evt ; 
  $message = thanks_email_tags($dt_user,$email_change_confirm);
  $status =  array(JText::_('DT_ACTIVE'),JText::_('DT_CANCELLED'),JText::_('DT_PENDING'));
   $paid_status = array(JText::_('DT_NOT_PAID'),JText::_('DT_PAID'));
  $upsubchangeemail = str_replace('[EVENT_NAME]',$dt_user->event->summary,$upsubchangeemail);
  
  $upsubchangeemail = str_replace('[EVENT_DATE]',get_date($dt_user->event->dtstart,$dt_user->event->dtend),$upsubchangeemail);
  $upsubchangeemail = str_replace('[STATUS]',$status[$dt_user->cancel],$upsubchangeemail);
  $upsubchangeemail = str_replace('[PAID_STATUS]',$paid_status[$dt_user->pay_later_paid],$upsubchangeemail);
  
  JUTility::sendMail( $DT_mailfrom, $DT_fromname,$dt_user->userEmail,$upsubchangeemail,$message,1,null,null);

}

function userdata($user_id){
   
   $dt_user = new DT_User($user_id);
   $dt_evt  = new Event($dt_user->eventId);
   
   $html .= '<tr><td>'.JText::_( 'DT_FIRSTNAME' ).':</td><td>'.stripslashes($dt_user->userFirstName).'</td></tr>';
   
   $html .= '<tr><td>'.JText::_( 'DT_LASTNAME' ).':</td><td>'.stripslashes($dt_user->userLastName).'</td></tr>';
     
   $html .= '<tr><td>'.JText::_( 'DT_ORGANIZATION' ).':</td><td>'.stripslashes($dt_user->userOrganization).'</td></tr>';
   
   $html .= '<tr><td>'.JText::_( 'DT_ADDRESS' ).':</td><td>'.stripslashes($dt_user->userAddress).'</td></tr>';

   $html .= '<tr><td>'.JText::_( 'DT_CITY' ).':</td><td>'.stripslashes($dt_user->userCity).'</td></tr>';

   $html .= '<tr><td>'.JText::_( 'DT_STATE' ).':</td><td>'.stripslashes($dt_user->userState).'</td></tr>';
   
   $html .= '<tr><td>'.JText::_( 'DT_COUNTRY' ).':</td><td>'.stripslashes($dt_user->userCountry).'</td></tr>';

   $html .= '<tr><td>'.JText::_( 'DT_ZIPCODE' ).':</td><td>'.stripslashes($dt_user->userZip).'</td></tr>';

   $html .= '<tr><td>'.JText::_( 'DT_PHONE' ).':</td><td>'.stripslashes($dt_user->userPhone).'</td></tr>';
   
   $html .= '<tr><td>'.JText::_( 'DT_EMAIL' ).':</td><td>'.stripslashes($dt_user->userEmail).'</td></tr>';
   if((int)$dt_user->user_id >0){
	    $html .= '<tr><td>'.JText::_( 'DT_USERNAME' ).':</td><td>'.stripslashes($dt_user->username).'</td></tr>';
	   
   }
	if($dt_user->userType=='G'){
	 $field_type = "B";
	}else{
	  $field_type = "I";
	}
	$html .= $dt_user->event->field_view($field_type,$dt_user);
	
   if($dt_user->userType=='G'){
    
   $fields = $dt_user->event->get_group_custom_field();
   foreach((array)$fields as $key => $value){
      $temp[$value->name] = $value;
   }
   
   $i  = 1;
   $id_fields = array('groupMemberId','groupUserId','groupId','useid');
   
   $members = $dt_user->get_members();
    foreach($members as $key => $value){
	   
	   $html .=  "<tr><td colspan=2><br /><u>".JText::_( 'DT_MEMBER' )." {$i}</u></td></tr>";
	   if(!isset($value->remove) && $value->remove !=1){
	         
	       foreach ((array)$value as $key2 => $value2){
	     
		  if($value2!="" && !in_array($key2,$id_fields)){
		     if(isset($temp[$key2])){
			   $html .=  "<tr><td>" . stripslashes($temp[$key2]->label) . ": </td><td>". stripslashes($value2) ."</td></tr>";
			 }else{
		       $html .=  "<tr><td>" . stripslashes($key2) . ": </td><td>". stripslashes($value2) ."</td></tr>";
			 }
		  }
		   
	   }
	       $i++ ;
	   } 
	}
	
   }

   return $html ;
   
}

function registration_email_frontend($userId){

	global $database,$mosConfig_live_site,$mosConfig_absolute_path,$DT_mailfrom,$DT_fromname,$Itemid,$my;

	$database = &JFactory::getDBO();
    jimport('joomla.filesystem.file');
    include_once(JPATH_SITE.'/components/com_dtregister/class.dtregister.php');

	include(JPATH_SITE."/components/com_dtregister/config.dtregister.php");
    
	$conf = &JFactory::getConfig();
  if($DT_mailfrom == ""){
     $DT_mailfrom = $conf->_registry['config']['data']->mailfrom;
  }
  if($DT_fromname==""){
     $DT_fromname =$conf->_registry['config']['data']->fromname;
  }
 // $mosConfig_mailfrom = $conf->_registry['config']['data']->mailfrom;

//  $mosConfig_fromname =$conf->_registry['config']['data']->fromname;
global $lang_var ;
		
	//Currency symbol

	$arrCode=array();

	$arrSymbol=array();

	$arrCode[]='USD';$arrSymbol[]='$';

  $arrCode[]='BRL';$arrSymbol[]='R$';

  $arrCode[]='ZAR';$arrSymbol[]='R';

	$arrCode[]='GBP';$arrSymbol[]='&#163;';

	$arrCode[]='EUR';$arrSymbol[]='&#128;';

	$arrCode[]='JPY';$arrSymbol[]='&#165;';

	$arrCode[]='CHF';$arrSymbol[]='&#8355;';

	$index=-1;

	for($i=0,$n=count($arrCode);$i<$n;$i++)

	{

		if($arrCode[$i]==$currency_code)

		{

			$index=$i;

			break;

		}

	}

	if($index!=-1){

		$currency_symbol=$arrSymbol[$index];

	} else {

		$currency_symbol='$';

	}

	$sql="Select * From #__dtregister_user u inner join #__dtregister_group dg on dg.useid= u.userId inner join #__dtregister_group_amount ga on ga.groupId = dg.groupId  where u.userId=$userId";

	$database->setQuery($sql);

	$rowUser = $database->loadObject();

    $address= stripslashes($rowUser->userAddress);
	
	$address2= stripslashes($rowUser->userAddress2);

	 $city = stripslashes($rowUser->userCity);

	 $zip = stripslashes($rowUser->userZip);

	 $state = stripslashes($rowUser->userState);

	 $email = stripslashes($rowUser->userEmail);

	 $country = stripslashes($rowUser->userCountry);

     $title= (stripslashes($rowUser->userTitle)=="")?'':stripslashes($rowUser->userTitle)." ";  
	  
	 $fname = stripslashes($rowUser->userFirstName);

	 $lname = stripslashes($rowUser->userLastName);

	 $phone = stripslashes($rowUser->userPhone);

	 $org = stripslashes($rowUser->userOrganization);

	 $type = $rowUser->payment_type;

	 $eventId = $rowUser->eventId;

     $evt = new Event($eventId);

    $evt->over_ride_global();

	 $amount  = $rowUser->amount;

	 $memtot  = $rowUser->numberOfPerson;

	 $userType = $rowUser->userType;

     $rowUser->amount_due = $amount - $rowUser->paid_amount;

	// for the custom email
   $address2_display = "";
   $comma = "";
   if($address2!=""){
      $address2_display = $address2."<br />";
	  $comma = ",";
	  
   }
   
	$contactDetails = $address.'<br />'.$address2_display.' '.$city.', '.$state.' '.$zip.'<br />'.$phone.'<br />'.$email;

	$msg = '';

	$msg .= '<table><link href="components/com_dtregister/main.css" rel="stylesheet" type="text/css">';

	$msg .= '<h3>'.JText::_( 'DT_REGISTRATION_DETAILS').':</h3>';

	$msg .= '<table class="message">';

	$msg .= "<tr><td colspan=2>$thanksmsg</td></tr>";

	$msg .= '<tr><td>'.JText::_( 'DT_NAME').': </td><td>'.$title.$fname.' '.$lname.'</td></tr>';

	$msg .= '<tr><td rowspan="2">'.JText::_( 'DT_ADDRESS').': </td><td>'.$address.'</td></tr>';
   
    if($address2 != ""){
	  $msg .= '<tr><td rowspan="2">'.JText::_( 'DT_ADDRESS2').': </td><td>'.$address2.'</td></tr>';
	}

	$msg .= '<tr><td>'.$city.' '.$state.' '.$zip.'</td><tr>';

	$msg .= '<tr><td>'.JText::_( 'DT_AMOUNT').': </td><td>'.$currency_symbol. numberFormat($amount,2).'</td></tr><tr><td><h3>'.JText::_( 'DT_THANKS_PAYPAL').'</h3></td></tr>';

	  $msg.'<tr><td><a href="'.$mosConfig_live_site.'">'.JText::_( 'RETURN_TO_SITE').'</a></td></tr></table>';

	//Get custom fields and store in CustomFields array

	$arrCustomFields=array();
$dt_user = new DT_User($userId,$eventId);
    $admin_attachments = array();
    $cfields = array();
   $fld = new Custom_field();
    $fields=array() ;
	$type = ($userType=='I')?'I':'B' ;
	$fld->getAllFields($eventId,$type,false,0,$fields) ;
			
			$rows1 = $fields ;
  
	for($i=0,$n=count($rows1);$i<$n;$i++){

          if($rows1[$i]->type==7){
		   if($rows1[$i]->upload){
		      $name = $rows1[$i]->name ;
		      $admin_attachments[] = addslashes(JPATH_SITE . DS . "images" . DS ."dtregister".DS."uploads".DS.$rowUser->$name);
		   }
		}

		$tmparray = array($rows1[$i]->name => $rows1[$i]->label);

         $cfields[$rows1[$i]->name] = $rows1[$i];

		array_push_associative($arrCustomFields,$tmparray);

	}
 
      $admin_attachments = array_filter($admin_attachments);
  
	// send out emails to the registant and the admin

     $sql="Select summary ,  evdet_id From #__jevents_vevdetail Where evdet_id=$eventId";

	$database->setQuery($sql);

	$eventName=$database->loadResult();

	$sql="Select dtstart From #__jevents_vevdetail Where evdet_id=$eventId";

	$database->setQuery($sql);

	$eventBegin=$database->loadResult();

		// $subthanksemail = sprintf($subthanksemail,$eventName);

		$subthanksemail = str_replace('[EVENT_NAME]',$eventName,$subthanksemail);

		$amountCharged = $amount ;

		$thanksemail = sprintf($thanksemail,$eventName,$amountCharged);

    $subadmin = JText::_('DT_ADMIN_SUBJECT');

	$sql="SELECT summary,dtstart,dtend FROM #__jevents_vevdetail WHERE evdet_id=$eventId";

	  $database->setQuery($sql);

		$row = $database->loadObject();

		$adminmsg="";

			$adminmsg.= $title.$fname . ' ' . $lname . ' ' . JText::_('DT_ADMIN_MESSAGE') . ' ' . $eventName . ' (' . get_date($eventBegin,$row->dtend,null,true) . ').<br><br>';

		$adminmsg.= JText::_('DT_ADMIN_MSG_DETAILS') . ":<br><br>";

		$eventName=$row->summary;

		$startDate=$row->dtstart;

		$endDate=$row->dtend;

		$start_date =JFactory::getDate($row->dtstart)->toFormat('%b %d, %Y');

		$end_date  = JFactory::getDate($row->dtend)->toFormat('%b %d, %Y');

		$event_date = get_date($row->dtstart,$row->dtend,null,true);

		if($start_date != $end_date ){

			$event_date .= " - ".get_date($row->dtend,null,true);

		}

		$adminmsg.="<table>";

		$adminmsg.="<tr><td>".JText::_('DT_EVENT_NAME').": </td><td>".$eventName."</td></tr> ";

		$adminmsg.="<tr><td>".JText::_('DT_EVENT_DATE').": </td><td>".$event_date."</td></tr> ";

		$adminmsg.="<tr><td>".JText::_('DT_ADMIN_REGISTRANT_NAME').": </td><td>$title $fname $lname</td></tr> ";
		
		if($org != NULL){$adminmsg.="<tr><td>".JText::_('DT_ORGANIZATION').": </td><td> $org</td></tr> ";}

        $address2_display = "";
	   $comma = "";
	   if($address2!=""){
		  $address2_display = $address2."<br /> ";
		  $comma = ",";
		  
	   }
   
		if(($address) != NULL){$adminmsg.="<tr><td>".JText::_('DT_ADDRESS').": </td><td> $address </td></tr> ";}
		
		if(($address2) != NULL){$adminmsg.="<tr><td>".JText::_('DT_ADDRESS2').": </td><td> $address2</td></tr> ";}

		if($city != NULL){

			if($state != NULL){

				$adminmsg.="<tr><td>".JText::_('DT_CITY_STATE').": </td><td> $city ($state, $country)</td></tr> ";

			} else {

				$adminmsg.="<tr><td>".JText::_('DT_CITY')." (".JText::_('DT_COUNTRY')."): </td><td> $city ( $country)</td></tr> ";

			}

		}

		if($zip != NULL){$adminmsg.="<tr><td>".JText::_('DT_ZIPCODE').": </td><td> $zip</td></tr> ";}

		if($phone != NULL){$adminmsg.="<tr><td>".JText::_('DT_PHONE').": </td><td> $phone</td></tr> ";}

		$adminmsg.="<tr><td>".JText::_('DT_EMAIL').": </td><td> $email</td></tr>";
       if((int)$dt_user->user_id >0){
	       $adminmsg .= "<tr><td>".JText::_( 'DT_USERNAME' ).":</td><td>".stripslashes($dt_user->username)."</td></tr> ";
	   
       }
		$contactCustomFields = '';

		if ($arrCustomFields){

			foreach ($arrCustomFields as $key => $value){

				if($rowUser->$key=="" && $cfields[$key]->type !=6){

					continue;

				}
				
				if($cfields[$key]->type == 7){
				   
				   $rowUser->$key =  JFile::getName($rowUser->$key);
				}
                if($cfields[$key]->type == 6){
				   	$adminmsg .= "<tr><td colspan='2'>".$cfields[$key]->textual.":</td></tr> ";
					$contactCustomFields .= $cfields[$key]->textual.'<br />';
				}else{
					$adminmsg .= "<tr><td>".$value.":</td><td>".$rowUser->$key."</td></tr> ";
					$contactCustomFields .= $value.": ".$rowUser->$key."<br /> ";
				}
				

				

			}

		}

		 $adminmsg.="<tr><td>".JText::_('DT_REGISTRATION_FEE').": </td><td>".numberFormat($amount,2)."</td></tr> ";

         $adminmsg.="<tr><td>".JText::_('DT_AMOUNT_PAID').": </td><td>".numberFormat($rowUser->paid_amount,2)."</td></tr> ";
         
		 $adminmsg.="<tr><td>".JText::_('DT_PAYMENT_TYPE').": </td><td>".$lang_var[$rowUser->payment_type]."</td></tr> ";
		 
		 if($rowUser->transaction_id != ""){
		     
			 $adminmsg.="<tr><td>".JText::_('DT_TRANSACTION_ID').": </td><td>".$rowUser->transaction_id."</td></tr> ";
			 
		 }

		 $adminmsg.="<tr><td>".JText::_('DT_CONFIRMATION_NUMBER').": </td><td>".$rowUser->confirmNum."</td></tr> ";

        if($rowUser->discount_code_id != 0 && $rowUser->discount_code_id !=''){

			$dt_code = new DiscountCode($rowUser->discount_code_id);

			$adminmsg.="<tr><td>".JText::_('DT_DISCOUNT_CODE').": </td><td>".$dt_code->code."</td></tr> ";

	    }

		if ($userType == 'G'){
             $fields=array() ;
	
	        $fld->getAllFields($eventId,'M',false,0,$fields) ;
			$arrCustomFields =  array();
			foreach($fields as $field){
			   $arrCustomFields[$field->name] = $field->label ;
			}
			$adminmsg.="<tr><td colspan=2>".JText::_('DT_ADMIN_GROUP_DETAILS').": </td></tr> ";

			// get the details of the group users

			$sql2 = "SELECT m.* FROM #__dtregister_group_member m, #__dtregister_group g

					WHERE g.useid={$userId} AND g.groupId=m.groupUserId order by m.groupMemberId ";

			//$adminmsg.=$sql2;

			$database->setQuery($sql2);

			$rowUser2=$database->loadObjectList();

			//$memtot = count($rowUser);

			$adminmsg.="<tr><td>".JText::_('DT_NUMBER_MEMBERS').":</td><td>".count($rowUser2)."</td></tr> ";

			$groupCustomFields = '';

			for ($i=0,$n=count($rowUser2);$i<$n;$i++){

				$row=$rowUser2[$i];

				$adminmsg.="<tr><td colspan=2><br><br>".JText::_('DT_MEMBER') .($i+1)."</td></tr> ";

				if ($row->lastname){

                   if($row->title !=""){
				    $mtitle = $row->title." ";
				 }

				$adminmsg.="<tr><td>".JText::_('DT_NAME').": </td><td>".$mtitle.$row->firstname . ' ' .$row->lastname."</td></tr> ";
                    
				$memberNames .= ' ' . stripslashes($mtitle.$row->firstname);

				$memberNames .= ' ' . stripslashes($row->lastname)."<br>";

				}

				if ($row->organization){$adminmsg.="<tr><td>".JText::_('DT_ORGANIZATION').": </td><td>". $row->organization."</td></tr> ";}

					if (($row->address.$row->address2)!=""){$adminmsg.="<tr><td>".JText::_('DT_ADDRESS').": </td><td>".$row->address."  ".$row->address2."</td></tr> ";}

				if ($row->city || $row->state || $row->country){

					$adminmsg.="<tr><td>";

						if ($row->city){$adminmsg.=JText::_('DT_CITY');}

						if ($row->state || $row->country){$adminmsg.=' ('.JText::_('DT_STATE');}

						if ($row->state && $row->country){$adminmsg.=', ';}

						if ($row->country){$adminmsg.=JText::_('DT_COUNTRY');}

						if ($row->state || $row->country){$adminmsg.=')';}

						$adminmsg.=": </td><td>";

						if ($row->city){$adminmsg.=$row->city;}

						if ($row->state || $row->country){$adminmsg.=' ('.$row->state;}

						if ($row->state && $row->country){$adminmsg.=', ';}

						if ($row->country){$adminmsg.=$row->country;}

						if ($row->state || $row->country){$adminmsg.=')';}

						$adminmsg.="</td></tr>";

				}

				if ($row->zip){$adminmsg.="<tr><td>".JText::_('DT_ZIPCODE').": </td><td>".$row->zip."</td></tr> ";}

				if ($row->phone){$adminmsg.="<tr><td>".JText::_('DT_PHONE').": </td><td>".$row->phone."</td></tr> ";}

				if ($row->email){$adminmsg.="<tr><td>".JText::_('DT_EMAIL').": </td><td>".$row->email."</td></tr> ";}
                 $groupCustomFields .= JText::_('DT_MEMBER') .($i+1).': '.$mtitle.$row->firstname . ' ' .$row->lastname.'<br />';
				if ($arrCustomFields){

					foreach ($arrCustomFields as $key => $value){

						if($row->$key =="" && $cfields[$key]->type !=6){

							continue;

						}
                        if($cfields[$key]->type==7){
				   if($cfields[$key]->upload){
				      $admin_attachments[] =  addslashes(JPATH_SITE . DS . "images" . DS ."dtregister".DS."uploads".DS.$row->$key);

				   }
				}
				
						if ($row->$key || $cfields[$key]->type == 6){

                              if($cfields[$key]->type == 7){
				   
							   $rowUser->$key =  JFile::getName($rowUser->$key);
							}
                            
							 if($cfields[$key]->type == 6){
								$adminmsg .= "<tr><td colspan='2'>".$cfields[$key]->textual.":</td></tr> ";
								$groupCustomFields .= $cfields[$key]->textual.'<br />';
							}else{
								$adminmsg .= "<tr><td>".$value.":</td><td>".$row->$key."</td></tr> ";

							   $groupCustomFields .= $value.": ".$row->$key."<br />";
							}
							

						}

					}
					
					$groupCustomFields .= "<br /><br />";

				}

			}

		}else{
		   
		   	

				$memberNames = "$title $fname $lname <br>";	
		}


        if(isset($rowUser->billing_name) && $rowUser->billing_name!=""){

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_NAME').": </td><td>".$rowUser->billing_name."</td></tr> ";

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_ADDRESS').": </td><td>".$rowUser->billing_address."</td></tr> ";

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_CITY').": </td><td>".$rowUser->billing_city."</td></tr> ";

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_STATE').": </td><td>".$rowUser->billing_state."</td></tr> ";

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_ZIPCODE').": </td><td>".$rowUser->billing_zipcode."</td></tr> ";

		}
global $barCodeImagetypeToExt , $barcode_image_type ;
  $barcodePath =JURI::root( false )."images/dtregister/barcode/".$rowUser->confirmNum.".".$barCodeImagetypeToExt[$barcode_image_type];
  $barcodeImg = '<img border="0" src="'.$barcodePath.'" />';
  if($barcode_enable){
     $adminmsg.="<tr><td>".JText::_('DT_BARCODE').": </td><td>".$barcodeImg."</td></tr> ";
  }
		$adminmsg.="</table></pre>";
	

	//Get the admin email now and the thank you message

	$sql = "SELECT a.summary title,a.dtstart publish_up, a.dtend publish_down,b.email,b.thksmsg,b.thksmsg_set FROM #__jevents_vevdetail a,#__dtregister_group_event b WHERE a.evdet_id=b.eventId  AND  a.evdet_id=$eventId";

	$database->setQuery($sql);

	$rowAdminEmail = $database->loadObject();

    $sql1 = "SELECT config_value , id FROM #__dtregister_config WHERE config_key='thanksemail'";

    $database->setQuery($sql1);

  	$defaultthksmsg = $database->loadResult();

    if($rowAdminEmail->email){

		$adminemail=$rowAdminEmail->email;

		$thksmsg=stripslashes($rowAdminEmail->thksmsg);

		$thksmsg_set=$rowAdminEmail->thksmsg_set;

		$eventBegin=$rowAdminEmail->publish_up;

		$eventEnd=$rowAdminEmail->publish_down;

		$eventTitle=$rowAdminEmail->title;

	} else {

		//$adminemail=$mosConfig_mailfrom;

		$adminemail="";

	}
	
	  $status =  array(JText::_('DT_ACTIVE'),JText::_('DT_CANCELLED'),JText::_('DT_PENDING'));
		 
	  $paid_status = array(JText::_('DT_NOT_PAID'),JText::_('DT_PAID'));
       
	// If custom email message is selected... use it!
    $evt =  new Event($eventId);
		
		$location = $evt->get_location();
       
		$constants = array('[TITLE]','[FIRSTNAME]','[NAME]','[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[AMOUNT_DUE]','[AMOUNT_PAID]','[STATUS]','[PAID_STATUS]','[BARCODE]');

		if ($type=='pay_later'){$type='Pay Later';}

		$replace = array($title, $fname , $fname.' '.$lname, $org, $eventName, get_date($eventBegin,$eventEnd), $dt_user->get_contact_details(), isset($memberNames)?$memberNames:'', $memtot, numberFormat($amount,2), $lang_var[$rowUser->payment_type], $contactCustomFields, isset($groupCustomFields)?$groupCustomFields:'',$rowUser->confirmNum,$location===false?'':$location->name,numberFormat($rowUser->amount_due,2),numberFormat($rowUser->paid_amount,2),$status[$rowUser->cancel],$paid_status[$rowUser->pay_later_paid],$barcodeImg);

    if ($thksmsg_set == 1){

		$thanksemail = str_replace($constants, $replace, $thksmsg);
		
    $constants = array('[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[AMOUNT_DUE]','[AMOUNT_PAID]','[STATUS]','[PAID_STATUS]');
		
		$replace = array($org, $eventName, get_date($eventBegin,$eventEnd), $dt_user->get_contact_details(), isset($memberNames)?$memberNames:'', $memtot, numberFormat($amount,2), $lang_var[$rowUser->payment_type], $contactCustomFields, isset($groupCustomFields)?$groupCustomFields:'',$rowUser->confirmNum,$location===false?'':$location->name,numberFormat($rowUser->amount_due,2),numberFormat($rowUser->paid_amount,2),$status[$rowUser->cancel],$paid_status[$rowUser->pay_later_paid]);
		
     $thanks_msg_member = str_replace($constants, $replace, $thksmsg); 

		$subthanksemail = str_replace('[EVENT_NAME]',$eventName,$subthanksemail);
		
		$subthanksemail = str_replace('[STATUS]',$status[$rowUser->cancel],$subthanksemail);
		
		$subthanksemail = str_replace('[PAID_STATUS]',$paid_status[$rowUser->pay_later_paid],$subthanksemail);

		$subthanksemail = str_replace('[EVENT_DATE]',JHTML::_('date', $eventBegin),$subthanksemail);

	} else {

    $thanksemail = str_replace($constants, $replace, $defaultthksmsg);

    $constants = array('[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[AMOUNT_DUE]','[STATUS]','[PAID_STATUS]','[AMOUNT_PAID]');
		
		$replace = array($org, $eventName, get_date($eventBegin,$eventEnd), $dt_user->get_contact_details(), isset($memberNames)?$memberNames:'', $memtot, numberFormat($amount,2), $lang_var[$rowUser->payment_type], $contactCustomFields, isset($groupCustomFields)?$groupCustomFields:'',$rowUser->confirmNum,$location===false?'':$location->name,$rowUser->amount_due,$status[$rowUser->cancel],$paid_status[$rowUser->pay_later_paid],numberFormat($rowUser->paid_amount,2));
		
    $thanks_msg_member = str_replace($constants, $replace, $defaultthksmsg);

		$subthanksemail = str_replace('[EVENT_NAME]',$eventName,$subthanksemail);

		$subthanksemail = str_replace('[EVENT_DATE]',JHTML::_('date', $eventBegin),$subthanksemail);
		
		$subthanksemail = str_replace('[STATUS]',$status[$rowUser->cancel],$subthanksemail);
		
		$subthanksemail = str_replace('[PAID_STATUS]',$paid_status[$rowUser->pay_later_paid],$subthanksemail);

	}

    $sql = "SELECT config_value FROM #__dtregister_config WHERE config_key='subthanksemail'";

    $database->setQuery($sql);

	  $subthanksemail = $database->loadResult();

    $user_thanksemail	= stripslashes($thanksemail);

    $subthanksemail = str_replace('[EVENT_DATE]',get_date($eventBegin,$eventEnd),$subthanksemail);

	  $subthanksemail = str_replace('[EVENT_NAME]',$eventTitle,$subthanksemail);

		$adminmsg	= stripslashes($adminmsg);

		$subadmin	= stripslashes($subadmin);

		$subthanksemail = stripslashes($subthanksemail);

		$pos = strrpos($adminemail, ";");

		if ($pos === false) { 

			$adminemails = array($adminemail);

		}else{

			$adminemails = explode(";",$adminemail);

		}
       
		foreach($adminemails as $value){
              
		    JUTility::sendMail($DT_mailfrom, $DT_fromname,$value,$subadmin,nl2br($adminmsg),1,null,null,$admin_attachments);

		}

    $evt =  new Event($eventId);

    $data = $evt->get_files();

  	$attachments = null ;

	  foreach($data as $file){

		  $attachments[] = $file->path;

	  }

	$mail =& JFactory::getMailer();

      $user_thanksemail =  parse_tags_new($user_thanksemail,$dt_user); 
  
    JUTility::sendMail( $DT_mailfrom, $DT_fromname,$email,$subthanksemail,$user_thanksemail,1,null,null,$attachments);
	
   if($sendEmailToGroup && isset($rowUser2) && is_array($rowUser2) && count($rowUser2) >0 ){
       
	   foreach($rowUser2 as $member){
		      $member->barCodeHtml = $dt_user->barCodeHtml ;
	     $title = "" ;
		   $firstname = "";
		   $lastname  = "";
		   $title = ($member->title != "")?$member->title." ":'';
		   $firstname = ($member->firstname != "")?$member->firstname." ":'';
		   $lastname = ($member->lastname != "")?$member->lastname:'';
	     if($member->email !=""){
		     $member_thanksemail = str_replace('[TITLE]',$title,$thanks_msg_member);
		     $member_thanksemail = str_replace('[NAME]',$firstname.$lastname,$member_thanksemail);
			 $member_thanksemail = str_replace('[FIRSTNAME]',$firstname,$member_thanksemail);
			 $member_thanksemail =  parse_tags_new(($member_thanksemail),$member); 
		     JUTility::sendMail( $DT_mailfrom, $DT_fromname,$member->email,$subthanksemail,$member_thanksemail,1,null,null,$attachments);
		   }
	   }
	     
   }
 
}

function registration_email_only_user($userId){

	global $database,$mosConfig_live_site,$mosConfig_absolute_path,$DT_mailfrom,$DT_fromname,$Itemid,$my;

	$database = &JFactory::getDBO();
    jimport('joomla.filesystem.file');
    include_once(JPATH_SITE.'/components/com_dtregister/class.dtregister.php');

	include(JPATH_SITE."/components/com_dtregister/config.dtregister.php");
    
	$conf = &JFactory::getConfig();
  if($DT_mailfrom == ""){
     $DT_mailfrom = $conf->_registry['config']['data']->mailfrom;
  }
  if($DT_fromname==""){
     $DT_fromname =$conf->_registry['config']['data']->fromname;
  }
 // $mosConfig_mailfrom = $conf->_registry['config']['data']->mailfrom;

//  $mosConfig_fromname =$conf->_registry['config']['data']->fromname;
global $lang_var ;
		
	//Currency symbol

	$arrCode=array();

	$arrSymbol=array();

	$arrCode[]='USD';$arrSymbol[]='$';

  $arrCode[]='BRL';$arrSymbol[]='R$';

  $arrCode[]='ZAR';$arrSymbol[]='R';

	$arrCode[]='GBP';$arrSymbol[]='&#163;';

	$arrCode[]='EUR';$arrSymbol[]='&#128;';

	$arrCode[]='JPY';$arrSymbol[]='&#165;';

	$arrCode[]='CHF';$arrSymbol[]='&#8355;';

	$index=-1;

	for($i=0,$n=count($arrCode);$i<$n;$i++)

	{

		if($arrCode[$i]==$currency_code)

		{

			$index=$i;

			break;

		}

	}

	if($index!=-1){

		$currency_symbol=$arrSymbol[$index];

	} else {

		$currency_symbol='$';

	}

	$sql="Select * From #__dtregister_user u inner join #__dtregister_group dg on dg.useid= u.userId inner join #__dtregister_group_amount ga on ga.groupId = dg.groupId  where u.userId=$userId";

	$database->setQuery($sql);

	$rowUser = $database->loadObject();

    $address= stripslashes($rowUser->userAddress);
	
	$address2= stripslashes($rowUser->userAddress2);

	 $city = stripslashes($rowUser->userCity);

	 $zip = stripslashes($rowUser->userZip);

	 $state = stripslashes($rowUser->userState);

	 $email = stripslashes($rowUser->userEmail);

	 $country = stripslashes($rowUser->userCountry);

     $title= (stripslashes($rowUser->userTitle)=="")?'':stripslashes($rowUser->userTitle)." ";  
	  
	 $fname = stripslashes($rowUser->userFirstName);

	 $lname = stripslashes($rowUser->userLastName);

	 $phone = stripslashes($rowUser->userPhone);

	 $org = stripslashes($rowUser->userOrganization);

	 $type = $rowUser->payment_type;

	 $eventId = $rowUser->eventId;

     $evt = new Event($eventId);

    $evt->over_ride_global();

	 $amount  = $rowUser->amount;

	 $memtot  = $rowUser->numberOfPerson;

	 $userType = $rowUser->userType;

     $rowUser->amount_due = $amount - $rowUser->paid_amount;

	// for the custom email
   $address2_display = "";
   $comma = "";
   if($address2!=""){
      $address2_display = $address2."<br />";
	  $comma = ",";
	  
   }
   
	$contactDetails = $address.'<br />'.$address2_display.' '.$city.', '.$state.' '.$zip.'<br />'.$phone.'<br />'.$email;

	$msg = '';

	$msg .= '<table><link href="components/com_dtregister/main.css" rel="stylesheet" type="text/css">';

	$msg .= '<h3>'.JText::_( 'DT_REGISTRATION_DETAILS').':</h3>';

	$msg .= '<table class="message">';

	$msg .= "<tr><td colspan=2>$thanksmsg</td></tr>";

	$msg .= '<tr><td>'.JText::_( 'DT_NAME').': </td><td>'.$title.$fname.' '.$lname.'</td></tr>';

	$msg .= '<tr><td rowspan="2">'.JText::_( 'DT_ADDRESS').': </td><td>'.$address.'</td></tr>';
   
    if($address2 != ""){
	  $msg .= '<tr><td rowspan="2">'.JText::_( 'DT_ADDRESS2').': </td><td>'.$address2.'</td></tr>';
	}

	$msg .= '<tr><td>'.$city.' '.$state.' '.$zip.'</td><tr>';

	$msg .= '<tr><td>'.JText::_( 'DT_AMOUNT').': </td><td>'.$currency_symbol. numberFormat($amount,2).'</td></tr><tr><td><h3>'.JText::_( 'DT_THANKS_PAYPAL').'</h3></td></tr>';

	  $msg.'<tr><td><a href="'.$mosConfig_live_site.'">'.JText::_( 'RETURN_TO_SITE').'</a></td></tr></table>';

	//Get custom fields and store in CustomFields array

	$arrCustomFields=array();
$dt_user = new DT_User($userId,$eventId);
    $admin_attachments = array();
    $cfields = array();
   $fld = new Custom_field();
    $fields=array() ;
	$type = ($userType=='I')?'I':'B' ;
	$fld->getAllFields($eventId,$type,false,0,$fields) ;
			
			$rows1 = $fields ;
  
	for($i=0,$n=count($rows1);$i<$n;$i++){

          if($rows1[$i]->type==7){
		   if($rows1[$i]->upload){
		      $name = $rows1[$i]->name ;
		      $admin_attachments[] = addslashes(JPATH_SITE . DS . "images" . DS ."dtregister".DS."uploads".DS.$rowUser->$name);
		   }
		}

		$tmparray = array($rows1[$i]->name => $rows1[$i]->label);

         $cfields[$rows1[$i]->name] = $rows1[$i];

		array_push_associative($arrCustomFields,$tmparray);

	}
 
      $admin_attachments = array_filter($admin_attachments);
  
	// send out emails to the registant and the admin

     $sql="Select summary ,  evdet_id From #__jevents_vevdetail Where evdet_id=$eventId";

	$database->setQuery($sql);

	$eventName=$database->loadResult();

	$sql="Select dtstart From #__jevents_vevdetail Where evdet_id=$eventId";

	$database->setQuery($sql);

	$eventBegin=$database->loadResult();

		// $subthanksemail = sprintf($subthanksemail,$eventName);

		$subthanksemail = str_replace('[EVENT_NAME]',$eventName,$subthanksemail);

		$amountCharged = $amount ;

		$thanksemail = sprintf($thanksemail,$eventName,$amountCharged);

    $subadmin = JText::_('DT_ADMIN_SUBJECT');

	$sql="SELECT summary,dtstart,dtend FROM #__jevents_vevdetail WHERE evdet_id=$eventId";

	  $database->setQuery($sql);

		$row = $database->loadObject();

		$adminmsg="";

			$adminmsg.= $title.$fname . ' ' . $lname . ' ' . JText::_('DT_ADMIN_MESSAGE') . ' ' . $eventName . ' (' . get_date($eventBegin,$row->dtend,null,true) . ').<br><br>';

		$adminmsg.= JText::_('DT_ADMIN_MSG_DETAILS') . ":<br><br>";

		$eventName=$row->summary;

		$startDate=$row->dtstart;

		$endDate=$row->dtend;

		$start_date =JFactory::getDate($row->dtstart)->toFormat('%b %d, %Y');

		$end_date  = JFactory::getDate($row->dtend)->toFormat('%b %d, %Y');

		$event_date = get_date($row->dtstart,$row->dtend,null,true);

		if($start_date != $end_date ){

			$event_date .= " - ".get_date($row->dtend,null,true);

		}

		$adminmsg.="<table>";

		$adminmsg.="<tr><td>".JText::_('DT_EVENT_NAME').": </td><td>".$eventName."</td></tr>";

		$adminmsg.="<tr><td>".JText::_('DT_EVENT_DATE').": </td><td>".$event_date."</td></tr>";

		$adminmsg.="<tr><td>".JText::_('DT_ADMIN_REGISTRANT_NAME').": </td><td>$title $fname $lname</td></tr>";
		
		if($org != NULL){$adminmsg.="<tr><td>".JText::_('DT_ORGANIZATION').": </td><td> $org</td></tr>";}

        $address2_display = "";
	   $comma = "";
	   if($address2!=""){
		  $address2_display = $address2."<br />";
		  $comma = ",";
		  
	   }
   
		if(($address) != NULL){$adminmsg.="<tr><td>".JText::_('DT_ADDRESS').": </td><td> $address </td></tr>";}
		
		if(($address2) != NULL){$adminmsg.="<tr><td>".JText::_('DT_ADDRESS2').": </td><td> $address2</td></tr>";}

		if($city != NULL){

			if($state != NULL){

				$adminmsg.="<tr><td>".JText::_('DT_CITY_STATE').": </td><td> $city ($state, $country)</td></tr>";

			} else {

				$adminmsg.="<tr><td>".JText::_('DT_CITY')." (".JText::_('DT_COUNTRY')."): </td><td> $city ( $country)</td></tr>";

			}

		}

		if($zip != NULL){$adminmsg.="<tr><td>".JText::_('DT_ZIPCODE').": </td><td> $zip</td></tr>";}

		if($phone != NULL){$adminmsg.="<tr><td>".JText::_('DT_PHONE').": </td><td> $phone</td></tr>";}

		$adminmsg.="<tr><td>".JText::_('DT_EMAIL').": </td><td> $email</td></tr>";
       if((int)$dt_user->user_id >0){
	       $adminmsg .= '<tr><td>'.JText::_( 'DT_USERNAME' ).':</td><td>'.stripslashes($dt_user->username).'</td></tr>';
	   
       }
		$contactCustomFields = '';

		if ($arrCustomFields){

			foreach ($arrCustomFields as $key => $value){

				if($rowUser->$key==""){

					continue;

				}
				
				if($cfields[$key]->type == 7){
				   
				   $rowUser->$key =  JFile::getName($rowUser->$key);
				}

				$adminmsg .= "<tr><td>".$value.':</td><td>'.$rowUser->$key.'</td></tr>';

				$contactCustomFields .= $value.': '.$rowUser->$key.'<br />';

			}

		}

		 $adminmsg.="<tr><td>".JText::_('DT_REGISTRATION_FEE').": </td><td>".numberFormat($amount,2)."</td></tr>";

         $adminmsg.="<tr><td>".JText::_('DT_AMOUNT_PAID').": </td><td>".numberFormat($rowUser->paid_amount,2)."</td></tr>";
         
		 $adminmsg.="<tr><td>".JText::_('DT_PAYMENT_TYPE').": </td><td>".$lang_var[$rowUser->payment_type]."</td></tr>";
		 
		 if($rowUser->transaction_id != ""){
		     
			 $adminmsg.="<tr><td>".JText::_('DT_TRANSACTION_ID').": </td><td>".$rowUser->transaction_id."</td></tr>";
			 
		 }

		 $adminmsg.="<tr><td>".JText::_('DT_CONFIRMATION_NUMBER').": </td><td>".$rowUser->confirmNum."</td></tr>";

        if($rowUser->discount_code_id != 0 && $rowUser->discount_code_id !=''){

			$dt_code = new DiscountCode($rowUser->discount_code_id);

			$adminmsg.="<tr><td>".JText::_('DT_DISCOUNT_CODE').": </td><td>".$dt_code->code."</td></tr>";

	    }

		if ($userType == 'G'){
             $fields=array() ;
	
	        $fld->getAllFields($eventId,'M',false,0,$fields) ;
			$arrCustomFields =  array();
			foreach($fields as $field){
			   $arrCustomFields[$field->name] = $field->label ;
			}
			$adminmsg.="<tr><td colspan=2>".JText::_('DT_ADMIN_GROUP_DETAILS').": </td></tr>";

			// get the details of the group users

			$sql2 = "SELECT m.* FROM #__dtregister_group_member m, #__dtregister_group g

					WHERE g.useid={$userId} AND g.groupId=m.groupUserId";

			//$adminmsg.=$sql2;

			$database->setQuery($sql2);

			$rowUser2=$database->loadObjectList();

			//$memtot = count($rowUser);

			$adminmsg.="<tr><td>".JText::_('DT_NUMBER_MEMBERS').":</td><td>".count($rowUser2)."</td></tr>";

			$groupCustomFields = '';

			for ($i=0,$n=count($rowUser2);$i<$n;$i++){

				$row=$rowUser2[$i];

				$adminmsg.="<tr><td colspan=2><br><br>".JText::_('DT_MEMBER') .($i+1)."</td></tr>";

				if ($row->lastname){

                   if($row->title !=""){
				    $mtitle = $row->title." ";
				 }

				$adminmsg.="<tr><td>".JText::_('DT_NAME').": </td><td>".$mtitle.$row->firstname . ' ' .$row->lastname."</td></tr>";
                    
				$memberNames .= ' ' . stripslashes($mtitle.$row->firstname);

				$memberNames .= ' ' . stripslashes($row->lastname)."<br>";

				}

				if ($row->organization){$adminmsg.="<tr><td>".JText::_('DT_ORGANIZATION').": </td><td>". $row->organization."</td></tr>";}

					if (($row->address.$row->address2)!=""){$adminmsg.="<tr><td>".JText::_('DT_ADDRESS').": </td><td>".$row->address."  ".$row->address2."</td></tr>";}

				if ($row->city || $row->state || $row->country){

					$adminmsg.="<tr><td>";

						if ($row->city){$adminmsg.=JText::_('DT_CITY');}

						if ($row->state || $row->country){$adminmsg.=' ('.JText::_('DT_STATE');}

						if ($row->state && $row->country){$adminmsg.=', ';}

						if ($row->country){$adminmsg.=JText::_('DT_COUNTRY');}

						if ($row->state || $row->country){$adminmsg.=')';}

						$adminmsg.=": </td><td>";

						if ($row->city){$adminmsg.=$row->city;}

						if ($row->state || $row->country){$adminmsg.=' ('.$row->state;}

						if ($row->state && $row->country){$adminmsg.=', ';}

						if ($row->country){$adminmsg.=$row->country;}

						if ($row->state || $row->country){$adminmsg.=')';}

						$adminmsg.="</td></tr>";

				}

				if ($row->zip){$adminmsg.="<tr><td>".JText::_('DT_ZIPCODE').": </td><td>".$row->zip."</td></tr>";}

				if ($row->phone){$adminmsg.="<tr><td>".JText::_('DT_PHONE').": </td><td>".$row->phone."</td></tr>";}

				if ($row->email){$adminmsg.="<tr><td>".JText::_('DT_EMAIL').": </td><td>".$row->email."</td></tr>";}
                 $groupCustomFields .= JText::_('DT_MEMBER') .($i+1).': '.$mtitle.$row->firstname . ' ' .$row->lastname.'<br />';
				if ($arrCustomFields){

					foreach ($arrCustomFields as $key => $value){

						if($row->$key ==""){

							continue;

						}
                        if($cfields[$key]->type==7){
				   if($cfields[$key]->upload){
				      $admin_attachments[] =  addslashes(JPATH_SITE . DS . "images" . DS ."dtregister".DS."uploads".DS.$row->$key);

				   }
				}
				
						if ($row->$key){

                              if($cfields[$key]->type == 7){
				   
							   $rowUser->$key =  JFile::getName($rowUser->$key);
							}

							$adminmsg .= "<tr><td>".$value.':</td><td>'.$row->$key.'</td></tr>';

							 $groupCustomFields .= $value.': '.$row->$key.'<br />';

						}

					}
					
					$groupCustomFields .= "<br /><br />";

				}

			}

		}else{
			$memberNames = "$title $fname $lname <br>";		
	    }


        if(isset($rowUser->billing_name) && $rowUser->billing_name!=""){

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_NAME').": </td><td>".$rowUser->billing_name."</td></tr>";

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_ADDRESS').": </td><td>".$rowUser->billing_address."</td></tr>";

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_CITY').": </td><td>".$rowUser->billing_city."</td></tr>";

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_STATE').": </td><td>".$rowUser->billing_state."</td></tr>";

			$adminmsg.="<tr><td>".JText::_('DT_BILLING_ZIPCODE').": </td><td>".$rowUser->billing_zipcode."</td></tr>";

		}
global $barCodeImagetypeToExt , $barcode_image_type ;
  $barcodePath =JURI::root( false )."images/dtregister/barcode/".$rowUser->confirmNum.".".$barCodeImagetypeToExt[$barcode_image_type];
    $barcodeImg = "";
  if($barcode_enable){
     $barcodeImg = '<img border="0" src="'.$barcodePath.'" />';
  }
  
 if($barcode_enable){
     $adminmsg.="<tr><td>".JText::_('DT_BARCODE').": </td><td>".$barcodeImg."</td></tr>";
  }
		$adminmsg.="</table></pre>";

	//Get the admin email now and the thank you message

	$sql = "SELECT a.summary title,a.dtstart publish_up, a.dtend publish_down,b.email,b.thksmsg,b.thksmsg_set FROM #__jevents_vevdetail a,#__dtregister_group_event b WHERE a.evdet_id=b.eventId  AND  a.evdet_id=$eventId";

	$database->setQuery($sql);

	$rowAdminEmail = $database->loadObject();

    $sql1 = "SELECT config_value , id FROM #__dtregister_config WHERE config_key='thanksemail'";

    $database->setQuery($sql1);

  	$defaultthksmsg = $database->loadResult();

    if($rowAdminEmail->email){

		$adminemail=$rowAdminEmail->email;

		$thksmsg=stripslashes($rowAdminEmail->thksmsg);

		$thksmsg_set=$rowAdminEmail->thksmsg_set;

		$eventBegin=$rowAdminEmail->publish_up;

		$eventEnd=$rowAdminEmail->publish_down;

		$eventTitle=$rowAdminEmail->title;

	} else {

		//$adminemail=$mosConfig_mailfrom;

		$adminemail="";

	}
	
	  $status =  array(JText::_('DT_ACTIVE'),JText::_('DT_CANCELLED'),JText::_('DT_PENDING'));
		 
	  $paid_status = array(JText::_('DT_NOT_PAID'),JText::_('DT_PAID'));
       
	// If custom email message is selected... use it!
    $evt =  new Event($eventId);
		
		$location = $evt->get_location();
       
		$constants = array('[TITLE]','[FIRSTNAME]','[NAME]','[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[AMOUNT_DUE]','[AMOUNT_PAID]','[STATUS]','[PAID_STATUS]','[BARCODE]');

		if ($type=='pay_later'){$type='Pay Later';}

		$replace = array($title, $fname , $fname.' '.$lname, $org, $eventName, get_date($eventBegin,$eventEnd), $dt_user->get_contact_details(), isset($memberNames)?$memberNames:'', $memtot, numberFormat($amount,2), $lang_var[$rowUser->payment_type], $contactCustomFields, isset($groupCustomFields)?$groupCustomFields:'',$rowUser->confirmNum,$location===false?'':$location->name,numberFormat($rowUser->amount_due,2),numberFormat($rowUser->paid_amount,2),$status[$rowUser->cancel],$paid_status[$rowUser->pay_later_paid],$barcodeImg);

    if ($thksmsg_set == 1){

		$thanksemail = str_replace($constants, $replace, $thksmsg);
		
    $constants = array('[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[AMOUNT_DUE]','[AMOUNT_PAID]','[STATUS]','[PAID_STATUS]');
		
		$replace = array($org, $eventName, get_date($eventBegin,$eventEnd), $dt_user->get_contact_details(), isset($memberNames)?$memberNames:'', $memtot, numberFormat($amount,2), $lang_var[$rowUser->payment_type], $contactCustomFields, isset($groupCustomFields)?$groupCustomFields:'',$rowUser->confirmNum,$location===false?'':$location->name,numberFormat($rowUser->amount_due,2),numberFormat($rowUser->paid_amount,2),$status[$rowUser->cancel],$paid_status[$rowUser->pay_later_paid]);
		
     $thanks_msg_member = str_replace($constants, $replace, $thksmsg); 

		$subthanksemail = str_replace('[EVENT_NAME]',$eventName,$subthanksemail);
		
		$subthanksemail = str_replace('[STATUS]',$status[$rowUser->cancel],$subthanksemail);
		
		$subthanksemail = str_replace('[PAID_STATUS]',$paid_status[$rowUser->pay_later_paid],$subthanksemail);

		$subthanksemail = str_replace('[EVENT_DATE]',JHTML::_('date', $eventBegin),$subthanksemail);

	} else {

    $thanksemail = str_replace($constants, $replace, $defaultthksmsg);

    $constants = array('[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[AMOUNT_DUE]','[STATUS]','[PAID_STATUS]','[AMOUNT_PAID]');
		
		$replace = array($org, $eventName, get_date($eventBegin,$eventEnd), $dt_user->get_contact_details(), isset($memberNames)?$memberNames:'', $memtot, numberFormat($amount,2), $lang_var[$rowUser->payment_type], $contactCustomFields, isset($groupCustomFields)?$groupCustomFields:'',$rowUser->confirmNum,$location===false?'':$location->name,$rowUser->amount_due,$status[$rowUser->cancel],$paid_status[$rowUser->pay_later_paid],numberFormat($rowUser->paid_amount,2));
		
    $thanks_msg_member = str_replace($constants, $replace, $defaultthksmsg);

		$subthanksemail = str_replace('[EVENT_NAME]',$eventName,$subthanksemail);

		$subthanksemail = str_replace('[EVENT_DATE]',JHTML::_('date', $eventBegin),$subthanksemail);
		
		$subthanksemail = str_replace('[STATUS]',$status[$rowUser->cancel],$subthanksemail);
		
		$subthanksemail = str_replace('[PAID_STATUS]',$paid_status[$rowUser->pay_later_paid],$subthanksemail);

	}

    $sql = "SELECT config_value FROM #__dtregister_config WHERE config_key='subthanksemail'";

    $database->setQuery($sql);

	  $subthanksemail = $database->loadResult();

    $user_thanksemail	= stripslashes($thanksemail);

    $subthanksemail = str_replace('[EVENT_DATE]',get_date($eventBegin,$eventEnd),$subthanksemail);

	  $subthanksemail = str_replace('[EVENT_NAME]',$eventTitle,$subthanksemail);

		$adminmsg	= stripslashes($adminmsg);

		$subadmin	= stripslashes($subadmin);

		$subthanksemail = stripslashes($subthanksemail);

		$pos = strrpos($adminemail, ";");

		if ($pos === false) { 

			$adminemails = array($adminemail);

		}else{

			$adminemails = explode(";",$adminemail);

		}
       
		

    $evt =  new Event($eventId);

    $data = $evt->get_files();

  	$attachments = null ;

	  foreach($data as $file){

		  $attachments[] = $file->path;

	  }

	$mail =& JFactory::getMailer();

      $user_thanksemail =  parse_tags_new($user_thanksemail,$dt_user); 
  
    JUTility::sendMail( $DT_mailfrom, $DT_fromname,$email,$subthanksemail,$user_thanksemail,1,null,null,$attachments);
	
   if($sendEmailToGroup && isset($rowUser2) && is_array($rowUser2) && count($rowUser2) >0 ){
       
	   foreach($rowUser2 as $member){
		     $member->barCodeHtml = $dt_user->barCodeHtml ;
	     $title = "" ;
		   $firstname = "";
		   $lastname  = "";
		   $title = ($member->title != "")?$member->title." ":'';
		   $firstname = ($member->firstname != "")?$member->firstname." ":'';
		   $lastname = ($member->lastname != "")?$member->lastname:'';
	     if($member->email !=""){
		     $member_thanksemail = str_replace('[TITLE]',$title,$thanks_msg_member);
		     $member_thanksemail = str_replace('[NAME]',$firstname.$lastname,$member_thanksemail);
			 $member_thanksemail = str_replace('[FIRSTNAME]',$firstname,$member_thanksemail);
			 $member_thanksemail =  parse_tags_new(($member_thanksemail),$member); 
		     JUTility::sendMail( $DT_mailfrom, $DT_fromname,$member->email,$subthanksemail,$member_thanksemail,1,null,null,$attachments);
		   }
	   }
	     
   }
 
}

function parse_tags($msg,$user_id,$eventId){
global $lang_var ;
	 
		$paylater_values = array(1=>'At_door',2=>'Mail',3=>'Phone');

	  $dt_user = new DT_User($user_id,$eventId);

		if($dt_user->payment_type="pay_later"){

			$dt_user->payment_type = $paylater_values[$dt_user->pay_later_option];

		}

		$constants = array('[FIRSTNAME]','[NAME]','[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[PREREQ_EVENTS]','[BARCODE]');

		//if ($type=='pay_later'){$type='Pay Later';}

    $user_details = $dt_user->get_details();

	  if($user_details->numberOfPerson==1){

	   		$memtot = "";

	  }else{

	   		$memtot = $user_details->numberOfPerson;

	  }

	   $event_details = $dt_user->event->get_jev_detail();
       
	   $prerequisite =  $dt_user->event->get_prerequisite();
	   $selection = array();
	   foreach($prerequisite as $select){
			$pre_evt = new Event($select->prerequisite_id);
			$selection[] = $pre_evt->summary ;
				    
		}
    $location = $dt_user->event->get_location();
	global $barCodeImagetypeToExt , $barcode_image_type ;
  $barcodePath =JURI::root( false )."images/dtregister/barcode/".$dt_user->confirmNum.".".$barCodeImagetypeToExt[$barcode_image_type];
  $barcodeImg = "";
  if($barcode_enable){
     $barcodeImg = '<img border="0" src="'.$barcodePath.'" />';
  }
  
		$replace = array($dt_user->userFirstName,$dt_user->get_name(), $dt_user->userOrganization, $event_details->summary, get_date($event_details->dtstart,$event_details->dtend), $dt_user->get_contact_details(), $dt_user->get_group_names(), $memtot, numberFormat($user_details->amount,2), $lang_var[$dt_user->payment_type], $dt_user->get_contact_custom_fields(), $dt_user->get_group_custom_fileds(),$dt_user->confirmNum,$location===false?'':$location->name,implode(",",$selection),$barcodeImg);


		return $thanksemail = str_replace($constants, $replace, $msg);

}

function count_members(){

$cnt = 0;

if(count($_SESSION['billinginfo']['register']['members'])<=0){
   return 1;
}

foreach($_SESSION['billinginfo']['register']['members'] as $key => $member){
  
  if(isset($member->remove) && $member->remove == 1){

  }else{
    
    $cnt++ ;
	
  }
  
}
return $cnt ;
}

function bird_discount_calc($type,$discount,$amount){

   if($type == 2 || $type == 3){

     $per = (100-$discount)/100;

	   $amount= $amount*$per ;

    }elseif($type != 0){

	   $amount = $amount - $discount ;   

	}

	return $amount ;

}

function amount_percentage($type, $amount,$percentage){
   
   
   if($type == 2){

	   $amount= $amount*($percentage)/100 ;

    }

	return $amount ;

}

function tmpl_event_name($dateshow=false,$name,$date){

  if($dateshow){

     $title = $name ." (".$date.")";

  }else{

     $title = $name ;

  }

  return $title ;

}

function amountToDot($amount=''){

  $amount  = str_replace(",",".",$amount);

  return $amount ;

}

function cancel_fee($amount=0){
   global $cancelfee_type ;
   include (JPATH_SITE.'/components/com_dtregister/config.dtregister.php');
   if($amount == 0){
     //return 0;
   }
  if($cancelfee_enable){
     
	 if($cancelfee_type==1){
	   return $cancelfee ;
	 }else if($cancelfee_type==2){
	    return ($amount*$cancelfee)/100 ;
	 }else{
	   return 0;
	 }
	 
   }else{
     return 0 ;
   }
   
}
if(!function_exists('numberFormat')){

function numberFormat($value,$precision=2)

{

    $number_value = $value ;

   include(JPATH_SITE."/components/com_dtregister/config.dtregister.php");

	$padString = "";

  $value = $number_value;

	$formatedValue=number_format($value,$precision,".","");

	$pointIndex=strrpos($formatedValue,".");

	if($pointIndex===false)

	{

    if($currency_separator == 1){

		  $formatedValue = str_replace(".",",",$formatedValue);

		}

		return $formatedValue;

	}

	else

	{

		//Cut the string and show it here

		$pointIndex=strrpos($formatedValue,".");

		if($pointIndex==false)

		{

			if($currency_separator == 1){

			  $formatedValue = str_replace(".",",",$formatedValue);

			}

			return $formatedValue;

		}

		else

		{

			$newLength=$pointIndex+1+$precision;

			for($i=strlen($formatedValue);$i<$newLength;$i++)

			{

				$padString.="0";

			}

        if($currency_separator == 1){

		     $formatedValue = str_replace(".",",",$formatedValue.$padString);

		    }else{

			  $formatedValue = $formatedValue.$padString ;

			}

			return $formatedValue;

		}

	}

}

}

function thanks_email_tags($dt_user,$message){
   
   $status =  array(JText::_('DT_ACTIVE'),JText::_('DT_CANCELLED'),JText::_('DT_PENDING'));
   $paid_status = array(JText::_('DT_NOT_PAID'),JText::_('DT_PAID'));
   $dt_user->amount_due = $dt_user->get_amount() - $dt_user->paid_amount;
   $address2_display = "";
   $comma = "";
   if($dt_user->userAddress2!=""){
    $address2_display = $dt_user->userAddress2."<br />";
	  $comma = ",";
	  
   }
   $contactDetails = $dt_user->userAddress.'<br />'.$address2_display.' '.$dt_user->userCity.', '.$dt_user->userState.' '.$dt_user->userZip.'<br />'.$dt_user->userPhone.'<br />'.$dt_user->userEmail;
   global $lang_var ;
	
   $constants = array('[TITLE]','[FIRSTNAME]','[NAME]','[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[AMOUNT_DUE]','[AMOUNT_PAID]','[STATUS]','[PAID_STATUS]');
   
   $members = $dt_user->get_members();
   $memberNames = "" ;
   $groupCustomFields = "" ;

   $grp_custom_fields = $dt_user->event->get_group_custom_field();
   $i = 0 ;
   foreach($members as $member){
      $mtitle = "" ;
      if($member->title !=""){
		  $mtitle = $row->title." ";
	   }
      $memberNames .= ' ' . stripslashes($mtitle.$member->firstname);
	  if($member->lastname!=""){
	      $memberNames .= " ".$member->lastname ;
	  }
      $memberNames .="<br />";

	   $groupCustomFields .= JText::_('DT_MEMBER') .($i+1).': '.$mtitle.$member->firstname . ' ' .$member->lastname.'<br />';

	   foreach($grp_custom_fields as $field){
	       if($member->{$field->name}==""){
			  continue;
		   }
           $groupCustomFields .= $field->label.': '.$member->{$field->name}.'<br />';
	   }

   }
   $memtot = count($members);
   $custom_field_method = "get_individual_custom_field";
   if($dt_user->userType == 'G'){
     $custom_field_method = "get_billing_custom_field";
   }else{
	  $memtot  =  1 ;   
   }
   $custom_fields = $dt_user->event->{$custom_field_method}();
   $contactCustomFields = "" ;
   foreach($custom_fields as $field){
      
	  if($dt_user->{$field->name}==""){
	     continue;
	  }
	  $contactCustomFields .= $field->label.': '.$dt_user->{$field->name}.'<br />';
	  
   }
   $location = $dt_user->event->get_location();
   $replace = array($dt_user->userTitle,
                  $dt_user->userFirstName,
	                $dt_user->userFirstName.' '.$dt_user->userLastName,
	                $dt_user->userOrganization , 
	                $dt_user->event->summary,
	                get_date($dt_user->event->dtstart,$dt_user->event->dtend), 
	                $dt_user->get_contact_details(), 
	                $dt_user->get_group_names(), 
	                $memtot, 
	                numberFormat($dt_user->get_amount(),2), 
                  $lang_var[$dt_user->payment_type], 
	                $contactCustomFields,
	                isset($groupCustomFields)?$groupCustomFields:'',
	                $dt_user->confirmNum,
	                $location===false?'':$location->name,
	                numberFormat(isset($dt_user->amount_due)?$dt_user->amount_due:'',2),
	                numberFormat($dt_user->paid_amount,2),
					$status[$dt_user->cancel],
					$paid_status[$dt_user->pay_later_paid]
	       );
   $message = str_replace($constants, $replace, $message);
   $message = parse_tags_new(($message),$dt_user);

   return $message ;

}

function thanks_email_members_tags($member,$message){
   
    $status =  array(JText::_('DT_ACTIVE'),JText::_('DT_CANCELLED'),JText::_('DT_PENDING'));
    $paid_status = array(JText::_('DT_NOT_PAID'),JText::_('DT_PAID'));
   global $lang_var ;
	
   $address2_display = "";
   $comma = "";
   if($member->address2!=""){
      $address2_display = $member->address2."<br />";
	  $comma = ",";
	  
   }
    $contactDetails = $member->address.'<br />'.$address2_display.' '.$member->city.', '.$member->state.' '.$member->zip.'<br />'.$member->phone.'<br />'.$member->email;
 
   $constants = array('[TITLE]','[FIRSTNAME]','[NAME]','[ORGANIZATION]','[EVENT_NAME]','[EVENT_DATE]','[CONTACT_DETAILS]','[GROUP_NAMES]','[GROUP_NUMBER]','[AMOUNT]','[PAYMENT_TYPE]','[CONTACT_CUSTOM_FIELDS]','[GROUP_CUSTOM_FIELDS]','[CONFIRM_NUM]','[LOCATION]','[AMOUNT_DUE]','[AMOUNT_PAID]','[STATUS]','[PAID_STATUS]');
   
   $dt_user =  new DT_User($member->groupUserId);
   $dt_user->event = new Event($dt_user->eventId);
   $members = $dt_user->get_members();
   $dt_user->amount_due = $dt_user->get_amount() - $dt_user->paid_amount;
   $memberNames = "" ;
   $groupCustomFields = "" ;

   $grp_custom_fields = $dt_user->event->get_group_custom_field();
   $i = 0 ;
   foreach($members as $member){
        $mtitle = "" ;
       if($member->title !=""){
		  $mtitle = $row->title." ";
	   }
      $memberNames .= ' ' . stripslashes($mtitle.$member->firstname);
	  if($member->lastname!=""){
	      $memberNames .= " ".$member->lastname ;
	  }
     $memberNames .="<br />";

	   $groupCustomFields .= JText::_('DT_MEMBER') .($i+1).': '.$mtitle.$member->firstname . ' ' .$member->lastname.'<br />';

	   foreach($grp_custom_fields as $field){
	       if($member->{$field->name}==""){
			  continue;
		   }
           $groupCustomFields .= $field->label.': '.$member->{$field->name}.'<br />';
	   }

   }
   $memtot = count($members);
   $custom_field_method = "get_individual_custom_field";
   if($dt_user->userType == 'G'){
     $custom_field_method = "get_billing_custom_field";
   }
   $custom_fields = $dt_user->event->{$custom_field_method}();
   $contactCustomFields = "" ;
   foreach($custom_fields as $field){
      
	  if($dt_user->{$field->name}==""){
	     continue;
	  }
	  $contactCustomFields .= $field->label.': '.$dt_user->{$field->name}.'<br />';
	  
   }
   $location = $dt_user->event->get_location();
   $replace = array($member->title,
                  $member->firstname ,
	                $member->firstname.' '.$member->lastname,
	                $member->organization , 
	                $dt_user->event->summary,
	                get_date($dt_user->event->dtstart,$dt_user->event->dtend), 
	                $dt_user->get_contact_details(), 
	                $dt_user->get_group_names(), 
	                $memtot, 
	                numberFormat($dt_user->get_amount(),2), 
                  $lang_var[$dt_user->payment_type], 
	                $contactCustomFields,
	                isset($groupCustomFields)?$groupCustomFields:'',
	                $dt_user->confirmNum,
	                $location===false?'':$location->name,
	                numberFormat(isset($dt_user->amount_due)?$dt_user->amount_due:'',2),
	                numberFormat($dt_user->paid_amount,2),
					$status[$dt_user->cancel],
					$paid_status[$dt_user->pay_later_paid]
	       );
   $message = str_replace($constants, $replace, $message);
   $message =  parse_tags_new(($message),$dt_user);

   return $message ;

}

?>