<?php

/**
* @version 2.6.3
* @package Joomla 1.5
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/*-------------------------

Author: Jonathan Pulice

Date: July 26th, 2005

Name: JPEncodeClass v1

Desc: Encoder and decoder using patterns.

-------------------------*/

class Protector

{

	var $Pattern = "";

	var $PatternFlip = "";

	var $ToEncode = "";

	var $ToDecode = "";

	var $Decoded = "";

	var $Encoded = "";

	var $Bug = false;

	var $DecodePattern = "";

	function Debug($on = true)

	{

		$this->Bug = $on;

	}

	function Encode()

	{

    	$ar = explode(":", $this->Pattern);

		$enc = $this->ToEncode;

        if ($this->Bug) echo "<!-- BEGIN ENCODING -->\n";

    	foreach ($ar as $num => $ltr)

    	{   

			switch ($ltr)

    		{

				case "E":

    		    	$enc = base64_encode($enc);

    		    	break;

    		    case "D":

    		    	$enc = base64_decode($enc);

    		    	break;

    		    case "R":

    		    	$enc = strrev($enc);

    		    	break;

    		    case "I":

    		    	$enc = $this->InvertCase($enc);

    		    	break;

    		}

    		if ($this->Bug) echo "<!--     {$ltr}: {$enc}  -->\n";

    	}

        if ($this->Bug) echo "<!-------------------->\n\n";

		$this->Encoded = ($enc == $this->Str) ? "-1" : $enc;

		return $this->Encoded;

	}

	function Decode()

	{

		$pattern = ($this->DecodePattern != "") ? $this->DecodePattern : $this->Pattern;

		//Reverse the pattern

		$this->PatternFlip($pattern);

		//make into an array

		$ar = explode(":", $this->PatternFlip);

		$t = ($this->Encoded == "") ? $this->ToDecode : $this->Encoded;

		if ($this->Bug) echo "<!-- BEGIN DECODING -->\n";

        foreach ($ar as $num => $ltr)

    	{

			switch ($ltr)

    		{

				case "E":

    		    	$t = base64_encode($t);

    		    	break;

    		    case "D":

    		    	$t = base64_decode($t);

    		    	break;

    		    case "R":

    		    	$t = strrev($t);

    		    	break;

    		    case "I":

    		    	$t = $this->InvertCase($t);

    		    	break;

    		}

    		if ($this->Bug) echo "<!--     {$ltr}: {$t}  -->\n";

    	}

        if ($this->Bug) echo "<!-------------------->\n\n";

    	$this->Decoded = ($t == $this->Encoded) ? "-1" : $t;

    	return $this->Decoded;

	}

	function MakePattern($len = 10)

	{

		//possible letters

		// E - Base64 Encode

		// R - Reverse String

		// I - Inverse Case

		$poss = array('E','R', 'I');

		//generate a string

		for ( $i = 0 ; $i < $len ; $i++ )

		{

			$tmp[] = $poss[ rand(0,2) ];

		}

		//echo $str. "<br>";

		//fix useless pattern section  RR  II

		$str = implode(":", $tmp);

		//fix

		$str = str_replace( 'R:R:R:R:R:R' , 'R:E:R:E:R:E' , $str );

		$str = str_replace( 'R:R:R:R:R' , 'R:E:R:E:R' , $str );

		$str = str_replace( 'R:R:R:R' , 'R:E:R:E' , $str );

		$str = str_replace( 'R:R:R' , 'R:E:R' , $str );

		$str = str_replace( 'R:R' , 'R:E' , $str );

		//fix

		$str = str_replace( 'I:I:I:I:I:I' , 'I:E:I:E:I:E' , $str );

		$str = str_replace( 'I:I:I:I:I' , 'I:E:I:E:I' , $str );

		$str = str_replace( 'I:I:I:I' , 'I:E:I:E' , $str );

		$str = str_replace( 'I:I:I' , 'I:E:I' , $str );

		$str = str_replace( 'I:I' , 'I:E' , $str );

		//string is good, set as pattern

		$this->Pattern = $str;

		return $this->Pattern; //if we need it

	}

	function PatternFlip($pattern)

	{

        //reverse the pattern

    	$str = strrev($pattern);

    	$ar = explode(":", $str);

    	foreach ($ar as $num => $ltr)

    	{   

			switch ($ltr)

    		{

				case "E":

    		    	$tmp[] = "D";

    		    	break;

    		    case "D":

    		    	$tmp[] = "E";

    		    	break;

    		    case "R":

    		    	$tmp[] = "R";

    		    	break;

    		    case "I":

    		    	$tmp[] = "I";

    		    	break;

    		}

    	}

		$rev = implode(":", $tmp);

		$this->PatternFlip = $rev;

		return $this->PatternFlip;

	}

	// This is my custom Case Invertor!

	//   if you would like to use this in a script, please credit it to me, thank you

	function InvertCase($str)

	{

		//Do initial conversion

		$new = strtoupper( $str );

    	//spluit into arrays

		$s = str_split( $str );

 		$n = str_split( $new );

		//now we step through each letter, and if its the same as before, we swap it out

		for ($i = 0; $i < count($s); $i++)

		{

			if ( $s[$i] === $n[$i] ) //SWAP THE LETTER

			{

				//ge the letter

				$num = ord( $n[$i] );

				//see if the ord is in the alpha ranges ( 65 - 90 | 97 - 122 )

                if ( ( $num >= 65 AND $num <= 90 ) OR ( $num >= 97 AND $num <= 122 ) )

                {

    				if ($num < 97 ) { $num = $num + 32; }

    				else { $num = $num - 32; }

    				$newchr = chr($num);

    				$n[$i] = $newchr;

  				}

			}

		}

		//join the new string back together

		$newstr = implode("", $n);

		return $newstr;

	}

}

?>
