<?php

/**
* @version 2.7.26
* @package Joomla 1.5
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

class DtregisterModelPayoption extends DtrModel {

   function __construct($config = array()){

       parent::__construct($config);

	   $this->table =  new TablePayoption($this->getDBO());

  }

}

class TablePayoption extends DtrTable {

   var $id;

   var $name;

   var $default = 0;

    function __construct( &$db = null ) {

	  $db = &JFactory::getDBO();

	  $this->db = $db;

	  parent::__construct( '#__dtregister_payment', 'id', $db );

      $this->TablePayoptionconfig =& DtrTable::getInstance('Payoptionconfig','Table');

	  $this->TablePaylater  =& DtrTable::getInstance('paylater','Table');

   }	

   function save($data){

	  parent::save($data['payment']);

	  $this->TablePayoptionconfig->payment_id = $this->id;

	  $this->getPaylaterIds($data);

	  $this->TablePayoptionconfig->removeByPaymentid();

	  $this->TablePayoptionconfig->saveAll($data['config']);

   }

   function getPaylaterIds(&$data){

	   $this->TablePaylater->truncate();

	   $paylaters = array();
		
	   if (is_array($data['paylater'])) 
	   foreach($data['paylater'] as $key=>$name){

		 if($data['paylaterIds'][$key] != 'new'){

		    $paylater = array('name'=>$name,'id'=>$data['paylaterIds'][$key]);

		 }else{

		    $paylater = array('name'=>$name);

		 }

		 $this->TablePaylater->save($paylater);

		 if($data['paylaterIds'][$key] == 'new'){

			 $data['paylaterIds'][$key] = $this->TablePaylater->_db->insertid();

			 if(isset($data['config']['pay_later_options'][$key]))

			   $data['config']['pay_later_options'][$key] = $this->TablePaylater->_db->insertid();

		 }

	   }

   }
   
   function loaddefault() {
		
		$this->name = "";
		$this->id = 0;
		$this->default = 0;
		$this->config = $this->get_blank_config();
		
   }
   
   function load($id){

	     parent::load($id);

	     $this->config = $this->getConfig();

   }

   function getConfig(){

     $temp = $this->get_blank_config();

	 $data = $this->TablePayoptionconfig->find(' payment_id = "'.$this->id.'"');

	 $config_array = array(

	                             'paymentmethod',
								 'cardtype',
								 'pay_later_options',
								 'cardtype',
								 'field_options',
								 'paylater_field_options'

	                           );
							   
	 if (is_array($data)) 
	 foreach($data as $val){

	   if(in_array($val->key,$config_array) && !is_array($val->value)){

	      $val->value = explode(",",$val->value);

	   }

	   $temp[$val->key] = $val->value;

	 }

	 return $temp;

  }
  
   function get_blank_config() {
  		
		
		return array (
						'payfast_merchant_id' => '',
						'worldpay_instId' => '',
						'payfast_merchant_key' => '',
						'payfast_accountname' => '',
						'pay_later_options' => 
												array (
												),
						'quickbook_app_login' => '',
						'payfast_username' => '',
						'quickbook_connection_ticket' => '',
						'quickbook_app_ID' => '',
						'netdeposit_clientid' => '',
						'netdeposit_clientcode' => '',
						'sage_M_key' => '',
						'sage_M_id' => '',
						'idealLiteHashKey' => '',
						'idealLiteMerchantId' => '',
						'partner_id' => '',
						'usaepay_key' => '',
						'ewaytype' => '',
						'eway_username' => '',
						'psitype' => '',
						'eway_customerid' => '',
						'psi_live_url' => '',
						'psi_storeid' => '',
						'psi_passphrase' => '',
						'psi_merchantId' => '',
						'safe_pay_account_id' => '',
						'paypal_pro_country' => '',
						'paypal_api_user' => '',
						'paypalid' => '',
						'paypal_api_signature' => '',
						'paypal_api_password' => '',
						'transkey' => '',
						'merchid' => '',
						'field_options' => 
											array (
											),
						'depend_on_field' => '',
						'offline_zero_credit' => '',
						'cardtype' => 
									  array (
									  ),
						'godaddy_hosting' => '',
						'paymentmethod' => 
											array (
											),
						'paymentmode' => '',
						'currency_separator' => '',
						'currency_code' => '',
						'transfirst_merchid' => '', 
						'transfirst_transkey' => '',
						'paylater_field' => '',
						'paylater_field_options' => array (
											),
						'authorizenet_type' => 'aim'
						 
					  );		
  }

}

class TablePayoptionconfig extends DtrTable{

   var $payment_id; 

   var $key;

   var $value;

   var $id;

   function __construct( &$db = null ) {

		$db = &JFactory::getDBO();

		$this->db =&$db;

		parent::__construct( '#__dtregister_payment_config', 'id', $db );

  }

  function removeByPaymentid(){

	 $query = "delete from ".$this->getTableName()." where payment_id = ".$this->db->Quote($this->payment_id)." ";

	 $this->db->setQuery($query);

	 $this->db->query();

  }

  function saveAll($data){

	 $config_data = array();

	  if (is_array($data)) 
	  foreach($data as $key=>&$value){

		  if(is_array($value)){

		     $value = implode(",",$value);

		  }

		 $config_data[] = array('key'=>$key,'value'=>$value);

     }

	 pr($config_data);

	 parent::saveAll($config_data);

  }

}