<?php 

/**
* @version 2.8.15
* @package Joomla 2.5
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

class DT_Tagparser {
   
   var $parse_password = false;
   function __construct(){ 

	   $mpaymentmethods =& DtrModel::getInstance('DtregisterModelPaymentmethod');

	   $this->paymentmethods = $mpaymentmethods->getMergeList();

	   $this->mfield = & DtrModel::getInstance('Field','DtregisterModel'); 

	   $this->tfield = $this->mfield->table;
       $fieldType = DtrModel::getInstance('Fieldtype','DtregisterModel');

	   $this->fieldTypes = $fieldType->getTypes();
		 
	   $this->testRegmsg = "";
     
	   $this->invalid_tags = array('GROUP_CUSTOM_FIELDS','CONTACT_CUSTOM_FIELDS','CONTACT_DETAILS');
	 
	}

	 function getTagcontent($tag,$msg){
		 
		 $tagstart = preg_quote("{".$tag."}","%");
		 $tagend = preg_quote("{/".$tag."}","5");
		 $expression = "/(?<=".$tagstart.")(.*)*(?=".$tagend.")/msU";
		 $expression = "(?<=".$tagstart.")(.*)(?=".$tagend.")";
		
		 preg_match_all("%".$expression."%msU",$msg,$matches);
		// print_r($matches);
		 if(isset($matches[0]) && isset($matches[0][0])){
		    return $matches[0][0];
		 }else{
		    return "";	 
		 }
		 prd($matches);
	 }
	 
	  function get_paylater_tagcontent($tag,$msg){
		 
		 $tagstart = preg_quote("{".$tag."}","%");
		 $tagend = preg_quote("{/".$tag."}","5");
		 $expression = "/(?<=".$tagstart.")(.*)*(?=".$tagend.")/msU";
		 $expression = "(?<=".$tagstart.")(.*)(?=".$tagend.")";
		
		 preg_match("%".$expression."%msU",$msg,$matches);
		// print_r($matches);
		 if(isset($matches[0])){
		    return $matches[0];
		 }else{
		    return "";	 
		 }
		 prd($matches);
	 }
	  function category($recipient) {
		$user = $this->getuser($recipient);
		
		$cat = $user->TableEvent->TableCategory;
		if(isset($user->TableEvent->category ) && is_array($user->TableEvent->category )) {
		 foreach($user->TableEvent->category as $cat_id) {
			
				 $cat->load($cat_id);
				 
				 $link[] = $cat->categoryName;
		
		  }
          return $link = trim(implode(" | ",$link));
		}
		
	    return "";
	 }
	 function parse_paylater_tag($thkmsg,$user) {
	      
		 $paylater_tag_content = $this->get_paylater_tagcontent('PAYLATER',$thkmsg);
		 if($paylater_tag_content != "") {
			 
			 $paylater_content_array = explode("{ELSEIF}",$paylater_tag_content);
			 if(is_numeric($user->TableFee->payment_method)) {
				  $paylater_tag_msg = $paylater_content_array[0];
			 } else {
				   $paylater_tag_msg = $paylater_content_array[1];
			 }
			 $paylater_tag_msg = $this->parsetags($paylater_tag_msg,$user);
			 $thkmsg = $this->replace_paylater_tag('PAYLATER',$thkmsg,$paylater_tag_msg);
			
			return  $this->parse_paylater_tag($thkmsg,$user);			 
		 } else {
		   return $thkmsg;
		 }
	 }
     
	  function replace_paylater_tag($tag,$msg,$replace=""){
	    $tagstart = preg_quote("{".$tag."}",'%');
		$tagend = preg_quote("{/".$tag."}","%");
		$expression = "/".$tagstart."(.*)*".$tagend."/msU";
		$expression = $tagstart."(.*)".$tagend;
		
		$data = preg_replace("%".$expression."%msU",$replace,$msg,1);
		/*echo $data; die;
		$data = self::str_replace_once("{".$tag."}","",$data);
		$data = self::str_replace_once("{/".$tag."}","",$data);
		
		echo $data;
		echo "<br/><br/><br/>endbody<br/><br/><br/>";
		die;*/
		return $data;
		
     }
	 
	 function str_replace_once($str_pattern, $str_replacement, $string){ 

        if (strpos($string, $str_pattern) !== false){ 
            $occurrence = strpos($string, $str_pattern); 
            return substr_replace($string, $str_replacement, strpos($string, $str_pattern), strlen($str_pattern)); 
        } 

        return $string; 
    } 
	 
	 function replaceTagContent($tag,$msg,$replace=""){
	    $tagstart = preg_quote("{".$tag."}",'%');
		$tagend = preg_quote("{/".$tag."}","%");
		$expression = "/".$tagstart."(.*)*".$tagend."/msU";
		$expression = $tagstart."(.*)".$tagend;
		
		$data = preg_replace("%".$expression."%msU",$replace,$msg);
		$data = str_replace("{".$tag."}","",$data);
		$data = str_replace("{/".$tag."}","",$data);
		return $data;
		
     }
	 
	 function parsetags($msg="", $recipient=array()){

       if($msg==""){
		  //$msg = $this->testRegmsg;   
	   }
		 // die('here');
		 preg_match_all('/\[[^\]]*\]/',$msg,$matches);
         // die('here too');
		 $tfield = $this->mfield->table;
		 
		 $tags = array();

		 $tagvals = array();
          //pr($matches[0]);
		 foreach($matches[0] as $value){

			  $str_replace_key = substr($value,1,-1);
              if(in_array($str_replace_key,$this->invalid_tags)){
				   continue;
			  }
			  if(!$this->parse_password && $str_replace_key == 'PASSWORD'){
			       continue;
		      }
			  
			  $field = $tfield->findByTag($str_replace_key);
              
			  $tags[] = $value; 
			  
			  if($field){
				  
				  if(isset($recipient->fields[$field->id])){
            		  $recipient->fields[$field->id];
					  $fielddata = $this->tfield->find(' id='.$field->id);
					  
					  $fielddata = $fielddata[0];
					  $classname = 'Field_'.$this->fieldTypes[$fielddata->type];
					  $fieldTable = new $classname();
					  $fieldTable->load($field->id);
					  $function = 'viewHtml';
					  if(is_callable(array($fieldTable,'exportView'))){
						  $function = 'exportView';
					  }
					  
					  $tagvalues = $fieldTable->$function((array)$recipient,null,'',false);
					  
					  $tagvals[] = $tagvalues;	 
					 
				  }else{
                     
			          if($field->type == '6') { // textual
					  		$fielddata = $this->tfield->find(' id='.$field->id);
					  
					        $fielddata = $fielddata[0];
							 $classname = 'Field_'.$this->fieldTypes[$fielddata->type];
					         $fieldTable = new $classname();
					        $fieldTable->load($field->id);
					       
					  
					  		$tagvals[] = $fieldTable->tag_show((array)$recipient);
					  } else {
					  $tagvals[] = '';
					  }

				  }  

			  }else{

			  $function = strtolower($str_replace_key);
			  
            if(is_callable(array($this,$function)))
				 {
				    $tagvals[] = $this->{$function}($recipient);
				 }else{
				       $tagvals[] = "";
				}

			  }

		 }
		 $tags_new = $tags;
		 $tagvals_new = $tagvals;
		 
		  // pr($tags_new);
		  // pr($tagvals_new);
		  
		  $msg = str_replace($tags,$tagvals,$msg);		  
		  $msg = nl2br($msg);
		  $msg = preg_replace("/<p>([\s])*<\/p>/",'',$msg);
		  $msg = preg_replace("/<br \/>[\s]*<br \/>/",'null_space',$msg);
		  $msg = preg_replace("/<p>([\s])*<\/p>/",'',$msg);
		  $msg = preg_replace("/<br \/>[\s]*<br \/>/",'null_space',$msg);
		  $msg = preg_replace("/null_space/",'<br />',$msg);
		  $msg = preg_replace("/<\/p>([\s])*<br \/>/",'</p>',$msg);
		  $msg = preg_replace('%<td><br \/>%', '<td>', $msg);
		  $msg = preg_replace('%</td><br \/>%', '</td>', $msg);
		  $msg = preg_replace('%</tr><br \/>%', '</tr>', $msg);
		  $msg = preg_replace('%<tr><br \/>%', '<tr>', $msg);
		  $msg = preg_replace('%<tbody><br />%', '<tbody>', $msg);
		  $msg = preg_replace('%<\/tbody><br \/>%', '</tbody>', $msg);
		  $msg = preg_replace('%<\/table><br />%', '</table>', $msg);
		  $msg = preg_replace('%(<table[^>]*>)<br />%', '$1', $msg);
		 
		  return $msg;

	 }

	 function event_name($recipient){
         
	     $user = $this->getuser($recipient);

		 return $user->TableEvent->title;

	 }
	 
	  function all_fields($recipient){
	 	
		$user = $this->getuser($recipient);
	   
	   $event = & DtrTable::getInstance('Event','Table');
	   $event->load($user->eventId );
	   if(isset($recipient->type)){
	   		$type = ($user->type == 'I') ? 'I' :'B';
	   } else {
	   		$type = "M";
	   }
	   
		$field = DtrTable::getInstance('field','Table');
		
	    $fieldType = DtrModel::getInstance('Fieldtype','DtregisterModel');
        $txt =  "";
		$txt_parts = array();
	    $fieldTypes = $fieldType->getTypes();
		$tmpfields =  array();
		$field->getAllFields($event,$type,false,0,$tmpfields);
		
		foreach($tmpfields as $field_id => $value){
			
			$field->load($value->id);
			
			if($field->all_tag_enable){
				
				$class = "Field_".$fieldTypes[$field->type];
                
		    	$fieldTable = new $class();

		    	$fieldTable->load($field->id);
				$function = "viewHtml";
				if(method_exists($fieldTable,'exportView')){
			   		$function = "exportView";
				}
		    	
				$value = $fieldTable->{$function}((array)$recipient);
				
				if (isset($value) && $value != "") {
					if(strtolower($fieldTypes[$field->type]) == "textual") {
					    $txt_parts[] = $value;
					} else {
						$txt_parts[] = stripslashes($fieldTable->label).': '.$value;
					}
				}
			}
			
		}

		$txt = implode("<br />",$txt_parts);
		return $txt;
		
	 }
	 
	 function event_time($recipient){
	 	
		$user = $this->getuser($recipient);
		 
		return $user->TableEvent->displaytimecolumn(' ');
	 }

	  function event_date($recipient){

	    $user = $this->getuser($recipient);

		return $user->TableEvent->displaydate();

	 }

	 function location($recipient){

		$user = $this->getuser($recipient);

		return $user->TableEvent->TableLocation->name;

	 }

	 function confirm_num($recipient ){
	    if(isset($recipient->confirmnum) && $recipient->confirmnum !="") {
			
			return $recipient->confirmnum;
			
		}
		$user = $this->getuser($recipient);

		return $user->confirmNum;

	 }
      function original_fee ($recipient) {
	  	 $user = $this->getuser($recipient);
		 global $currency_code;
		 $user->TableEvent->overrideGlobal($user->eventId);
	     $fee = DT_Session::get('register.User.0.fee.OldUserdata');
		 $fee = $fee->fee->fee;
         $fee = DTreg::displayRate($fee,$currency_code); 
		 $user->TableEvent->resumeGlobal();
		 return $fee;
		
	 }
	 
	  function new_fee ($recipient) {
	   $user = $this->getuser($recipient);
		 global $currency_code;
	     $user->TableEvent->overrideGlobal($user->eventId);
         $return = DTreg::displayRate($user->TableFee->fee,$currency_code); 
		 $user->TableEvent->resumeGlobal();
		 return $return;
		prd($_SESSION);
	  }
	 
	 function amount_due($recipient ){
         global $currency_code;
	     $user = $this->getuser($recipient);
		 $user->TableEvent->overrideGlobal($user->eventId);
         $return =  DTreg::displayRate(($user->TableFee->fee - $user->TableFee->paid_amount),$currency_code); 
		 $user->TableEvent->resumeGlobal();
		 return $return;
		 
     }
	 
	 function base_fee($recipient ) {
	 	 
		 global $currency_code;
	     $user = $this->getuser($recipient);
		 $user->TableEvent->overrideGlobal($user->eventId);
		 $amount = $user->TableEvent->getIndividualRate();
         $return =  DTreg::displayRate($amount,$currency_code); 
		 $user->TableEvent->resumeGlobal();
		 return $return;
		 
	 }

	 function paid_status($recipient){

	     $user = $this->getuser($recipient);
         $fee = & DtrModel::getInstance('DtregisterModelFee');
		 return $fee->table->statustxt[$user->TableFee->status];
         	 	 
	 }

	 function barcode($recipient){

		 global $barCodeImagetypeToExt,$barcode_image_type;
		  if(isset($recipient->confirmnum) && $recipient->confirmnum !="") {
			
			 $barcodePath = JURI::root( false )."images/dtregister/barcode/".$recipient->confirmnum.".".$barcode_image_type;
         	 $barcodePath = str_replace('/components/com_dtregister','',$barcodePath);
           return  "\r\n".'<img border="0" src="'.$barcodePath.'" alt="[BARCODE_MISSING] '.$barcodePath.'" />';
			
		}
		$user = $this->getuser($recipient);
//pr($barCodeImagetypeToExt);
         $barcodePath =JURI::root( false )."images/dtregister/barcode/".$user->confirmNum.".".$barcode_image_type;
         $barcodePath = str_replace('/components/com_dtregister','',$barcodePath);
         return "\r\n".'<img border="0" src="'.$barcodePath.'" alt="[BARCODE_MISSING] '.$barcodePath.'" />';

	 }

	 function status($recipient){

	     $user = $this->getuser($recipient);

		 return $user->statustxt[$user->status];

     }

	 function username($recipient){

		  $user = $this->getuser($recipient);

		  return $user->TableJUser->username;

	 }

	 function password($recipient){
        $dtuser = $this->getuser($recipient);
		
		if(DT_Session::get('register.User') !== false ){
			if(count(DT_Session::get('register.User'))== 1){
			  foreach(DT_Session::get('register.User') as $user ){
				  
				  break;
			  }
			}else{
			  foreach(DT_Session::get('register.User') as $user ){
				  
				  if(isset($user['userId'])&& $dtuser->userId == $user['userId']){
				  	 break;
				  }
			  }
			}
			if(isset($user['password'])){
			   return $user['password'];
			}else{ 
			   return "";
			}
		}else{
			return "";	 
		}

	 }

	 function location_details($recipient){

		 $user = $this->getuser($recipient);

		 $location = $user->TableEvent->TableLocation;

		 $locParts = array();
         $secondline = array($location->city , trim($location->state.' '.$location->zip));
		 $locParts[] = $location->address;
		 $locParts[] = $location->address2;

		 $locParts[] = implode(", ",array_filter($secondline));

		 $locParts[] = $location->country;

		 $locParts[] = $location->phone;

		 $locParts[] = $location->email;

		 $locParts[] = $location->website;

	     return implode(' <br /> ',array_filter($locParts));

	 }  

	 function firstname($recipient){

		 if(isset($recipient->groupUserId)){

			$recipient->firstname;

	     }else{

		   $recipient->getFieldByName('firstname');

		 }

	 }

	  function name($recipient){

		 $nameparts = array();

	   	 if(isset($recipient->groupUserId)){

			$nameparts[] = $recipient->firstname;

			$nameparts[] = $recipient->lastname;

	     }else{

		    $nameparts[] = $recipient->getFieldByName('firstname');

		    $nameparts[] = $recipient->getFieldByName('lastname');

		 }

		 return implode(' ',array_filter($nameparts));

	 }

	 function lastname($recipient){

		 if(isset($recipient->groupUserId)){

			$recipient->lastname;

	     }else{

		   $recipient->getFieldByName('lastname');

		 }

	 }

	 function group_number($recipient){

		 $user = $this->getuser($recipient);

		 return $user->memtot;

	 }

	 function memtot($recipient){

		 $user = $this->getuser($recipient);

		 return $user->memtot;

	 }
	 
	  function tax_exemption_code($recipient){

		 $user = $this->getuser($recipient);

		 return $user->tax_exemption_code;

	 }

	 function amount($recipient){
        global $currency_code;
		$user = $this->getuser($recipient);
		$user->TableEvent->overrideGlobal($user->eventId);

		$user->fee = $user->TableFee->findByUserId($user->userId);
		$return =  DTreg::displayRate($user->TableFee->formatamount($user->fee->fee),$currency_code); 
		$user->TableEvent->resumeGlobal();
		return $return;

	 }
	 
	   function trans_id($recipient){

		 $user = $this->getuser($recipient);

		 return $user->transaction_id;

	 }
	 
	 function amount_paid($recipient ){
        global $currency_code;
		
		$user = $this->getuser($recipient);
		$user->TableEvent->overrideGlobal($user->eventId);
		$process = DT_Session::get('Setting.process');
        if(DT_Session::get($process.'.payment.paying_amount')) {
			$return =  DTreg::displayRate($user->TableFee->formatamount(DT_Session::get($process.'.payment.paying_amount')),$currency_code);
			$user->TableEvent->resumeGlobal();
		    return $return;
 
		}
		$return = DTreg::displayRate($user->TableFee->formatamount($user->TableFee->paid_amount),$currency_code); 
		$user->TableEvent->resumeGlobal();
		return $return;

	}
	
	 function cancel_fee($recipient ){
        global $currency_code;
		$user = $this->getuser($recipient);
        $user->TableEvent->overrideGlobal($user->eventId);
		$return = DTreg::displayRate($user->TableFee->formatamount($user->TableFee->cancelfee),$currency_code); 
		
		$user->TableEvent->resumeGlobal();
		return $return;

	}

	 function payment_type($recipient){

	     $user = $this->getuser($recipient);

		 $mpaymentmethods = & DtrModel::getInstance('DtregisterModelPaymentmethod');

		 $methods = $mpaymentmethods->getMergeList(true);
		 // pr($methods[$user->TableFee->payment_method]);
		 // prd($methods); echo 'hello';
		
		 return isset($methods[$user->TableFee->payment_method])?$methods[$user->TableFee->payment_method]:JText::_('DT_FREE');

	 }

	 function amount_notax($recipient){
		 global $currency_code;
	     $user = $this->getuser($recipient);
		 $user->TableEvent->overrideGlobal($user->eventId);
		 $amount = $user->TableFee->fee - $user->TableFee->tax;
		 $return = DTreg::displayRate($user->TableFee->formatamount($amount),$currency_code);
		 $user->TableEvent->resumeGlobal();
		 return $return;
		 
	}
		
	function tax($recipient ){
		
         global $currency_code;
	     $user = $this->getuser($recipient);
		 $user->TableEvent->overrideGlobal($user->eventId);
         $return = DTreg::displayRate($user->TableFee->tax,$currency_code); 
		 $user->TableEvent->resumeGlobal();
		 return $return;
		 
		 
    }

	function date_registered($recipient){

		$user = $this->getuser($recipient);

		return $user->showRegDate();

	} 
     function registered_date($recipient){
	    $user = $this->getuser($recipient);

		return $user->showRegDate();
	 }
	 function getuser($recipient){

		  if(isset($recipient->groupUserId)){

			$user = & DtrModel::getInstance('DtregisterModelUser');

			$user = $user->table;

			$user->load($recipient->groupUserId);

	     }else{

		    $user = $recipient;

		 }
        
		 return $user;

	 }

	 function userdata($userId){

		  $user = & DtrModel::getInstance('DtregisterModelUser');

		  $user = $user->table;

		  $user->load($userId);

		  $type = ($user->type == 'I')?'I':'B';

		  $fieldshtml = "";

		  if($user->user_id > 0 ){

			  $fieldshtml .= '<div style="clear:both"><dl><dt class="dtlabel">'. JText::_( 'DT_USERNAME' ).':</dt><dd class="dtfield">'.$user->TableJUser->username.'</dd></dl></div>';

		  }

		  $fieldshtml .= $user->TableEvent->viewFields($type,(array)$user->getObjData(),false);

		  if($user->type == 'G'){

			  $i = 1;

			  foreach($user->members as $key => $member){

				  $fieldshtml .= "<div style='clear:both'><u>".JText::_( 'DT_MEMBER' ).($i)." </u></div>";

		          $fieldshtml .= $user->TableEvent->viewFields('M',(array)$member,false,'frmcart',false);

				  $i++;

			  }

		  }

		 return $fieldshtml;

	 }
	 
	 function code($recipient){
		
		if(isset($recipient->discount_code_id) && $recipient->discount_code_id > 0) {
			
			$recipient->discount_code_id ; 
			$discount_code = new TableDiscountcode();
			$discount_code->load($recipient->discount_code_id);
			return $discount_code->code;
			
		    return $recipient->TableDiscountcode->code;
		}
     	$user = $this->getuser($recipient);
		if($user->discount_code_id && $recipient->discount_code_id > 0){
		  return $user->TableDiscountcode->code;
		}else{
		   return '';
		}
	 }
	 
	 function offline_payment($recipient) {
	 	global $cardtype;
		pr($cardtype);
		$cardtype_temp = array_values($cardtype);
		$user = $this->getuser($recipient);
		$billingInfo = DT_Session::get('register.payment.billing');
		
	    if($user->card) { 
		$billingInfo = (array)$user->card;
		pr($billingInfo);
		$country_field = $this->tfield->fingbyName('country');
		$countries =explode("|",$country_field->values);
		ob_start();
	    ?>
		  <table>
			 <tr>
				<td><?php echo JText::_( 'DT_CARD_HOLDER_FIRSTNAME' ); ?></td><td><?php echo $billingInfo['firstname']; ?></td>
			 </tr>
			 <tr>
				<td><?php echo JText::_( 'DT_CARD_HOLDER_LASTNAME' ); ?></td><td><?php echo $billingInfo['lastname']; ?></td>
			 </tr>
			 <tr>
				<td><?php echo JText::_( 'DT_BILLING_ADDRESS' ); ?></td><td><?php echo $billingInfo['address']; ?></td>
			 </tr>
			 <tr>
              <td><?php echo JText::_( 'DT_CITY' ); ?></td><td><?php echo $billingInfo['city']; ?></td>
           </tr>
           
           <tr>
              <td><?php echo JText::_( 'DT_STATE' ); ?></td><td><?php echo $billingInfo['state']; ?></td>
           </tr>
           
             <?php if(isset($billingInfo['country']) && isset($countries[$billingInfo['country']])) {?>
             <tr>
                <td><?php echo JText::_( 'DT_COUNTRY' ); ?></td><td><?php echo $countries[$billingInfo['country']]; ?></td>
             </tr>
             <?php } ?>
           
           <tr>
              <td><?php echo JText::_( 'DT_ZIPCODE' ); ?></td><td><?php echo $billingInfo['zipcode']; ?></td>
           </tr>
           
           <tr>
              <td><?php echo JText::_( 'DT_PHONE' ); ?></td><td><?php echo $billingInfo['phone']; ?></td>
           </tr>
           
            <tr>
              <td><?php echo JText::_( 'CARD_TYPE' ); ?></td><td><?php echo $cardtype_temp[$billingInfo['cardtype']]; ?></td>
           </tr>
           
            <tr>
              <td><?php echo JText::_( 'CARD_NUMBER' ); ?></td>
              <td><?php echo 'XXXX-XXXX-XXXX-'.substr($billingInfo['x_card_num'],-4);  ?></td>
           </tr>
           
            <tr>
              <td><?php echo JText::_( 'CARD_EXPIRY_DATE' ); ?></td><td><?php echo $billingInfo['x_exp_date']; ?></td>
           </tr>
           <?php 
			  if(DT_Session::get('register.payment.billing.x_card_code')) {
				  $ccv_code = DT_Session::get('register.payment.billing.x_card_code');
			?>
            <tr>
              <td><?php echo JText::_( 'CVV_CODE' ); ?></td><td><?php echo $ccv_code; ?></td>
           </tr>
        	<?php
			  }
			?>
        </table>
	    <?php
		return str_replace("\n","",ob_get_clean());
		} else {
			return "";
		}
		
	 }
	 
	 function fee_breakdown($recipient) {
     	
		global $currency_code,$show_price_tax,$show_fee_breakdown, $discount_code_group_reg,$late_fee_group_reg,$member_discount_group_reg,$bird_discount_group_reg;
       
		$TableUser = $this->getuser($recipient);
		//prd($TableUser->TableEvent->slabId);
		$TableUser->TableEvent->overrideGlobal($TableUser->eventId);
		
		$feeObj = new DT_Fee($TableUser->TableEvent,$TableUser);
		
		$juser = JFactory::getUser();
	   
	    $feeObj->getFee($juser->id);
		ob_start();
		if($feeObj->paid_fee > 0){
			$memtot = $TableUser->memtot;
			$discount = $feeObj->memberdiscount + $feeObj->birddiscount + $feeObj->discountcodefee;
			?>
            <strong><?php echo JText::_( 'TOTAL_REGISTRATION_COST' );?>:</strong> <?php echo DTreg::displayRate($feeObj->paid_fee,$currency_code); ?>
           <?php if($show_fee_breakdown) {?>
            <br /><div id="price_breakdown">
			<?php echo JText::_( 'DT_REGISTRATION_FEE' ); ?>:&nbsp;

			<?php 
		   if ($feeObj->slab->type == "flat") {
				echo $TableUser->memtot ."&nbsp;".JText::_('DT_MEMBERS')."&nbsp;=&nbsp;". DTreg::displayRate($feeObj->basefee,$currency_code);
			} else {
				echo $TableUser->memtot ."&nbsp;x&nbsp;". DTreg::displayRate($feeObj->basefee/$TableUser->memtot,$currency_code);
			}
			if ($discount>0){
				if($feeObj->memberdiscount>0)
				  echo "<br />".JText::_( 'DT_MEMBER_DISCOUNT' ).": ".DTreg::displayRate($feeObj->memberdiscount,$currency_code); 
				if($feeObj->birddiscount>0)
				  echo "<br />".JText::_( 'DT_BIRD_DISCOUNT' ).": ".DTreg::displayRate($feeObj->birddiscount,$currency_code);
				if($feeObj->discountcodefee > 0){
			      echo "<br />"."<strong>".JText::_( 'DT_DISCOUNT_CODE_APPLIED').": ".DTreg::displayRate($feeObj->discountcodefee,$currency_code). '</strong>';
				}elseif(isset($this->discountCodeError) && $this->discountCodeError = ""){
				   	echo "<br />".$this->discountCodeError;
				}
			} 
		    if ($feeObj->latefee>0){
				 echo "<br />".JText::_( 'DT_LATE_FEE' ).": ".DTreg::displayRate($feeObj->latefee,$currency_code); 
			}
			
			if(is_array($feeObj->fieldfee)){
				foreach($feeObj->fieldfee as $key=>$feefield){
					
					if($feefield['fee']!=0){
				   echo "<br />".$feefield['field']->label.": ".DTreg::displayRate($feefield['fee'],$currency_code);
					}
				}

			}
			
			if($feeObj->tax >0 && $show_price_tax){
			    echo "<br />".JText::_( 'DT_TAX' ).": ".DTreg::displayRate($feeObj->tax,$currency_code); 
			}
			
			if($feeObj->changefee >0){
			    echo "<br />".JText::_( 'DT_CHANGE_FEE' ).": ".DTreg::displayRate($feeObj->changefee,$currency_code); 
			}
			
			if($feeObj->cancelfee >0){
			    echo "<br />".JText::_( 'DT_CHANGE_FEE' ).": ".DTreg::displayRate($feeObj->cancelfee,$currency_code); 
			}
			
			?></div>
          
		<?php 
		}
	    }
		
		$TableUser->TableEvent->resumeGlobal();
		$text = ob_get_clean();
		
		return str_replace("\n","",$text);
		
	 }
	 
	 function cc4digits($recipient) {
	     $user = $this->getuser($recipient);
		 $billing_info = (array)$user->card ;
		 if(!isset($billing_info['x_card_num']) || $billing_info['x_card_num'] == "") {
		     return "";
		 }
		 return  'XXXX-XXXX-XXXX-'.substr($billing_info['x_card_num'],-4); 
	    
	 }

}

?>