<?php

/**
* @version 3.0.11
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class DtregisterControllerCategory extends DtrControllerform {

	var $name ='category';

	function __construct($config = array()){

		 parent::__construct($config);

		 $this->view = $this->getView( 'category', 'html' );

		 $this->view->setModel($this->getModel('category'),true);

		 $this->registerTask( 'new',  'add' );

		 $this->registerDefaultTask("category");

		 JToolBarHelper::title( JText::_( 'DT_CATEGORY_MANAGEMENT'), 'dtregister' );

	}

	function edit($key = NULL, $urlVar = NULL){

       JToolBarHelper::back();

       JToolBarHelper::divider();

       JToolBarHelper::save('save');

	   $this->view->setLayout('edit');
       $this->getModel('category')->setState($this->getModel('category')->getName().'.id', $_GET['id']);
	   $this->view->display();

	}

	function category(){

	    $mainframe = JFactory::getApplication();
        	
        JToolBarHelper::divider();

        JToolBarHelper::deleteList(JText::_('DT_DELETE_CATEGORY_CONFIRM'),'deletelist');

        JToolBarHelper::divider();

        JToolBarHelper::addNew('add');
		JToolBarHelper::divider();
        JToolBarHelper::publishList('publish');
		JToolBarHelper::divider();
		JToolBarHelper::unpublishList('unpublish');
	    $this->view->setLayout('list');

		$this->view->display();

	}

    function publish(){
	  
	  $mainframe = JFactory::getApplication();
	  global $Itemid;
      $cid = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	  $category = $this->getModel('category')->table;

	   if (is_array($cid)) 
	   foreach($cid as $id){

	      $category->load($id);

		  $category->published = 1;

		  $category->store();      

	  }
	 
      $mainframe->redirect("index.php?option=com_dtregister&controller=category&Itemid=$Itemid");
			
	}
	
	  function unpublish(){
	  
	  $mainframe = JFactory::getApplication();
	  global $Itemid;
      $cid = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	  $category = $this->getModel('category')->table;

	   if (is_array($cid)) 
	   foreach($cid as $id){

	      $category->load($id);

		  $category->published = 0; 

		  $category->store();      

	  }
      $mainframe->redirect("index.php?option=com_dtregister&controller=category&Itemid=$Itemid");
			
	}
	
	function orderup(){

	  
	  $mainframe = JFactory::getApplication();
	  global $Itemid;

	  $cid = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	  $this->reorder( intval( $cid[0] ), -1);

	  $mainframe->redirect("index.php?option=com_dtregister&controller=category&task=list&Itemid=$Itemid");

	}

	public function saveOrderAjax()
	{
		
		//JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Get the arrays from the Request
		$pks   = $this->input->post->get('cid', null, 'array');
		$order = $this->input->post->get('order', null, 'array');
		$originalOrder = explode(',', $this->input->getString('original_order_values'));

		// Make sure something has changed
		if (!($order === $originalOrder)) {
		
			// Get the model
			$table = $this->getModel('category')->table;
			// Save the ordering
			$return = $table->saveorder($pks, $order);
			if ($return)
			{
				echo "1";
			}
		}
		// Close the application
		JFactory::getApplication()->close();

	}

	function saveorder(){

	   $mainframe = JFactory::getApplication();
	   global $Itemid;

       $cid = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	   $database = JFactory::getDBO();

	   $total = count( $cid );

	   $order = JFactory::getApplication()->input->get( 'order', array(0), '', 'array' );

	   $row = $this->getModel('category')->table;

	   for( $i=0; $i < $total; $i++ ) {

		$row->load( (int) $cid[$i] );

		if ($row->ordering != $order[$i]) {

			$row->ordering = $order[$i];

			if (!$row->store()) {

				echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";

			exit();

			}

		}

	}

	$mainframe->redirect("index.php?option=com_dtregister&controller=category&task=list&Itemid=$Itemid");

	}

	function orderdown(){

	   $mainframe = JFactory::getApplication();
	   global $Itemid;

	   $cid = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	   $this->reorder( intval( $cid[0] ), 1 );

	   $mainframe->redirect("index.php?option=com_dtregister&controller=category&task=list&Itemid=$Itemid");

	}

	function delete(){

		$mainframe = JFactory::getApplication();
		global $Itemid;

		$database = JFactory::getDBO();

		$id = JFactory::getApplication()->input->get('id');

		$sql = 'Select slabId From #__dtregister_group_event WHERE category=' . $database->Quote( $id );

		$database->setQuery($sql);

		$total=$database->loadResult();

		if ($total){

		  $msg = JText::_( 'DT_CATEGORY_DELETE_WARNING' );

		}

		else {

	     $cat = $this->getModel('category');

	     $cat->table->delete( $id  );

		 $msg = JText::_( 'DT_CATEGORY_DELETED' );


	   }

		$mainframe->redirect("index.php?option=".DTR_COM_COMPONENT."&task=list&controller=category&Itemid=$Itemid",$msg);

	}
	
	function deletelist(){

	   $mainframe = JFactory::getApplication();

	   global $Itemid;

    $categories = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	$database = JFactory::getDBO();

	$warning = false;

	$message = false;
     $cat = $this->getModel('category');
	if (is_array($categories)) 
	foreach($categories as $category){

		$sql='Select slabId From #__dtregister_group_event WHERE category=' . $database->Quote( $category );

		$database->setQuery($sql);

		$total=$database->loadResult();

		if ($total){

			$warning = true;

		}else{

		   $message = true;

	       $cat->table->delete( $category );

		}

	}

	$msg = "";

	if($warning){

		$msg = JText::_( 'DT_CATEGORY_DELETE_WARNING' );

	}

	if($message){

	   $msg .= " ".JText::_( 'DT_CATEGORY_DELETED' );   

	}

	 $mainframe->redirect("index.php?option=".DTR_COM_COMPONENT."&task=list&controller=category&Itemid=$Itemid",$msg);

	}

	function reorder($uid, $inc){

	   $cat = $this->getModel('category');

	   $cat->table->load( (int)$uid );

	   $cat->table->reorder();

	   $cat->table->move( $inc, " parent_id= ".$cat->table->parent_id );

	}

	function add(){

		JToolBarHelper::back();

        JToolBarHelper::divider();

		JToolBarHelper::save('save');

	    $this->view->setLayout('add');

		$this->view->display();

	}

	function save($key = NULL, $urlVar = NULL){

	    $mainframe = JFactory::getApplication();
		global $Itemid;

	    $catid = JFactory::getApplication()->input->get('categoryId',false);

		$cat = $this->getModel('category')->table;
        // $cat->rebuild();
		
		$data = JFactory::getApplication()->input->get('jform', array(), 'post', 'array');
		$_POST['access'] = $data['access'];
		unset($_POST['jform']);
		echo  "<pre>";
		print_r($_POST);
		$cat->setLocation($_POST['parent_id'],'last-child');
		$cat->save($_POST);
       
		$mainframe->redirect("index.php?option=com_dtregister&controller=category&task=list&Itemid=$Itemid");

	}

}

?>