<?php

/**
* @version 3.0.11
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class DtregisterControllerConfig extends DtrController {

	var $name ='config';

	function __construct($config = array()){
		 
		 $config = array('default_task'=>'index');
		 
		 parent::__construct($config);

		 $this->view = $this->getView( 'config', 'html' );

		 $this->view->setModel($this->getModel('field'),false);
		
		 $this->view->setModel($this->getModel('user'),false);
		
		 $this->registerTask( 'edit', 'edit' );

		 $this->registerDefaultTask("index");

	}

	function index(){	

			$document = JFactory::getDocument();

			$document->setTitle(JText::_('DT_CONFIGURATION'));

			JToolBarHelper::title( JText::_( 'DT_CONFIGURATION' ), 'dtregister' );

			$this->view->setLayout('edit');

			$this->view->display();

		}

		function loadtab(){
			
			$type = JFactory::getApplication()->input->get('type');

			$this->view->setLayout('tab.'.$type);

			$this->view->display();

		}

		function save(){

			$mainframe = JFactory::getApplication();
			
			global $eventListOrder,$eventListOrder_sec;

			$conf = $this->getModel('config');
            
			if($eventListOrder != $_POST['config']["eventListOrder"] || $eventListOrder_sec != $_POST['config']["eventListOrder_sec"]){
	            $conf->updateEventorder( $_POST['config']["eventListOrder"],$_POST['config']["eventListOrder_sec"]);
	        }
    
			$database = JFactory::getDBO();

			$sql="TRUNCATE TABLE `#__dtregister_config` ";

			$database->setQuery($sql);

			$database->query();

			$mconfig = $this->getModel('config');

			foreach($_POST['config'] as $key=>$value){

				 if(is_array($value)){

					 if(in_array($key,$mconfig->config_array_map)){			  

					    $multiplevalue = json_encode($value);

					 // prd((array)json_decode($value));			

			         }else{

						 $multiplevalue= implode(',',$value);

					 }		

					$key = $database->Quote($key);

					$multiplevalue=$database->Quote($multiplevalue);

					$sql="Insert Into #__dtregister_config(config_key,config_value,`title`) Values($key,$multiplevalue,$key)";

					$database->setQuery($sql);

					if(!$database->query()){

						echo $database->getErrorMsg();		

						die;

					}

				  }else{
                     
                    $safeHtmlFilter = JFilterInput::getInstance(null, null, 1, 1);
			        $value = $safeHtmlFilter->clean($value, $type);
					
					$key=$database->Quote($key);

					$value=$database->Quote($value);

					$sql="Insert Into #__dtregister_config(config_key,config_value,`title`) Values($key,$value,$key)";

					$database->setQuery($sql);

				    if(!$database->query()){

						echo $database->getErrorMsg();						

						die;

					}

				}

			}
		  $mainframe->redirect("index.php?option=".DTR_COM_COMPONENT."&task=index&controller=config", JText::_( 'SETTINGS_SAVED' ));
		
		}

}
