<?php

/**
* @version 3.0.11
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class DtregisterControllerMassemail extends DtrController {

   var $name ='massemail';

	function __construct($config = array()){ 
         $config = array('__default'=>'index','default_task'=>'index','task_map'=>array('new'=>'add'));
		 parent::__construct($config);

		 $this->view = $this->getView( 'massemail', 'html' );

		 $this->view->setModel($this->getModel('massemail'),true);
         $this->view->setModel($this->getModel('user'),false);
		 $this->registerTask( 'new',  'add' );

		 $this->registerDefaultTask("index");

		 JToolBarHelper::title(  JText::_( 'DT_MASSEMAIL_MANAGEMENT'), 'dtregister' );
		

	}
	
	function sent_emails(){
	   
	   $this->view->setLayout('sent_emails');

	    $this->view->display();
	   
	}
	
	function delete_email(){
	   
	   $id = JFactory::getApplication()->input->get( 'id');
	   
	   $database = JFactory::getDBO();
	   
	     $sql1='DELETE FROM #__dtregister_outgoing_emails WHERE id=' . $database->Quote( $id );

		$database->setQuery($sql1);

	    $database->query();
	    $error =  $database->getError();
		$ret = array('action'=>'script' , 'script'=>' DTjQuery("#row_'.$id.'").remove() ; ' , 'error'=>$error,'message'=>JText::_('DT_EMAIL_REMOVED'));
		if($error != ""){
		 $ret['script'] = "";
		 $ret['message'] =  $error ;
		}
	    ob_get_clean();
	   echo json_encode($ret);
	   
	   die;
	   
	   
	}
	
	function resend_email(){
	   
	   

       $id = JFactory::getApplication()->input->get( 'id');

	   
	   $ret = array('action'=>'script' , 'script'=>' DTjQuery("#row_'.$id.'").remove() ; ');
		
	   ob_clean();
	   echo json_encode($ret);
	   
	   die;
	   
	}
 
	function index(){
   
 		JToolBarHelper::deleteList(JText::_( 'DT_DELETE_MASSEMAIL'),'delete');

        JToolBarHelper::divider();

        JToolBarHelper::editList('edit', JText::_( 'DT_EDIT') );

	    JToolBarHelper::divider();

      

		$this->view->setLayout('list');

	    $this->view->display();

	}

	function add(){

	    JToolBarHelper::cancel('cancel');

        JToolBarHelper::save('save');

		$this->view->setLayout('add');

	    $this->view->display(); 

	}

	

	function edit(){

	    JToolBarHelper::cancel('cancel');

		JToolBarHelper::title(  JText::_( 'DT_MASSEMAIL_MANAGEMENT'), 'dtregister' );

        JToolBarHelper::save('save');

	   $this->view->setLayout('edit');

	   $this->view->display();

	}

	
	function delete(){
		
	   $mainframe = JFactory::getApplication();

    $mass_emails = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	$database = JFactory::getDBO();

	$warning = false;

	$message = false;

	if (is_array($mass_emails)) 
	foreach($mass_emails as $mass_email){

		
	

		   $message = true;

		   $sql1='DELETE m , o FROM #__dtregister_mass_emails m left join #__dtregister_outgoing_emails o on o.mass_email_id = m.id  WHERE m.id=' . $database->Quote( $mass_email );

		   $database->setQuery($sql1);

		   $database->query();

		

	}

	$msg = "";

	

	   $msg .=  " ".JText::_( 'DT_MASSEMAIL_DELETED' );

	

	$mainframe->redirect("index.php?option=".DTR_COM_COMPONENT."&task=list&controller=massemail",$msg);

	}
	
	function getTemplate(){
	    
		$id = JFactory::getApplication()->input->getInt('template_id',0);
	    $table = $this->getModel('template')->table;
		$table->load($id);
		
		$data = array('subject'=>$table->name,'content'=>$table->tmpl_content);
		ob_clean();
		echo json_encode($data);
		die;
	}

}