<?php

/**
* @version 3.1.7
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class DtregisterControllerPermission extends DtrController { 

   var $name ='permission';

   function __construct($config = array()){

		 parent::__construct($config);

		 $this->view = $this->getView( 'permission', 'html' );  

		 $this->view->setModel($this->getModel('permission'),true);

		 $this->view->setModel($this->getModel('aro'));

		 $this->view->setModel($this->getModel('aco'));

		 $this->registerDefaultTask("index");

		 JToolBarHelper::title( JText::_( 'DT_PERMISSION_MANAGEMENT'), 'dtregister' );
		 
		  $user	= JFactory::getUser();
		  $mainframe = JFactory::getApplication();

		  //$levels = array_unique($user->getAuthorisedGroups());
		  
		    if(!JFactory::getUser()->authorise('permisson.edit', 'com_dtregister')){
			  $mainframe->redirect("index.php?option=com_dtregister&controller=authorize&task=auth");
		  }

	}

	function index(){

		JToolBarHelper::save('update',JText::_( 'DT_SAVE'));

		$mPermission = $this->getModel('permission');

		$matrix = $mPermission->table->getmatrix();

		$this->view->assign('matrix',$matrix);
        $this->view->setLayout('matrix');
		$this->view->display();

   }

   function update(){

	  $mainframe = JFactory::getApplication();
	
	  $data = JFactory::getApplication()->input->get('data',array(),'request', 'array');

	  $tableRows = array();

	  if (is_array($data['permission'])) 
	  foreach($data['permission'] as $key => $permission){

		 foreach($permission as $name =>$val){

			 $tableRows[] = array('aro_id'=>$key,'group'=>$name);

		  }

	  } 

	  $mPermission = $this->getModel('permission');

	  $matrix = $mPermission->table->update($tableRows);
	
	  $mainframe->redirect("index.php?option=com_dtregister&controller=permission",JText::_('DT_PERMISSIONS_SAVED'));

   }
   
}

?>