<?php

/**
* @version 3.1.7
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class DtregisterControllerReminder extends DtrController { 
	
	var $name = 'reminder';
	
	 function __construct($config = array()){
          $config = array('default_task'=>'index');
		 parent::__construct($config);

		 $this->view = $this->getView( 'reminder', 'html' );  
         $this->view->setModel( $this->getModel('reminder'));
		 $this->view->setModel( $this->getModel('event'));
		 $this->registerDefaultTask("index");
		 JToolBarHelper::title( JText::_( 'DT_REMINDER_MANAGEMENT'), 'dtregister' );

	}
	
	function index() {
		
		JToolBarHelper::addNew();
		$this->view->setLayout('index');

	    $this->view->display();	
	}
	
	function add() {
		if(isset($_POST['frmsubmit'])) {
	    	
			$reminder = $this->getModel('reminder')->table;
        
			$data = JFactory::getApplication()->input->get('reminder', array(), 'post', 'array');
			$reminder->save($data);
			
			echo JText::_('DT_REMINDER_ADDED');
			?>
            <script>
             window.parent.DTjQuery(".externalSite").dialog('close');
			 </script>
            <?php
			die;
		}
		$mReminder = $this->getModel('reminder');
		$reminder = $mReminder->table;
		
		$this->view->assign('reminder',$reminder);
		$this->view->setLayout('add');

	    $this->view->display();
	}
	
	function edit() {
		
		if(isset($_POST['frmsubmit'])) {
	    	
			$reminder = $this->getModel('reminder')->table;
        
			$data = JFactory::getApplication()->input->get('reminder', array(), 'post', 'array');
			$reminder->save($data);
			
			echo JText::_('DT_REMINDER_UPDATED');
			?>
            <script>
             window.parent.DTjQuery(".externalSite").dialog('close');
			 </script>
            <?php
			die;
		}
		$mReminder = $this->getModel('reminder');
		$reminder = $mReminder->table;
		
		$reminder->load($_REQUEST['id']);
		$this->view->assign('reminder',$reminder);
		$this->view->setLayout('add');

	    $this->view->display();
		
	}
	
	function remove() {
		$mReminder = $this->getModel('reminder');
		$reminder = $mReminder->table;
		
		$reminder->delete($_REQUEST['id']);
		echo JText::_('DT_REMINDER_REMOVED');
			die;
	}
	
	function remove_file() {
		
		$reminder = $this->getModel('reminder')->table;
		$reminder->load($_REQUEST['id']);
		unset($reminder->files[$_REQUEST['file']]);
		
		$files = json_encode(array_keys($files));
		$reminder->save_field('files',$files);
		
	}
	
	function reminders() {
		
		$this->view->setLayout('reminders');

	    $this->view->display();	
	}
	
}
?>