<?php

/**
* @version 3.0.11
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

jimport('joomla.application.component.controllerform');

class DtrControllerform extends JControllerForm {
	
	 function __construct($config = array()){

		$this->addModelPath(JPATH_COMPONENT_ADMINISTRATOR.DS.'models');

		parent::__construct($config);
        if(isset($config['task_map'])){
		  	foreach($config['task_map'] as $task=>$map){
				$this->registerTask( $task, $map );	
			}
		}
		$view = $this->getView( $this->name, 'html','dtregisterview' );
        $this->getModel('payoption');
		$this->config = $this->getModel('config');

		$this->config->setGlobal();

		global $sign_up_redirect,$Itemid,$private_event_notification,$private_event_redirect; 

		if($private_event_notification=='redirect'){

		   $sign_up_redirect = $private_event_redirect;

		}else{

		   $sign_up_redirect = "index.php?option=com_dtregister&controller=content&Itemid=$Itemid&task=sign_up";

		}

        $view->setModel($this->getModel('dtregister'),false);

		$view->setModel($this->getModel('config'),false);
		
		$view->setModel($this->getModel('Accessoptions'),false);
		
		$view->setModel($this->getModel( 'Currency' ),false);

		$view->setModel($this->getModel( 'jomsocial' ),false);

		$view->setModel($this->getModel( 'cbprofiler' ),false);

		$view->setModel($this->getModel( 'buttoncolor' ),false);

		$view->setModel($this->getModel( 'dateformat' ),false);

		$view->setModel($this->getModel( 'paymentmethod' ),false);

		$view->setModel($this->getModel( 'cardtype' ),false);

		$view->setModel($this->getModel( 'paylater' ),false);	

		$view->setModel($this->getModel( 'country' ),false);

		$view->setModel($this->getModel( 'barcode' ),false);	

		$view->setModel($this->getModel( 'aro' ),false);	

		$view->setModel($this->getModel( 'permission' ),false);

		$view->setModel($this->getModel( 'aco' ),false);
		
		$this->getModel('field');
        
		$tAccessoption = $this->getModel('Accessoptions')->table;
		
		$view->assign('accessOptions',$tAccessoption->optionslist());
		
		$eventId = DT_Session::get('register.Event.eventId');
        
		if($this->checkpermission() === false){

			JRequest::setVar('task','auth');

	    }elseif($eventId ){
		   	$evtTable = $this->getModel('event')->table;
			$evtTable->load($eventId);
			$user = JFactory::getUser();
			if($evtTable->title !==""){
			  if((!($evtTable->TableCategory->access <=$user->get('aid')) || $evtTable->TableCategory->published == 0)&&$evtTable->TableCategory->categoryId > 0){
			   	 JRequest::setVar('task','auth');
			  }
			}
			
		}

	}
	
	function getModel($model="",$prefix='dtregistermodel',$bool=array()){
		return parent::getModel($model,$prefix,array());
	}
	
	function getView( $view="", $type='html',$prefix= 'dtregisterview' ,$config=array() ){
		
		return parent::getView( $view, $type,$prefix);
		
	}
	
	function checkpermission(){
	 
     $user = JFactory::getUser();
	 $aro = $this->getModel( 'aro' )->table->findaroByUser($user);

	 $acoController = str_replace("dtregistercontroller",'',strtolower(get_class($this)));
	 
	 $map = array('eventmanage' => 'event');
	 if(isset($map[$acoController])){
		$acoController = $map[$acoController];
	 }
	
	 if(@in_array(JFactory::getApplication()->input->get('task',$this->taskMap['__default']),$this->taskMap)){
		$task = JFactory::getApplication()->input->get('task',$this->taskMap['__default']);
	 }else{
	 	$task = $this->taskMap['__default'];
	 }
	  
	  if($task == $this->taskMap['__default'] && $task != 'eventlist' && $task !="index"){ 
		 if($acoController == 'event') {
		     $edit_task = 'delete';
		 } else {
		     $edit_task = 'edit';
		 }
		 
	 	 $editaco = $this->getModel( 'aco' )->table->find(' controller="'.$acoController.'" and task="'.$edit_task.'" ');
		 $addaco = $this->getModel( 'aco' )->table->find(' controller="'.$acoController.'" and task="add" ');
		
		 if(isset($editaco[0]) && isset($addaco[0])){
			 $editaco = $editaco[0];
			 $addaco = $addaco[0];
			 
			 $function = $editaco->type."Check";
			 
		     $edit_permission = $this->{$function}($editaco,$aro);
			 $function = $addaco->type."Check";
			 
		     $add_permission = $this->{$function}($addaco,$aro);
			
			 if($add_permission && $edit_permission){
				 return true;
			 }else{
				 return false;
			 }
			 
		 }
		 
	 }else{
	  
	   $aco = $this->getModel( 'aco' )->table->find(' controller="'.$acoController.'" and task="'.$task.'" ');
	   
	   if(isset($aco[0])){
		  
		   $aco = $aco[0];
		   $function = $aco->type."Check";
		   return $this->{$function}($aco,$aro);
  
	   }
	 }
	 
	 return true;

  }
  
    function sessionUserCheck($aco,$aro){
	 
	 $user = JFactory::getUser();
	
	  if($aro !== false){
		 $permission = $this->getModel( 'permission' )->table->find('aro_id in('.implode(",",$aro).') and aco_id = '.$aco->id);
		 
	     if($permission && count($permission) == count($aro)){
		    $cid = JFactory::getApplication()->input->get( 'cid', array(), 'request', 'array' );
			
		    if($cid){
		        $rowKey = $cid[0];
				$model = $this->getModel( $aco->controller );
				$table = $model->table;
				
				if($aco->controller == "event" || $aco->controller == "eventmanage") {
				  $events_obj = $table->TableModerator->find('user_id = '.$user->id);
				  $events = array();
				  foreach($events_obj as $evt) {
					 $events[] = $evt->eventId;
				  }
				  $user_condtion = "";
				if(count($events) > 0) {
				$user_condtion = " slabId in(".implode(",",$events).")";
				}
			   } else {
			      $user_condtion = " user_id =".$user->id;
			   }
			   
				$data = $table->find($user_condtion.' and '.$table->getKeyName().' = '.$rowKey);
				
				if($data){
					$return = true;
				}else{
					$return = false;
				}
				//$return = ($data)?true:false;
				
				return ($return);
				
	         }else{
			    return true;	 
			 }
	      }else{
			  
			 return true;  
		  }
		  return true;
	  }
	  
	 return false;
		
        //return ($permission);

  }
  
    function actionCheck($aco,$aro){

	  if($aro !== false){

			$permission = $this->getModel( 'permission' )->table->find('aro_id in('.implode(",",$aro).') and aco_id = '.$aco->id);

			 return ((boolean)$permission);

		}
		return true;
	  
    }
	function auth(){

	   $view = $this->getView('authorize', 'html' );

	   $view->display();

  }

}

?>