<?php

/**
* @version 3.0.11
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/
if(!defined('DS')) {
  define('DS','/');
}
JLoader::register('DtrModeladmin' , JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_dtregister'.DS.'lib'.DS.'dtmodeladmin.php');
JLoader::register('DtrTablenested' , JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_dtregister'.DS.'lib'.DS.'dttable.php');
class DtregisterModelCategory extends DtrModeladmin {

   function __construct($config = array()){

       parent::__construct($config);
       $db = $this->getDBO();
	   $this->table = DtrTable::getInstance('Category','Table'); //new TableCategory($db);

	 }
	 
	public function getForm($data = array(), $loadData = true)
   {
	  
        $form = $this->loadForm('com_dtregister.category', JPATH_SITE.'/administrator/components/com_dtregister/models/forms/category.xml', array('control' => 'jform','load_data' => true) , false);
	 
      return $form;
   }
   
   public function loadFormData() {
	   if(!isset($_GET['id'])) {
	   		return array();
	   }
	    $data = $this->getItem($_GET['id']);
		if($data){
			$obj = new stdClass;
			$obj->categoryId = $data->categoryId;
			$obj->categoryName = $data->categoryName;
			//$obj->ordering = $data->ordering;
			$obj->parent_id = $data->parent_id;
			$obj->color = $data->color;
			$obj->published = $data->published;
			$obj->access = $data->access;
			return $obj;
		}
	   return $data;
	   return $data;
   }

}
class TableCategory extends DtrTablenested{
   var $categoryId=null;

   var $categoryName=null;

   var $parent_id;
   
   var $color = "";
   
   var $published = 0;
   
   var $access = 0;

   function __construct(&$db){

      $this->db = $db;

      parent::__construct( '#__dtregister_categories', 'categoryId', $db );
	  
	  //parent::rebuild();

   }

   function hasChild(){

	$query = "Select count(*) from #__dtregister_categories where parent_id=".$this->categoryId;

	$this->db->setQuery($query);

	return ($this->db->loadResult()>0);

  }

  function orderByParent($rows= array()){

        if(!count($rows)){
           $user = JFactory::getUser();
		   $access_levels = $user->getAuthorisedViewLevels();
		   $rows = $this->find('published = 1 and parent_id > 0 access in( '.implode(',',$access_levels).' )',' lft ');

		}
        $children = array();
	    
		if (count($rows) > 0) {
			foreach ($rows as $v ) {
	
				$pt = $v->parent_id;
	
				$list = @$children[$pt] ? $children[$pt] : array();
	
				array_push( $list, $v );
	
				$children[$pt] = $list;
	
			}
		}
        
		return $children;

  }

  function save($data, $orderingFilter = '', $ignore = ''){
	 if(isset($data['categoryName'])){
		 $data['categoryName'] = stripslashes($data['categoryName']);
	 }
	// Set the new parent id if parent id not matched OR while New/Save as Copy .
	if ($this->parent_id != $data['parent_id'] || $data['categoryId'] == "")
	{
		if($data['parent_id'] == "" || $data['parent_id']== 0) {
		  $data['parent_id'] = $this->getRootId();
		}
		
		$this->setLocation($data['parent_id'], 'last-child');
	}
	pr($data);
     parent::save($data);	  
	 
	 pr($this);
  }

  function optionslist($condition = ' 1=1 ', $ordering = ''){

	   $rows = $this->find(NULL,' lft ');

	   $options=array();
       foreach($rows as $row) {
	   	  $options[$row->categoryId] = str_repeat("-",$row->level).$row->categoryName ;
	   }

		return $options;

  }
  
  function optionslist_filtered(){
	  
	   $user = JFactory::getUser();
	   // $rows = $this->find(NULL,' ordering ');
	   $access_levels = $user->getAuthorisedViewLevels();
	   
	   $rows = $this->find('published = 1 and parent_id > 0 and access in( '.implode(',',$access_levels).' )',' lft ');

	   $options=array();
       foreach($rows as $row) {
	   	  $options[$row->categoryId] = str_repeat("-",$row->level).$row->categoryName ;
	   }
	  
	   return $options;

  }

}

class TableEventcategory extends DtrTable {
	
	var $id;
	var $event_id;
	var $category_id;
	
	 function __construct($db){

      $this->db = $db;

      parent::__construct( '#__dtregister_event_categories', 'id', $db );

   }
   
   function findbyeventId($event_id) {
   		
		$rows = $this->find(' event_id = '.$event_id);
		
		$return = array();
		foreach($rows as $row) {
			$return[] = $row->category_id;
		}
		
	    return $return;
   }
   
    function saveAll($data){

     if(!is_array($data)){

		return;

	 }

	 $catdata = array();

	 foreach($data as $value){

	    $catdata []= array('category_id'=>$value);

	 }

	parent::saveAll($catdata);

  }

	
}