<?php

/**
* @version 3.1.7
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

class DtregisterModelDiscountcode extends DtrModel {

   function __construct($config = array()){

       parent::__construct($config);

	   $this->discountcode = DtrTable::getInstance('Discountcode','Table');  // new TableDiscountcode($this->getDBO());

	   $this->table = $this->discountcode;

	 }

}

class TableDiscountcode extends DtrTable {

    var $id;

	var $name;

	var $label;

	var $publish;

	var $discount_type;

	var $start;

	var $end;

	var $amount;

	var $code;

	var $events_enable;

    var $limit;

	var $fields = array('name','publish','discount_type','start','end','amount','code','limit','events_enable','code_useage_reg','discountcode_group_behave');
	
	var $code_useage_reg = 3; // default individual 
	
	var $discountcode_group_behave = 2; // default billing
	
	var $max;
	
	var $min;

  function __construct( $db = null ) {

    $db = JFactory::getDBO();

    $this->db = $db;

    parent::__construct( '#__dtregister_codes', 'id', $db );

  }

  function set($data=array(),$default = NULL){

		if (count($data) > 0) {
			foreach($data as $key=>$value){
				if(in_array($key,$this->fields)){
					$this->$key = $value;
				}
			}
  		}

	}

	function save($data, $orderingFilter = '', $ignore = ''){

	   parent::save();

	}

	  function enableAllEvents(){
        global $now;
	    $query = " SELECT DISTINCT e.slabId

					FROM #__dtregister_group_event as e

					LEFT JOIN #__dtregister_events_codes as d ON e.slabId = d.event_id

					AND d.discount_code_id = ".$this->id."

					WHERE d.event_id IS NULL and concat(e.dtend,' ',e.dtendtime) >= '". $now->toMySQL(true)."'";

	   $this->db->setQuery($query);		

	   $data = $this->db->loadRowList();
       $eventTable = DtrTable::getInstance('Event','Table');
	   if (count($data) > 0) {
		   foreach($data as $evtid){
			  $value = $evtid[0];
			  $query = "insert #__dtregister_events_codes set event_id =".$value.", discount_code_id =".$this->id;
			  $eventTable->load($value);
			  $eventTable->TableEventdiscountcode->event_id = $value;
			  $eventTable->TableEventdiscountcode->TableEventfeeorder->eventId = $value;
			  $existing_discountcodes = $eventTable->TableEventdiscountcode->TableEventfeeorder->getDiscountcodes();

			   $existing_discountcode_ids = array();
		  
			   if(is_array($existing_discountcodes))
		  
				foreach($existing_discountcodes as $discountcode){
		  
				  $existing_discountcode_ids[] = $discountcode->reference_id;
		  
				}

			  $eventTable->TableEventdiscountcode->TableEventfeeorder->eventId = $value; 
			  $ordering = $eventTable->TableEventdiscountcode->TableEventfeeorder->getNextOrder("eventId = '".$value."' ");
			  
			  if(!in_array($this->id,$existing_discountcode_ids)) {
				 $feeorders[] = array('reference_id'=>$this->id,'type'=>'discountcode','title'=>'','eventId'=>$value,'ordering'=>$ordering);
				 $eventTable->TableEventdiscountcode->TableEventfeeorder->saveAll($feeorders);
				 $feeorders = array();
				
			  }
			  
			  $this->db->setQuery($query);		
			  $this->db->query();		
		   }
	   }

	}

	function get($property, $default = NULL){

		return $this;

	}

	function getcodes($condition=null){

		$query = "select * from #__dtregister_codes";

		if(isset($condition)){

			$query .= " where ".$condition;	

		}

		$this->db->setQuery($query);

		 return $this->db->loadObjectList();

	}

    function check_space($name){

		if(preg_match("/[ ]/", $name)){

			$this->error = "Spaces are not allowed in the field name. Your space has been replaced by a _ character";

			return false;

		}

		return true;

	}

	function validate_name($name){

		if($name==""){

			$this->error = "Name is required";

			return false;

		}

		if(preg_match("/[^a-zA-Z0-9_]/", $name)){

			$this->error = "Field name only allow characters a-z,A-Z,0-9 and '_' character";

			return false;

		}

		return true;	

	}

	function validate_code($code){

		$query = "select * from #__dtregister_codes";

			$query .= " where code='".$code."'";	

		if(isset($this->id)){

			$query .= " and id <> ".$this->id;

		}
       // echo $query;
		
		$this->db->setQuery($query);

		$this->db->query();

		return ($this->db->getNumRows() == 0 );

	}

	function get_discount_amount($amount){

		if($this->discount_type==1){

			if($this->amount < $amount){

				return $this->amount;

			}else{

				return $amount;

			}

		}else{

			$percentage = $this->amount/100;

			return ($amount*$percentage);

		}

	}

	function usedold(){

	   $query = "select sum(1) from 

	   #__dtregister_user a 

	   inner join #__jevents_vevdetail d  on a.eventId=d.evdet_id 

	   inner join  #__dtregister_group b on  a.userId= b.useid 

       inner join #__dtregister_group_event evt  on evt.eventId = d.evdet_id 

 where a.cancel <> 1 and a.discount_code_id=".$this->id." group by discount_code_id ";

	   $this->db->setQuery($query);

       // echo "<br />". $this->db->getQuery();

	   // echo "<br />";

	   $this->uses = $this->db->loadResult();

	   return $this->uses;

	}
    
	function get_dependent_fields($discount_code_id = 0){
		if($discount_code_id == 0 || $discount_code_id == ""){
		   $discount_code_id = $this->id;
		}
	  $query = "SELECT f.id FROM `#__dtregister_fields` f WHERE f.`discount_codes` LIKE '%\"".$discount_code_id."\"%'";
	   //die;
	   $this->db->setQuery($query);
	   
	   $data = $this->db->loadObjectList();
	   
	   if($data){
		  
		   $temp = array();
	      foreach($data as $row){
			 
	          $temp[] = $row->id;
	       }
		   
		   return $temp;
	   }else{
	      return array();
	   }
	   
	}
	
	function used($event_id = null){

	   global $discount_code_use_per_event;
	   $condition = "";
	    if($discount_code_use_per_event == "per_event" && $event_id != "")
	   {
	      $condition = " and eventId = '".$event_id."'";
	   }
	   $this->used_in_archive();
	   $query = "select sum(1) from #__dtregister_user where status <> -1 and discount_code_id=".$this->id." ".$condition."  group by discount_code_id ";
	   
	   $this->db->setQuery($query);

	   $this->uses += $this->db->loadResult();
	  // echo $this->uses ."<br />";
	   $query = "select sum(1) from #__dtregister_user u inner join #__dtregister_group_member m 
		          on u.userId = m.groupUserId where u.status <> -1 and m.discount_code_id=".$this->id." ".$condition."  group by m.discount_code_id ";

	   $this->db->setQuery($query);

	   $this->uses += $this->db->loadResult();
	   // echo $this->uses ."<br />";
        $users = DT_Session::get('register.User');
		//echo "<pre>";
		//print_r( $_SESSION);
	   if($users) {
	     foreach($users as $user) {
		    
			if(isset($user['discount_code_id']) && $user['discount_code_id'] == $this->id) {
			  
			  if($discount_code_use_per_event) {
			    if($user['eventId'] == $event_id) {
				   $this->uses++;
				}
			  } else {
			     $this->uses++;
			  }
			  
			}
			
		 }
	   }
	  // echo  $this->uses ."<br />";
	   return $this->uses;

	}
	
	
	function used_in_archive($event_id = null){

	   global $discount_code_use_per_event;
	   $condition = "";
	    if($discount_code_use_per_event == "per_event" && $event_id != "")
	   {
	      $condition = " and eventId = '".$event_id."'";
	   }
	   $query = "select sum(1) from #__dtregister_user_archive where status <> -1 and discount_code_id=".$this->id." ".$condition."  group by discount_code_id ";
	   
	   $this->db->setQuery($query);

	   $this->uses = $this->db->loadResult();
	  // echo $this->uses ."<br />";
	   $query = "select sum(1) from #__dtregister_user_archive u inner join #__dtregister_group_member_archive m 
		          on u.userId = m.groupUserId where u.status <> -1 and m.discount_code_id=".$this->id." ".$condition."  group by m.discount_code_id ";

	   $this->db->setQuery($query);

	   $this->uses += $this->db->loadResult();
	   
	  // echo  $this->uses ."<br />";
	   return $this->uses;

	}

	function is_expired($date=''){

	     global $now;

		 if($date==""){

		    $date = $now;

		 }

		  $query = "SELECT *

						FROM #__dtregister_codes AS dc

						WHERE (

						dc.id = '".$this->id."'

						AND dc.publish =1

						)

						AND (

							  (

								'".$date->format()."'

								BETWEEN dc.start

								AND dc.end

								AND dc.start <> '0000-00-00 00:00:00'

								AND dc.end <> '0000-00-00 00:00:00'

							  )

							  OR (

								 dc.start = '0000-00-00 00:00:00'

								 and dc.end <> '0000-00-00 00:00:00'

								 and dc.end > '".$date->format()."'

								)

							  Or(

								 dc.start <> '0000-00-00 00:00:00'

								 and dc.end = '0000-00-00 00:00:00'

								 and dc.start < '".$date->format()."'

								)

							  or (

								  dc.start = '0000-00-00 00:00:00'

								   and dc.end = '0000-00-00 00:00:00'

								 )						

						 )";

		   $this->db->setQuery($query);

		   $this->db->query();

           if($this->db->getNumRows() > 0){

				return $this->id;

			 }else{

			    $this->error = JText::_( 'DT_CODE_EXPIRED' );

			    return false;

			 }

	}

}