<?php

/**
* @version 3.0.11
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');
 
jimport('joomla.form.formfield');
include_once(JPATH_SITE."/administrator/components/com_dtregister/lib/dtcommon.php");
include_once(JPATH_SITE."/administrator/components/com_dtregister/lib/defines.php");
include_once(JPATH_SITE."/administrator/components/com_dtregister/models/event.php");
include_once(JPATH_SITE."/administrator/components/com_dtregister/models/category.php");
include_once(JPATH_SITE."/administrator/components/com_dtregister/models/config.php");
include_once(JPATH_SITE."/administrator/components/com_dtregister/helpers/dtregister.php");
// The class name must always be the same as the filename (in camel case)
class JFormFieldeventlist extends JFormField {
	
	protected $type = 'eventlist';
	
	public function getInput() { 
	    
		$category = DtrModel::getInstance('category','DtregisterModel');
		$categoryTable = $category->table;
		$event = DtrModel::getInstance('event','DtregisterModel');
		$eventTable = $event->table;
		$user = JFactory::getUser();
        $access_levels = $user->getAuthorisedViewLevels();
		$multiple = "";
		
		$name = $this->getAttribute('name');
		
		$field_name = $this->name;
        if($name == "dt_events_include" || $name == "dt_events_exclude")
		{
		    $multiple = ' multiple="multiple" ';
			$field_name = $this->name."[]";
		}
 
$where = array();
    $rows = $eventTable->findAllByCategoryTree(null,implode(' and ',array_filter($where))," c.lft asc, b.ordering ASC ");
	$currCat=NULL;

	// Display an event on each row

    $k = 0;

	$prevCat = NUll;
	$parent = $categoryTable;
	$opts = array();
	$old_name = "";
	foreach($rows as $row) {
		$currCat = $row->category;
		if($currCat!=$prevCat || $currCat==""){

			if ($row->category){

				$path_cats = $categoryTable->getPath($row->category);
				$path = array();
				foreach($path_cats as $key => $pcat) {
					if($key == 0) { continue;}
					$path[] = $pcat->categoryName;
				}
				if($old_name != "") {
				   $opts[] = JHtml::_('select.optgroup',$old_name);
			    }
                $opts[] = JHtml::_('select.optgroup', implode(" >> ",$path));
				$old_name = implode(" >> ",$path);
				
			}
            
		}
		$opts[] = JHtml::_('select.option', $row->slabId, $row->title);
        
		$prevCat = $currCat;
	}
	
	return JHtml::_('select.genericlist', $opts, $field_name,$multiple,"value","text",$this->value);
	
	}
	
}
?>