<?php

/**
* @version 3.1.5
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

class DtregisterModelMember extends DtrModel {

   function __construct($config = array()){

       parent::__construct($config);

	   $this->table = DtrTable::getInstance('Member','Table'); // new TableMember($this->getDBO());

	 }

}

class TableMember extends DtrTable {

    var $groupMemberId;

	var $groupUserId;
    
	var $confirmnum;
	
	var $attend;
	
	var $discount_code_id = 0;
	
     function __construct( $db = null ) {

		$db = JFactory::getDBO();

	    $this->displayField = 'title';

		$this->db = $db;

		$this->TableMemberfield = DtrTable::getInstance('Memberfield','Table');

		$this->Tablefield = DtrTable::getInstance('field','Table');
		
		$this->TableDiscountcode = DtrTable::getInstance('Discountcode','Table');

		parent::__construct( '#__dtregister_group_member', 'groupMemberId', $db );

   }
   
   function get_table_fields(){
	 
	   return array('groupMemberId','groupUserId','confirmnum','attend','discount_code_id');
	
   }
   
   function getObjData(){

	   $data = parent::getObjData();

	   unset($data->TableMemberfield);

	   unset($data->Tablefield);

	   return $data;

	}

   function load($id = null, $reset = true){

	   parent::load($id);
        if(intval($this->discount_code_id) > "") {
          $this->TableDiscountcode->load($this->discount_code_id);
	   } else {
	      $this->TableDiscountcode = DtrTable::getInstance('Discountcode','Table');
	   }
	   $this->fields = $this->TableMemberfield->findByMemberId($this->groupMemberId);

   }

   function delete($id = null){
       $tUser = $this->tUser;

	   $tUser->memtot--;

	   $query = "update ". $tUser->getTableName()." set memtot= ".$tUser->memtot." where userId = ".$tUser->userId;

	   $tUser->_db->setQuery($query);

	   $tUser->_db->execute();

	   $fee = $tUser->calculateFee();

	   $fee->paid_amount = $tUser->TableFee->paid_amount;

	   $tUser->TableFee->save((array)$fee);
unset($this->tUser);
	   parent::delete($id);

   }
    
   function save($member, $orderingFilter = '', $ignore = ''){

	   global $now;

	   if(!isset($member['groupUserId'])){

	      $member['groupUserId'] = $this->groupUserId;

	   }

	   if(!isset($member['groupMemberId']) && $this->groupMemberId == ""){

		     $member['created'] = $now->toMySQL(true);

	   }elseif(isset($member['addnew'])){
	      unset($member['groupMemberId']);
		  unset($member['addnew']);
		  unset($this->discount_code_id);
	   }
       $table_flds = $this->get_table_fields();
	   foreach($member as $key=>$value){
		  if($key == 'fields' || $key == 'discount_code_id'){ continue ;}
	     if(!in_array($key,$table_flds)){
		     unset($member[$key]);
		 }
	   }
	   parent::save($member);
       unset($this->discount_code_id);
	   $this->TableMemberfield->member_id = $this->groupMemberId;

	   $this->TableMemberfield->removeBymember($this->groupMemberId);

	   $this->TableMemberfield->saveAll($member['fields']);
     
   }

   function findByUserId($user_id=0){
      
	  if($user_id == "") {
	   	   return false;		
	   }
	  
	  $members = $this->find(" groupUserId = $user_id ");
      
	  $membersdata = array();

	  $temp = array();

	  if (is_array($members)) 
	  foreach($members as $member){

		  //$member = (array)$member;

		  $member->fields = $this->TableMemberfield->findByMemberId($member->groupMemberId);
  
		  if (is_array($member->fields)) 
		  foreach($member->fields as $field_id => $value){

			  $this->Tablefield->load($field_id);

			  if (isset($this->Tablefield->name)) 
			  $member->{$this->Tablefield->name} = $value;	    

		  }

		  $temp[$member->groupMemberId] = $member;

	  }

	  return $temp;

   }

   function contact_custom_fields($member=null){

	    if($member==null){

			$member = $this;

	    }

	    $defaultfields = array('firstname','lastname','zip','city','state','phone','email');

		$contactCustomFields = '';

		if (is_array($member->fields)) 
		foreach($member->fields as $field_id => $dfield){

			 if(is_array($dfield)){

				 $dfield = implode(',',$dfield);

			 }

		     $fld = $this->TableMemberfield->Tablefield->find(' id = '.$field_id);

		   	 $fld = $fld[0];

			 if(!in_array($fld->name,$defaultfields)){

				 $contactCustomFields .= $fld->label.': '.$dfield.'<br />';

			 }

		}

		return $contactCustomFields;

	}

  function removeByuser($id){
       
	   $members = $this->findByUserId($id);
	   
	   if (is_array($members)) 
	   foreach($members as $member){
		     
			 $this->TableMemberfield->removeBymember($member->groupMemberId);
	   }
	   $query = "delete from ".$this->getTableName()." where groupUserId = ".$this->db->Quote($id)." ";

	   $this->db->setQuery($query);

	   $this->db->execute();

  }
  function removeByUserId($id){
	  $this->removeByuser($id);  
  }
  function compare($member){
	   
	   $field = $this->TableMemberfield->TableField;
	    
		if (is_array($member->fields)) 
		foreach($member->fields as $field_id => $value){
		    $field->load($field_id);
			if($field->applychangefee){
				if($value != $this->fields[$field_id]){
				   	return false;
				}
			}
	   }
	   return true;
  }
}

class TableMemberfield extends DtrTable {
	
    var $id;

	var $field_id;

	var $member_id;

	var $value;

     function __construct( $db = null ) {

		$db = JFactory::getDBO();

		$this->db = $db;

		parent::__construct( '#__dtregister_member_field_values', 'id', $db );

		$this->Tablefield = DtrTable::getInstance('Field','Table');

		$this->TableField = $this->Tablefield;

  }

  function removeBymember($member_id){

	  $query = "delete from ".$this->getTableName()." where member_id = ".$this->db->Quote(($this->member_id)?$this->member_id:$member_id)." ";

	   $this->db->setQuery($query);

	   $this->db->execute();

  }

   function saveAll($data=array()){

	  $temp = array();

	  if (is_array($data)) 
	  foreach($data as $key => $value){

		if(is_array($value)){

		   $value = implode("|",$value);

	    }

		$temp[] = array('member_id'=>$this->member_id,'field_id'=>$key,'value'=>stripslashes($value));

	  }

	  parent::saveAll($temp);

  }

   function saveAll_migration($data){
	  parent::saveAll($data);
  }

   function findByMemberId($member_id=0){

	$data = $this->find(" member_id = $member_id  ");  

	$temp = array();

	if (is_array($data)) 
	foreach($data as $field){

		$temp[$field->field_id] = $field->value;

    } 

	return $temp;

  }

}

?>