<?php

/**
* @version 3.1.7
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

class DtregisterModelReminder extends DtrModeladmin { 
	
	function __construct($config = array()){

       parent::__construct($config);

	   $this->table = DtrTable::getInstance('Reminder','DtrTable');  //new DtrTableReminder($this->getDBO());

	 }
}

class DtrTableReminder extends DtrTable{ 
	
	var $id;
	var $message;
	var $timer;
	var $timer_after_reg;
	var $subject;
	var $eventId;
	var $files;
	
	
	function __construct($db){

      $this->db = $db;
      $this->Tablefile = DtrTable::getInstance('File','Table');
	  $this->files = array();
      parent::__construct( '#__dtregister_reminders', 'id', $db );

   }
   
   function load($id = null, $reset = true) {
   		
		parent::load($id);
		if(!is_array($this->files)) {
			$this->files = json_decode($this->files);
		}
		if(!is_array($this->files)) {
			$this->files =array();
		}
		$files = array();
		foreach($this->files as $file_id) {
			
			$this->Tablefile->load($file_id);
		    $files[$file_id] = $this->Tablefile->getProperties();
		}
		
		$this->files = $files;
   }
   
   function save($data, $orderingFilter = '', $ignore = '') {
   		$files = $this->save_files();
		
		$files = json_encode($files);
		$data['files'] = $files;
		
		parent::save($data);
		
   }
   function save_files(){
	  
	 $uploaded_files = array();
	 
     $files = JFactory::getApplication()->input->get('reminder_files', null, 'files', 'array');

		if(!isset($files['name'][1])){

		}else{

			$file = array();

            $dt_file = $this->Tablefile;
            if(count($uploaded_files)) {
				foreach($uploaded_files as $src) { 
					if($dt_file->copy($src)){
						$dt_file->save(array('path'=>$dt_file->path));
					}
				}
			} else {
			  for($i=1;$i<count($files['name']);$i++){
  
				  $file['name'] = $files['name'][$i];
  
				  $file['type'] = $files['type'][$i];
  
				  $file['tmp_name'] = $files['tmp_name'][$i];
  
				  $file['size'] = $files['size'][$i];
  
				  $file['error'] = $files['error'][$i];
  
				  if($dt_file->upload($file)){
  
					  $dt_file->save(array('path'=>$dt_file->path));
					  
					  $uploaded_files[] = $dt_file->id;
  
				  }
				   
				  unset($dt_file->path);
  
				  unset($dt_file->id);
  
			  }
			}

		}
		
      return $uploaded_files;
  }
	
}
?>