<?php

/**
* @version 3.1.7
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class DtregisterControllerOutgoingemail extends DtrController {

   var $name ='outgoingemail';

	function __construct($config = array()){ 
         $config = array('__default'=>'index','default_task'=>'index','task_map'=>array('new'=>'add'));
		 parent::__construct($config);

		 $this->view = $this->getView( 'outgoingemail', 'html' );
		 $this->view->setModel($this->getModel('outgoingemail'),true);
         $this->view->setModel($this->getModel('user'),false);
		 $this->registerTask( 'new', 'add' );
		 $this->registerDefaultTask("index");

		 JToolBarHelper::title(  JText::_( 'DT_Template_MANAGEMENT'), 'dtregister' );

	}
     
	 function content(){
	    
	   @session_write_close();
	   $mainframe = JFactory::getApplication();

       $row = $this->getModel('outgoingemail')->table;

	   $id = JFactory::getApplication()->input->getInt('id',0);
	   
	   $row->load($id);
	   echo $row->content;
	   die;
		
	 }
	 
	function send(){
       @session_write_close();
	   $mainframe = JFactory::getApplication();

       $row = $this->getModel('outgoingemail')->table;

	   $id = JFactory::getApplication()->input->getInt('id',0);
		$row->load($id);
		
		$dt_mail = JFactory::getMailer();
		$dt_mail->addRecipient($row->to);
		$dt_mail->isHTML(true);
		$dt_mail->addReplyTo($row->fromemail, $row->fromname);
		$dt_mail->setSender($row->fromemail, $row->fromname);
		$dt_mail->setSubject($row->subject);
		$dt_mail->setBody($row->content);
		$dt_mail->addAttachment($row->attachment);
		$sent = $dt_mail->Send();
	  
        $row->tries++;
        $row->status = ($sent)?"1":"0";
    if ($row->store() !== null) {
		
    }

    $return = $row->getProperties();
	$return['status_txt'] = $return['status']?JText::_("DT_SENT"):JText::_('DT_FAILED');
	
	$return['script'] = ' DTjQuery("#row_'.$id.' > .col_status").html("'.$return['status'].'"); DTjQuery("#row_'.$id.' > .col_tries").html("'.$row->tries.'"); ';
	$return['message'] = $return['status_txt'];
	ob_clean();
	echo json_encode($return);
    die;
	
	}
  
	function index(){
   
 		JToolBarHelper::deleteList(JText::_( 'DT_DELETE_TEMPLATE'),'delete');

        JToolBarHelper::divider();

        JToolBarHelper::editList('edit', JText::_( 'DT_EDIT') );

	    JToolBarHelper::divider();

        JToolBarHelper::addNew('add',JText::_( 'DT_NEW_TEMPLATE'));

		$this->view->setLayout('list');

	    $this->view->display();

	}

	function add(){

	    JToolBarHelper::cancel('cancel');

        JToolBarHelper::save('save');

		$this->view->setLayout('add');

	    $this->view->display(); 

	}

	function edit(){

	    JToolBarHelper::cancel('cancel');

		JToolBarHelper::title( JText::_( 'DT_TEMPLATE_MANAGEMENT'), 'dtregister' );

        JToolBarHelper::save('save');

	   $this->view->setLayout('edit');

	   $this->view->display();

	}

	
	function delete(){
		
	   $mainframe = JFactory::getApplication();

    $templates = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	$database = JFactory::getDBO();

	$warning = false;

	$message = false;

	if (is_array($templates)) 
	foreach($templates as $template){

		   $message = true;

		   $sql1='DELETE FROM #__dtregister_templates WHERE id=' . $database->Quote( $template );

		   $database->setQuery($sql1);

		   $database->query();

	}

	$msg = "";

	   $msg .= " ".JText::_( 'DT_TEMPLATE_DELETED' );


	$mainframe->redirect("index.php?option=".DTR_COM_COMPONENT."&task=list&controller=template",$msg);

	}
	
	function getTemplate(){
	    
		$id = JFactory::getApplication()->input->getInt('template_id',0);
	    $table = $this->getModel('template')->table;
		$table->load($id);
		
		$data = array('subject'=>$table->name,'content'=>$table->tmpl_content);
		ob_clean();
		echo json_encode($data);
		die;
	}

}