<?php

/**
* @version 3.1.7
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class DtregisterControllerTemplate extends DtrController {

   var $name ='template';

	function __construct($config = array()){ 
         $config = array('__default'=>'index','default_task'=>'index','task_map'=>array('new'=>'add'));
		 parent::__construct($config);

		 $this->view = $this->getView( 'template', 'html' );

		 $this->view->setModel($this->getModel('template'),true);
         $this->view->setModel($this->getModel('user'),false);
		 $this->registerTask( 'new',  'add' );

		 $this->registerDefaultTask("index");

		 JToolBarHelper::title(  JText::_( 'DT_Template_MANAGEMENT'), 'dtregister' );
		
	}

	function index(){
   
 		JToolBarHelper::deleteList(JText::_( 'DT_DELETE_TEMPLATE'),'delete');

        JToolBarHelper::divider();

        JToolBarHelper::editList('edit', JText::_( 'DT_EDIT') );

	    JToolBarHelper::divider();

        JToolBarHelper::addNew('add',JText::_( 'DT_NEW_TEMPLATE'));

		$this->view->setLayout('list');

	    $this->view->display();

	}

	function add(){

	    JToolBarHelper::cancel('cancel');

        JToolBarHelper::save('save');

		$this->view->setLayout('add');

	    $this->view->display(); 

	}

	function edit(){

	    JToolBarHelper::cancel('cancel');

		JToolBarHelper::title(  JText::_( 'DT_TEMPLATE_MANAGEMENT'), 'dtregister' );

        JToolBarHelper::save('save');

	   $this->view->setLayout('edit');

	   $this->view->display();

	}

	function save(){

	   $mainframe = JFactory::getApplication();

       $row = $this->getModel('template')->template;

	   $id = JFactory::getApplication()->input->getInt('id',0);

	   if($id){

	     $row->load($id);

	   }

	
	if (!$row->bind( $_POST )) {

        echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

        exit();

    }

    if (!$row->check()) {

        echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

        exit();

    }

    if ($row->store() !== null) {

		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

        exit();

    }

	$mainframe->redirect( "index.php?option=com_dtregister&controller=template" ,JText::_( 'DT_TEMPLATE_SAVED') );

	}

	function delete(){
		
	   $mainframe = JFactory::getApplication();

    $templates = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	$database = JFactory::getDBO();

	$warning = false;

	$message = false;

	if (is_array($templates)) 
	foreach($templates as $template){

		   $message = true;

		   $sql1='DELETE FROM #__dtregister_templates WHERE id=' . $database->Quote( $template );

		   $database->setQuery($sql1);

		   $database->query();

	}

	$msg = "";

	   $msg .=  " ".JText::_( 'DT_TEMPLATE_DELETED' );

	$mainframe->redirect("index.php?option=".DTR_COM_COMPONENT."&task=list&controller=template",$msg);

	}
	
	function getTemplate(){
	    
		$id = JFactory::getApplication()->input->getInt('template_id',0);
	    $table = $this->getModel('template')->table;
		$table->load($id);
		
		$data = array('subject'=>$table->name,'content'=>$table->tmpl_content);
		ob_clean();
		echo json_encode($data);
		die;
	}

}