<?php

/**
* @version 3.1.5
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class DtregisterControllerUsermanage extends DtrController {

   var $name ='usermanage';

   function __construct($config = array()){

		 parent::__construct($config);

		 $this->view = $this->getView( 'usermanage', 'html' );  

		 $this->view->setModel($this->getModel('user'),true);

		 $this->view->setModel($this->getModel('paymentmethod'));

         $this->view->setModel($this->getModel('event'));

		 $this->registerTask( 'new', 'add' );

		 $this->registerDefaultTask("index");

		 JToolBarHelper::title( JText::_( 'DT_RECORDS'), 'dtregister' );

	}

   function delete(){

	    $mainframe = JFactory::getApplication();

	    $cid = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	    $mUser = $this->getModel( 'user' );

		if (is_array($cid)) 

		foreach($cid as $userId){

			$mUser->table->delete($userId);

		}

	   	$mainframe->redirect( "index.php?option=".DTR_COM_COMPONENT."&controller=usermanage" );

	}

   function resendthkemail(){

	    $mainframe = JFactory::getApplication();

	    $cid = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	    $mUser = $this->getModel( 'user' );

		if (is_array($cid)) 

		foreach($cid as $userId){

			$mUser->table->load($userId);

			$mUser->table->registrantemail();

		}

	   	 $mainframe->redirect( "index.php?option=".DTR_COM_COMPONENT."&controller=usermanage" );

   }

   function order($inc){

       $mainframe = JFactory::getApplication();	

	   $row = $this->getModel('field')->table;

       $cid = JFactory::getApplication()->input->get( 'cid', array(0), 'request', 'array' );

	   $uid = $cid[0];

	   $row->load( (int)$uid );

	   $row->reorder();

	   $row->move( $inc, true );

	   $mainframe->redirect( "index.php?option=".DTR_COM_COMPONENT."&controller=field" );

   }

   function index(){
       $archive = JFactory::getApplication()->input->get('archive',-1);
   	   JToolBarHelper::title( JText::_( 'DT_RECORDS'), 'dtregister' );
//if($archive > 0){
	   JToolBarHelper::addNew('group_registration',JText::_( 'DT_ADD_GROUP'));

       JToolBarHelper::divider();

	   JToolBarHelper::addNew('new',JText::_( 'DT_ADD_INDIVIDUAL'));

       JToolBarHelper::divider();
//}
	   JToolBarHelper::editList('edit',JText::_( 'DT_EDIT'));

	   JToolBarHelper::divider();  

	   JToolBarHelper::deleteList(JText::_("DT_DELETE_USER"),'delete');

	   JToolBarHelper::divider();

	   JToolBarHelper::assign('resendthkemail',JText::_('DT_RESEND_THANKS_EMAIL'));

	   JToolBarHelper::divider();

	   JToolBarHelper::assign('attend',JText::_('DT_ATTENDED'));

	$mainframe = JFactory::getApplication();
	
	$option = DTR_COM_COMPONENT;

	jimport('joomla.html.pagination');

	$listLimit = $mainframe->getCfg( 'list_limit', 10 );

    $limit = intval( $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $listLimit ) );

    $limit = $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );

	$limitstart = intval( $mainframe->getUserStateFromRequest( "viewuser{$option}limitstart", 'limitstart', 0 ) );

	$search = $mainframe->getUserStateFromRequest( 'dtreg_user_search.search', 'search', array(),'array' );

	$filter_order = $mainframe->getUserStateFromRequest( 'dtreg_user_order.filter_order', 'filter_order', 'date' );

	$filter_order_Dir = $mainframe->getUserStateFromRequest( 'dtreg_user_dir.filter_order_Dir', 'filter_order_Dir', 'desc' );

	$where = array();

	$mUser = $this->getModel('user');

	$tUser = $mUser->table;

    $event = $tUser->TableEvent;

	$fieldSelectQuery = $tUser->TableUserfield->pivotFields();

    $query = "Select SQL_CALC_FOUND_ROWS u.*, f.* ,f.status fee_status , u.status user_status , e.title , d.code , e.dtstart , e.slabId  from #__dtregister_user u 

	           left join ".$event->getTableName()." e on u.eventId = e.slabId  

			   left join ".$tUser->TableFee->getTableName()." f on f.user_id = u.userId

			   left join #__dtregister_codes d on d.id = u.discount_code_id 

			   ";

    $Andwhere = array();

    $user = JFactory::getUser();

    $aros = $this->getModel( 'aro' )->table->findaroByUser($user);

   if($aros) {

		foreach($aros as $key => $aro) {

			if($aro == 1){ // public group

			  unset($aros[$key]);

			}

		}

	}

    $aco_id = $this->getModel( 'aco' )->table->getAcoIdbyTypeControllerTask('sessionUser','entity','edit','DT_EDIT_OWN_ITEM');

    $permission = $this->getModel( 'permission' )->table->find('aro_id in('.implode(",",$aros).') and aco_id = '.$aco_id);

    if($permission ){ // && count($permission) == count($aro)

  	  $events_obj = $event->TableModerator->find('user_id = '.$user->id);
				  $events = array(0);
				  foreach($events_obj as $evt) {
					 $events[] = $evt->eventId;
				  }
				  $user_condtion = " slabId in(".implode(",",$events).")";
			 
  	 //$where[]= " a.user_id = ".$user->id;
	 if(count($events) >0) {
	 $Andwhere[] = $user_condtion;
	 }

    }

	if (isset($search['eventId']) && $search['eventId']!="") {

      $Andwhere[] = "e.slabId=".$search['eventId'];

	}

	if (isset($search['fee_status']) &&  $search['fee_status']!="") {

        if($search['fee_status'] == 1){

		   	$Andwhere[] = "f.status=0 and f.payment_method='authorizenet'";

		}else{

			$Andwhere[] = '((f.payment_method  is null || f.payment_method != "authorizenet") || (f.status=1 and f.payment_method="authorizenet"))';

		}

	}

	if (isset($search['attend']) && $search['attend']!="" && $search['attend']!=-1) {

		$Andwhere[] = "u.attend=".$search['attend'];

	}

    if (isset($search['status']) && $search['status']!="") {

		$Andwhere[] = "u.status=".$search['status'];

	}

	 if (isset($search['event_archive']) && $search['event_archive']!="" && $search['event_archive']!=-1) {

		$Andwhere[] = "e.archive=".$search['event_archive'];

	}elseif(!isset($search['event_archive'])|| $search['event_archive'] !=-1 ){

	   	$Andwhere[] = " e.archive= 0";

	}

	$grpByHaving = "";

	if (isset($search['query']) && $search['query']!="") {

		if (get_magic_quotes_gpc()) {

		    $search['query'] = stripslashes( $search['query']);

	    }

        $db = JFactory::getDBO();

		$searchQuery = $db->escape( trim( strtolower( $search['query'] ) ) );

		$searchJoinSql = " inner join ( select distinct if(uf.user_id is Null,us.userId,uf.user_id) as user_id from #__dtregister_user us left join #__dtregister_user_field_values uf on uf.user_id = us.userId  left join #__dtregister_group_member g on g.groupUserId = us.userId left join 

		#__dtregister_member_field_values mf on mf.member_id = g.groupMemberId where uf.value like '%".$searchQuery."%' or us.confirmNum like '%".$searchQuery."%' or mf.value like '%".$searchQuery."%' or g.confirmnum like '%".$searchQuery."%') searchable on u.userId = searchable.user_id ";

		$searchJoinSql = "left join #__dtregister_user_field_values uf ON uf.user_id = u.userId

						  AND (

						  uf.value LIKE '%".$searchQuery."%'

						  OR u.confirmNum LIKE '%".$searchQuery."%'

						  ) left join #__dtregister_group_member g on g.groupUserId = u.userId left join 

		#__dtregister_member_field_values mf on mf.member_id = g.groupMemberId and ( mf.value like '%".$searchQuery."%' or g.confirmnum like '%".$searchQuery."%' )";

		$query .= $searchJoinSql;

         $Orwhere = "(mf.value LIKE '%".$searchQuery."%' OR g.confirmnum LIKE '%".$searchQuery."%'

		            OR

                    uf.value LIKE '%".$searchQuery."%' OR u.confirmnum LIKE '%".$searchQuery."%')";

		$Andwhere[] = $Orwhere;

		if (get_magic_quotes_gpc()) {

		    $search['query'] = stripslashes( $search['query']);

	    }

		$grpByHaving = " having ";

		$grpByHaving .= $mUser->searchQuery('u',$searchQuery);

	}

		$mUser->orderBYPivot($query,$filter_order);

	$where = (count($Andwhere)>0)?" where ".implode(' and ', $Andwhere):'';

	$query .= " $where group by u.userId ";
	
	$query .= $mUser->orderBy($filter_order,$filter_order_Dir);

// pr($query);

    $tUser->rawquery('SET SQL_BIG_SELECTS=1');

	$rows = $tUser->query($query,$limitstart,$limit);

	$total = $tUser->getLastCount();

    $pageNav = new DtPagination( $total, $limitstart, $limit );

    $pageNav->form = "adminForm";

	//$pageNav = new JPagination( $total, $limitstart, $limit );

    $this->view->assign('rows',$rows);

	$this->view->assign('mUser',$mUser);

	$this->view->assign('pageNav',$pageNav);

	$this->view->assign('search',$search);

    $this->view->setLayout('list');

	$this->view->assign('eventId',(isset($search['eventId']))?$search['eventId']:'');

	$this->view->display();

   }

   function add(){

		global $now;
		
		$mainframe = JFactory::getApplication();

		if(isset($_POST['formsubmit'])){

			$data = JFactory::getApplication()->input->get('User',array(),null,'array');

			$data['fields'] = JFactory::getApplication()->input->get('Field',array(),null,'array');

			$eventId = $data['eventId'];
			
			$event = DtrTable::getInstance('Event','Table');

			$event->load($eventId );

			if(isset($data['discount_code']) && $data['discount_code']!=""){	

				$discount_code_id = $event->validate_code($data['discount_code'],NULL,'I',1,'I'); 

				unset($data['discount_code']);

				if($discount_code_id !== false){

					$data['discount_code_id'] = $discount_code_id;

				} else {

					$data['discount_code_id'] = false;

	$this->view->assign('discountCodeError',$event->TableEventdiscountcode->TableDiscountcode->error );

				}

			}

			$TableUser = DtrTable::getInstance('Duser','Table');

			$confirmNum = $TableUser->generateconfirmNum($event);

			$data['confirmNum'] = $confirmNum;

			$data['register_date'] = $now->toMySQL(true);

			$TableUser->create($data);

			$feeObj = new DT_Fee($event,$TableUser);

			$feeObj->getFee(($data['user_id']=="")?false:true);

			$feeObj->setPaidMethod($data['Fee']['payment_method']);

			$feeObj->setPaidAmount($data['Fee']['paid_amount']);

			$feeObj->setPaidStatus($data['Fee']['status']);

			$fee = $feeObj;

			unset($fee->TableEvent);

			unset($fee->TableUser);

			$data['fee'] = (array)$fee;

			if(isset($_POST['sendemail'])){

				$TableUser->sendemail = true; 

			} else {

				$TableUser->sendemail = false;

			}

			if($data['fee']['payment_method'] == 'offline_payment') {

				DT_Session::set('register.payment.offline_process',true);

				DT_Session::set('register.payment.billing', $_POST['billing']);

				DT_Session::set('register.payment.method','offline_payment');

			}

			$TableUser->register($data);

			DT_Session::clear('register.payment.offline_process');

			DT_Session::clear('register.payment.billing');

			DT_Session::clear('register.payment.method');

			$mainframe->redirect("index.php?option=com_dtregister&controller=usermanage&task=index");

		}

		JToolBarHelper::save('add',JText::_( 'DT_SAVE'));

		JToolBarHelper::divider();

		JToolBarHelper::cancel( 'cancel', JText::_( 'DT_CLOSE') );

		$cid = JFactory::getApplication()->input->get('cid',array(),null,'array');

		$mUser = $this->getModel('user');

		$tUser = $mUser->table;

		$tUser->type = 'I';

		$search = JFactory::getApplication()->input->get('search',array(),'get');

		$eventId = $search['eventId'];

		$tUser->TableEvent->load($eventId);

		$type = ($tUser->type=='I')?'I':'B';

		$memtot = ($tUser->type=='I')?1:2;	

		// Check for capacity registration for a particular event		

		$eventTable = $this->getModel('event')->table;

		$eventTable->load($eventId);

		$registered = $eventTable->getTotalregistered($eventId);

		$max_registrations = $eventTable->max_registrations;

		if ($max_registrations > $registered) {

			$availableSpots = $max_registrations - $registered;

		} elseif($max_registrations !=0 ){

		$mainframe->redirect("index.php?option=com_dtregister&controller=usermanage",JText::_('DT_ALERT_FULL_EVENT'));

			exit;

		}

		$this->view->assign( 'form' ,$tUser->TableEvent->form($type,(array)$tUser,false,'adminForm',false, $memtot));

		$this->view->assign('mUser',$mUser);

		$this->view->assign('eventId',$eventId);

		$this->view->assign('type',$type);

		$this->view->assign('memtot',$memtot);

		$this->view->setLayout('add');	

		$this->display();

   }

   function event_full() {

		global $now;
		
		$mainframe = JFactory::getApplication();

		$this->view->setLayout('event_full');		

		$this->display();

   }

   function edit(){
	   
	   $mainframe = JFactory::getApplication();

	   $mUser = $this->getModel('user');

	   $tUser = $mUser->table;

	   if(isset($_POST['formsubmit']) && $_POST['formsubmit']=='edit'){

		    $tUser->load($_POST['User']['userId']);

			$data = $_POST['User'];

			$data['fields'] = JFactory::getApplication()->input->get('Field',array(),null,'array');

			$data['members'] = $tUser->members;

			$data['discount_code_id'] = $tUser->discount_code_id;
             $data['eventId'] = ($data['eventId'] == "")?$tUser->eventId:$data['eventId'];
	        $eventId = $data['eventId'];

	        $event = DtrTable::getInstance('Event','Table');

	        $event->load($eventId );

			if($data['discount_code_id']!=""){

			 $event->loadDiscountCode($data['discount_code_id']);

			}

			if(!isset($data['memtot'])) {

			   $data['memtot'] = 1;

			}

			$TableUser = DtrTable::getInstance('Duser','Table');

	        $TableUser->create($data);

			$feeObj = new DT_Fee($event,$TableUser);

		    $feeObj->getFee(($data['user_id']=="")?false:true);

		    $feeObj->setPaidMethod($data['Fee']['payment_method']);

		    $feeObj->setPaidAmount($data['Fee']['paid_amount']);

			$feeObj->setPaidStatus($data['Fee']['status']);

		    $fee = $feeObj;

			$fee->fee = $_POST['User']['Fee']['fee'];

		    unset($fee->TableEvent);

		    unset($fee->TableUser);

			unset($data['members']);

		    $data['fee'] = (array)$fee;

			$data['fee']['id'] = $tUser->TableFee->id;

			unset($data['discount_code']);

			//prd($data);

			$paid_status_change = false;

		    if($tUser->TableFee->status != $data['Fee']['status']){

				$paid_status_change = true;
				
			}
			
			$status_change = false;

			if($tUser->status != $data['status']){

				$status_change = true;

			}

			if($data['fee']['payment_method'] == 'offline_payment') {

				DT_Session::set('register.payment.offline_process',true);

				DT_Session::set('register.payment.billing', $_POST['billing']);

				DT_Session::set('register.payment.method','offline_payment');

			}

			$TableUser->save($data);

			DT_Session::clear('register.payment.offline_process');

			DT_Session::clear('register.payment.billing');

			DT_Session::clear('register.payment.method');

			$tUser->load($_POST['User']['userId']);

			if($status_change){

				$tUser->status_change_email();

			}

			if($paid_status_change){

     			$tUser->TableFee->status = $data['Fee']['status'];

     			$tUser->fee_status_change_email();

   			}
            $archive_var = JFactory::getApplication()->input->get('archive',false);
			
			if($archive_var>0){
			  $mainframe->redirect("index.php?option=com_dtregister&controller=usermanage&archive=1");
			} else{
			$mainframe->redirect("index.php?option=com_dtregister&controller=usermanage");
			}

			die;

	   }

       JToolBarHelper::save('edit',JText::_( 'DT_SAVE'));

       JToolBarHelper::divider();

       JToolBarHelper::cancel( 'cancel', JText::_( 'DT_CLOSE') );

	   $tUser->load($_REQUEST['cid'][0]);

	   $type = ($tUser->type=='I')?'I':'B';

       //$tUser->TableEvent->load($tUser->eventId);

	   $this->view->assign( 'form' ,$tUser->TableEvent->form($type,(array)$tUser,false,'adminForm',true,$tUser->memtot));

	   $this->view->assign('mUser',$mUser);

	   $this->view->assign('tUser',$tUser); 

	   $this->view->setLayout('edit');

	   $this->view->display();

   }

   function attend(){

	  $mainframe = JFactory::getApplication();

      $mUser = $this->getModel('user');

	  $tUser = $mUser->table;

      foreach($_POST['cid'] as $userId){

		  $query = "update ".$tUser->getTableName()." set attend = 1 where userId=".$userId; 

		  $tUser->rawquery($query); 

	  }
       $archive = JFactory::getApplication()->input->get('archive',-1);
	  
	  $href = "index.php?option=com_dtregister&controller=usermanage" ;
	  
	  if($archive > 0){
		  $href .= "&archive=1";
	  }
	  
	  $mainframe->redirect($href);
	 // $mainframe->redirect("index.php?option=com_dtregister&controller=usermanage");

   }

   function fee_status(){

      $mainframe = JFactory::getApplication();

	  $mUser = $this->getModel('user');

	  $tUser = $mUser->table;

	  $tUser->load($_POST['cid'][0]);

	  $tUser->TableFee->load($tUser->fee->id);

	  $tUser->TableFee->status = 1;

	  $tUser->TableFee->store();

	  $tUser->fee_status_change_email();
      $archive = JFactory::getApplication()->input->get('archive',-1);
	  
	  $href = "index.php?option=com_dtregister&controller=usermanage";
	  
	  if($archive > 0){
		  $href .= "&archive=1";
	  }
	  
	  $mainframe->redirect($href);
	  //$mainframe->redirect("index.php?option=com_dtregister&controller=usermanage");

   }

   function unfee_status(){

	  $mainframe = JFactory::getApplication();

	  $mUser = $this->getModel('user');

	  $tUser = $mUser->table;

	  $tUser->load($_POST['cid'][0]);

	  $tUser->TableFee->load($tUser->fee->id);

	  $tUser->TableFee->status = 0;

	  $tUser->TableFee->store();

	  $tUser->fee_status_change_email();
      $archive = JFactory::getApplication()->input->get('archive',-1);
	  
	  $href = "index.php?option=com_dtregister&controller=usermanage";
	  
	  if($archive){
		  $href .= "&archive=1";
	  }
	  
	  $mainframe->redirect($href);
	  //$mainframe->redirect("index.php?option=com_dtregister&controller=usermanage");

   }

   function unattend(){

	  $mainframe = JFactory::getApplication();
 
      $mUser = $this->getModel('user');

	  $tUser = $mUser->table;

	  $query = "update ".$tUser->getTableName()." set attend = 0 where userId=".$_POST['cid'][0]; 

	  $tUser->rawquery($query);
      $archive = JFactory::getApplication()->input->get('archive',-1);
	  
	  $href = "index.php?option=com_dtregister&controller=usermanage";
	  
	  if($archive > 0){
		  $href .= "&archive=1";
	  }
	  
	  $mainframe->redirect($href);
	 // $mainframe->redirect("index.php?option=com_dtregister&controller=usermanage");

   }

   function billing(){

	   global $member_confirmnum;
	   
	   $mainframe = JFactory::getApplication();

       $memtot = DT_Session::get('register.User.memtot');

	   if(isset($_POST['formsubmit'])){

	   $data = JFactory::getApplication()->input->get('User',array(),null,'array');

	   $data['fields'] = JFactory::getApplication()->input->get('Field',array(),null,'array');

	   $eventId = $data['eventId'];

	   $event = DtrTable::getInstance('Event','Table');

	   $event->load($eventId);

	   if(isset($data['discount_code']) && $data['discount_code']!=""){

			$discount_code_id = $event->validate_code($data['discount_code'],NULL,'B',$memtot,'G'); 

			unset($data['discount_code']);

			if($discount_code_id !== false){

			   $data['discount_code_id'] = $discount_code_id;

			}else{

			   $data['discount_code_id'] = false;

			   $this->view->assign('discountCodeError',$event->TableEventdiscountcode->TableDiscountcode->error );

			}	

		}

	   $data = array_merge(DT_Session::get('register.User'),array_filter($data));

       $TableUser = DtrTable::getInstance('Duser','Table');

	   $TableUser->create($data);

	   $feeObj = new DT_Fee($event,$TableUser);

	   $feeObj->getFee(($data['user_id']=="")?false:true);

       $feeObj->setPaidMethod($data['Fee']['payment_method']);

	   $feeObj->setPaidAmount($data['Fee']['paid_amount']);

	   $feeObj->setPaidStatus($data['Fee']['status']);

	   $fee = $feeObj;

       unset($fee->TableEvent);

	   unset($fee->TableUser);

	   $data['fee'] = (array)$fee;

	   //$confirmNum = $TableUser->generateconfirmNum();

	   //$data['confirmNum'] = $confirmNum;

	    if($member_confirmnum){

			   $members = $data['members'];

			   $i = 1;

			   if($members)

			   foreach($members as $key => $member){

				  $confirmnum = $TableUser->generateconfirmNum($event);

				  $data['members'][$key]['confirmnum'] = $confirmnum;

				   if($i == 1) {

					  $data['confirmNum'] = $confirmnum;

				   }

				   $i++;

			   }

		   } else {

			      $confirmNum = $TableUser->generateconfirmNum($event);

				  $data['confirmNum'] = $confirmNum;

		   }

       if(isset($_POST['sendemail'])){

				$TableUser->sendemail = true; 

			} else {

				$TableUser->sendemail = false;

			}

		if($data['fee']['payment_method'] == 'offline_payment') {

				DT_Session::set('register.payment.offline_process',true);

				DT_Session::set('register.payment.billing', $_POST['billing']);

			}

	   $TableUser->register($data);

       DT_Session::clear('register');

	   $mainframe->redirect("index.php?option=com_dtregister&controller=usermanage&task=index");

	   }

	   JToolBarHelper::save('billing',JText::_( 'DT_SAVE'));

	   $mUser = $this->getModel('user');

	   $tUser = $mUser->table;

	   $eventId = DT_Session::get('register.User.eventId');

	   $tUser->TableEvent->load($eventId);

	   $this->view->assign( 'form' ,$tUser->TableEvent->form('B',array(),false,'adminForm',false,$memtot));

	   $this->view->assign('mUser',$mUser);

	   $this->view->assign('eventId',$eventId);

	   $this->view->assign('type','G');

	   $this->view->assign('memtot',$memtot);

	   $this->view->setLayout('add');

	   $this->view->display();

   }

   function member(){

	   $mainframe = JFactory::getApplication();

       $eventId = DT_Session::get('register.User.eventId');

	   $event = $this->getModel('event')->table;

	   $event->load($eventId);

	   if(isset($_POST['formsubmit'])){

		   $data['fields'] = JFactory::getApplication()->input->get('Field',array(),null,'array'); 

	   $memtot = DT_Session::get('register.User.memtot');

	   $data['discount_code'] = $_POST['discount_code'];

	   if(isset($data['discount_code']) && $data['discount_code']!=""){

			$discount_code_id = $event->validate_code($data['discount_code'],NULL,'M',$memtot,'G'); 

			unset($data['discount_code']);

			if($discount_code_id !== false){

			   $data['discount_code_id'] = $discount_code_id;

			}else{

			   $data['discount_code_id'] = false;
			   $this->view->assign('discountCodeError',$event->TableEventdiscountcode->TableDiscountcode->error );

			}	

		}

		   $memberIndex = count(array_filter((array)DT_Session::get('register.User.members'))); // count(DT_Session::get('register.User.members'));

		   DT_Session::set('register.User.members.'.$memberIndex , $data);

		   $memtot = DT_Session::get('register.User.memtot');

		   $currentCount = count(array_filter((array)DT_Session::get('register.User.members'))); // count(DT_Session::get('register.User.members'));

		   if($memtot <= $currentCount){

 $mainframe->redirect("index.php?option=com_dtregister&controller=usermanage&task=billing");

		   }else{

				$mainframe->redirect("index.php?option=com_dtregister&controller=usermanage&task=member");

		   }

	   }else{

	   }

	   JToolBarHelper::save('member',JText::_( 'DT_NEXT_STEP'));

	   $currentCount = count(array_filter((array)DT_Session::get('register.User.members'))); // count(DT_Session::get('register.User.members'));

	   $this->view->assign('currentMember',++$currentCount);

       $memtot = DT_Session::get('register.User.memtot');

	   $this->view->assign( 'form',$event->form('M',array(),false,'adminForm',false,$memtot));

	   $this->view->setLayout('memberadd');

	   $this->view->display();

   }

   function group_registration(){
	   
	   $mainframe = JFactory::getApplication();

	   if(isset($_POST['formsubmit'])){

		     DT_Session::set('register.User.memtot', JFactory::getApplication()->input->get('memtot',1) );

			 $eventId = DT_Session::get('register.User.eventId');

	   		 $event = $this->getModel('event')->table;

	         $event->load($eventId);

			 if($event->group_registration_type !="detail"){
 	$mainframe->redirect("index.php?option=com_dtregister&controller=usermanage&task=billing");

			 }else{

 $mainframe->redirect("index.php?option=com_dtregister&controller=usermanage&task=member");

			 }

			 //prd($_SESSION);

	   }else{

          DT_Session::clear('register');

		  $search = JFactory::getApplication()->input->get('search', array(), 'request', 'array');

	      $eventId = $search['eventId'];

		  DT_Session::set('register.User.type', 'G' );

		  DT_Session::set('register.User.eventId', $eventId );

		  DT_Session::set('register.User.members', array() );

	   }

		// Check for capacity registration for a particular event		

		$eventTable = $this->getModel('event')->table;

		$eventTable->load($eventId);

		$registered = $eventTable->getTotalregistered($eventId);

		$max_registrations = $eventTable->max_registrations;

		if ($max_registrations > $registered) {

			$availableSpots = $max_registrations - $registered;

		} elseif($max_registrations !=0 ){

			$mainframe->redirect("index.php?option=com_dtregister&controller=usermanage",JText::_('DT_ALERT_FULL_EVENT'));

			exit;

		}

	   JToolBarHelper::save('group_registration',JText::_( 'DT_NEXT_STEP'));

	   $this->view->assign('eventId',$eventId);

	   $this->view->setLayout('memtotform');

	   $this->view->display();   

   }

   function loadprofile(){

	   $muser = $this->getModel('user');

	   $tuser = $muser->table;

	   $profile = $tuser->TableJUser;

	   $user_id = JFactory::getApplication()->input->get('id',0);

	   $userdata = $profile->getProfile($user_id);

       ob_clean();

	   echo json_encode($userdata);

	   die;   

   }

   function options(){

       $this->view->setLayout('options');

	   $this->view->display();

   }

}

?>