<?php

/**
* @version 3.1.7
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/
//set_error_handler("errorHandler4");
//register_shutdown_function("shutdownHandler4");

function errorHandler4($error_level, $error_message, $error_file, $error_line, $error_context)
{
$error = "lvl: " . $error_level . " | msg:" . $error_message . " | file:" . $error_file . " | ln:" . $error_line;
switch ($error_level) {
    case E_ERROR:
    case E_CORE_ERROR:
    case E_COMPILE_ERROR:
    case E_PARSE:
        log5($error, "fatal");
        break;
    case E_USER_ERROR:
    case E_RECOVERABLE_ERROR:
        log5($error, "error");
        break;
    case E_WARNING:
    case E_CORE_WARNING:
    case E_COMPILE_WARNING:
    case E_USER_WARNING:
        log5($error, "warn");
        break;
    case E_NOTICE:
    case E_USER_NOTICE:
        log5($error, "info");
        break;
    case E_STRICT:
        log5($error, "debug");
        break;
    default:
        log5($error, "warn");
}
}

function shutdownHandler4() //will be called when php script ends.
{
$lasterror = error_get_last();
switch ($lasterror['type'])
{
    case E_ERROR:
    case E_CORE_ERROR:
    case E_COMPILE_ERROR:
    case E_USER_ERROR:
    case E_RECOVERABLE_ERROR:
    case E_CORE_WARNING:
    case E_COMPILE_WARNING:
    case E_PARSE:
        $error = "[SHUTDOWN] lvl:" . $lasterror['type'] . " | msg:" . $lasterror['message'] . " | file:" . $lasterror['file'] . " | ln:" . $lasterror['line'];
        log5($error, "fatal");
}
}

function log5($error, $errlvl)
{
  echo "<br/>".$error;
}
header('Content-Type: text/html; charset=utf-8');
defined('DS') or define('DS', DIRECTORY_SEPARATOR);
$mainframe = JFactory::getApplication();
defined( 'JPATH_BASE' ) or die( 'Direct Access to this location is not allowed.' );
if (!defined("DT_COM_COMPONENT")){

	define("DT_COM_COMPONENT","com_dtregister");

	define("DT_COMPONENT",str_replace("com_","",DT_COM_COMPONENT));

}

if(isset($_REQUEST['cdcaptcha']) && $_REQUEST['cdcaptcha']== 'getScript'){
		
		exit;
}
$db = JFactory::getDbo();
$query = "SET session SQL_BIG_SELECTS = 1";
//$query = "FLUSH Tables;";
$db->setQuery($query);
$db->query();
include_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'lib'.DS.'defines.php');

require_once JPATH_BASE.'/components/com_content/helpers/route.php';
require_once (JPATH_ADMINISTRATOR.DS.'includes'.DS.'toolbar.php'); 

if($controller = JRequest::getWord('controller','event')) {

	$path = JPATH_COMPONENT.DS.'controllers'.DS.$controller.'.php';

	if (file_exists($path)) {

		require_once $path;

	} else {

	    $controller = 'event';

	    $path = JPATH_COMPONENT.DS.'controllers'.DS.$controller.'.php';

		require_once $path;

	}

}
//DT_Session::clearAll();
$classname= ucfirst(DT_COMPONENT)."Controller".ucfirst($controller);
$task = JFactory::getApplication()->input->get('task' );
$cart = JFactory::getApplication()->input->get('cart','');
$controllerObj = new $classname();

global $registrant_list;
$registrant_list++;
// Perform the Request task
$controllerObj->execute( JRequest::getVar( 'task' ) );

// Redirect if set by the controller

$controllerObj->redirect();
if(isset($_REQUEST['clear'])) {
   DT_Session::clearAll();
  
}
//sleep_till_session_written();
//exit();
if(!(isset($_REQUEST['tmpl']) || isset($_REQUEST['no_html']) || isset($_REQUEST['format']))){
	$session = JFactory::getSession();
	$data = $session->getData();
	   // pr("count ==> ".count(DT_Session::get('register.User')));
	   //DT_Session::clearAll('');
	   // pr($_SESSION['__dtregister']['DTH']);
	//echo "<pre>";
	  // print_r($data);
	   //print_r(get_class_methods($data));
	 //echo "</pre>";
}
?>