<?php

/**
 * @version 3.0.11
 * @package Joomla 3.x
 * @subpackage DT Register
 * @copyright Copyright (C) 2006 DTH Development
 * @copyright contact dthdev@dthdevelopment.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

defined ( '_JEXEC' ) or die ( 'Direct Access to this location is not allowed.' );

// Defines filter types used for a parameter in the cleanInput() function.
Define ( "CLEAN_INPUT_FILTER_ALPHABETIC", "alpha" );
Define ( "CLEAN_INPUT_FILTER_ALPHABETIC_AND_ACCENTED", "alpha and accented" );
Define ( "CLEAN_INPUT_FILTER_ALPHANUMERIC", "alphaNumeric" );
Define ( "CLEAN_INPUT_FILTER_ALPHANUMERIC_AND_ACCENTED", "alphaNumeric and accented" );
Define ( "CLEAN_INPUT_FILTER_NUMERIC", "numeric" );
Define ( "CLEAN_INPUT_FILTER_TEXT", "text" );
Define ( "CLEAN_INPUT_FILTER_WIDEST_ALLOWABLE_CHARACTER_RANGE", "text" );

Define ( "FIELD_VALID", "valid" );
Define ( "FIELD_INVALID", "invalid" );
Define ( "FIELD_INVALID_BAD_CHARACTERS", "bad characters" );
Define ( "FIELD_INVALID_BAD_FORMAT", "bad format" );
Define ( "FIELD_INVALID_MAXIMUM_LENGTH_EXCEEDED", "maximum exceeded" );
Define ( "FIELD_INVALID_MINIMUM_LENGTH_NOT_MET", "minimum not met" );
Define ( "FIELD_INVALID_REQUIRED_INPUT_VALUE_MISSING", "missing required value" );
Define ( "FIELD_INVALID_REQUIRED_INPUT_VALUE_NOT_SELECTED", "required value not selected" );

require_once (JPATH_SITE . '/components/com_dtregister/lib/payment/sofort/sofortLibSofortueberweisung.inc.php');
require_once(JPATH_SITE.'/components/com_dtregister/lib/payment/sofort/core/sofortLibNotification.inc.php');
require_once(JPATH_SITE.'/components/com_dtregister/lib/payment/sofort/core/sofortLibTransactionData.inc.php');
require_once( JPATH_SITE.'/components/com_dtregister/lib/class.payment.php');
class sofort extends Payment {
	var $last_error; // holds the last error encountered
	var $ipn_log; // bool: log IPN results to text file?
	var $ipn_log_file; // filename of the IPN log
	var $ipn_data = array (); // array contains the POST values for IPN
	var $fields = array (); // array holds the fields to submit to Sagepay
	
	var $bywebservice = false;
	
	function __construct() {
		global $config_id,$sender_account_id,$countrycode,$reason,$amount, $Itemid;
		// initialization constructor. Called when class is created.
		
		parent::__construct ();

		}
	
	function process() {
        global $sofort_config_id,$currency_code,$sofort_project_id;
		
		$app = JFactory::getApplication();
		
		$acount_name=$this->firstname.' '.$this->lastname;
        $session_id = $this->saveSession();
//echo $sofort_config_id;die;
        $mosConfig_live_site = JUri::root( false );
		$successUrl = $mosConfig_live_site."components/com_dtregister/success.php?return=$session_id&amp;x_cust_id=$session_id&amp;task=restore";
		$cancelUrl = $mosConfig_live_site."components/com_dtregister/success.php?return=$session_id&amp;x_cust_id=$session_id&amp;task=cancel";
     //  var_dump($this);die;
		//echo number_format($this->cart->getAmount() , 2, '.', '');die;
         $Sofortueberweisung = new Sofortueberweisung($sofort_config_id);
         //$Sofoofortueberweisung->setAmount(number_format($this->cart->getAmount() , 2, '.', ''));
         $Sofortueberweisung->setAmount(number_format($this->cart->getAmount() , 2, '.', ''));
		 $Sofortueberweisung->setCurrencyCode('EUR');
		//$Sofortueberweisung->setSenderAccount($this->bankcode, $this->address, $sofort_account_name);
		//$Sofortueberweisung->setSenderCountryCode('DE');
		//$Sofortueberweisung->setSenderIban($this->iban);
		$Sofortueberweisung->setReason($this->description, '');
		$Sofortueberweisung->setSuccessUrl($successUrl, true);
		$Sofortueberweisung->setAbortUrl($cancelUrl);
		$Sofortueberweisung->setEmailCustomer($this->email);
		//$Sofortueberweisung->setProjectId($sofort_project_id);
		$Sofortueberweisung->setTimeout('100000000');
		$Sofortueberweisung->setCustomerprotection(true);

		$Sofortueberweisung->sendRequest();
        $transactionid =$Sofortueberweisung->getTransactionId();
        
        $process = DT_Session::get ( 'Setting.process' );
		DT_Session::clear ( $process . '.payment.transactionId');
		DT_Session::set ( $process . '.payment.transactionId', $transactionid );

		$this->update_session($session_id);
		
		//$this->saveTransactionID($session_id, $transactionid);
		
		if($Sofortueberweisung->isError()) {
			//PNAG-API didn't accept the data
			echo $Sofortueberweisung->getError();
		} else {
			//buyer must be redirected to $paymentUrl else payment cannot be successfully completed!
			$paymentUrl = $Sofortueberweisung->getPaymentUrl();
			//$paymentUrl = 'https://www.sofort.com/payment/users/login';
			//header('Location: '.$paymentUrl);
			//$app->redirect($paymentUrl);
			$this->redirect_to_gateway(base64_encode($paymentUrl));
		}
	}
	
	function redirect_to_gateway($url) {
		$paymentURL = base64_decode($url);
		echo "<center><h3>".JText::_( 'DT_SOFORT_REDIRECT_MSG')."</h3></center>\n";
	?>
		<script language="javascript">
			function redirect_to_sofort(){
				window.location = "<?php echo $paymentURL?>";
			}
			setTimeout("redirect_to_sofort()",5000);
		</script>
	<?php
	}

	function success() {
		global $sofort_project_id,$Itemid,$sofort_config_id;
	       
		$SofortLibTransactionData = new SofortLibTransactionData($sofort_config_id);

		$app = JFactory::getApplication();
		$session_id = $app->input->get('return');
		//$transactionid = $this->getTransactionID($session_id);

		$process = DT_Session::get ( 'Setting.process' );
		$transactionid=DT_Session::get($process . '.payment.transactionId');
		
		$SofortLibTransactionData->addTransaction($transactionid);

		$SofortLibTransactionData->sendRequest();
		$sofort_data=$SofortLibTransactionData->getRawResponse();

		$status=$SofortLibTransactionData->getStatus();
		$statusReason=$SofortLibTransactionData->getStatusReason();
		$mainframe = JFactory::getApplication ();
		//$strStatus = $values ['Status'];
		//echo	$status;die;
	
		if ($status == "received" && $statusReason=='not_credited_yet') {
			$this->transactionId = $transactionid;
			$process = DT_Session::get ( 'Setting.process' );
			DT_Session::set ( $process . '.payment.transactionId', $transactionid );
			$this->log_ipn_results ( true );
			return true;
		} else if ($status == "loss" && $statusReason=='not_credited')
			$this->last_error = "The money has not been received.";
		else if ($status == "pending" && $statusReason=="not_credited_yet")
			{
			$msg = "The money has not yet been received.";
			$mainframe->enqueueMessage($msg,'error');
			
			$this->transactionId = $transactionid;
			$process = DT_Session::get ( 'Setting.process' );
			DT_Session::set ( $process . '.payment.transactionId', $transactionid );
			$this->log_ipn_results ( true );
			return true;
			}
		else if ($status == "received" &&$statusReason=='partially_credited')
		{
			$msg = "The money has been partially received.";
			$mainframe->enqueueMessage($msg,'error');
			$this->transactionId = $transactionid;
			$process = DT_Session::get ( 'Setting.process' );
			DT_Session::set ( $process . '.payment.transactionId', $transactionid );
			$this->log_ipn_results ( true );
			return true;
			
		}
		else if ($status == "received" && $statusReason == "overpayment")
		{
			$msg = "A higher amount of money than transmitted in the call has been transferred.";
			$mainframe->enqueueMessage($msg,'error');
			$this->transactionId = $transactionid;
			$process = DT_Session::get ( 'Setting.process' );
			DT_Session::set ( $process . '.payment.transactionId', $transactionid );
			$this->log_ipn_results ( true );
			return true;
		}
		else if ($status == "refunded" && $statusReason='compensation')
			$this->last_error = "The money has been refunded (partial chargeback).";
		else if ($status == "refunded" && $statusReason=='refunded')
			$this->last_error = "The money has been refunded (complete chargeback of total amount).";
		else
			$this->last_error = "The transaction process failed. Please contact us with the date and time of your order and we will investigate.";
		
		if ($this->last_error) {
			$baseurl = str_replace ( 'components/com_dtregister/', '', Juri::base () );
			$mainframe = JFactory::getApplication ();
			
			$this->log_ipn_results ( true );
			$mainframe->redirect ( $baseurl . "index.php?option=com_dtregister&controller=payment&task=cancel&Itemid=$Itemid", $this->last_error );
			return false;
		}
	}
	function log_ipn_results($success) {
		
		// if (!$this->ipn_log) return; // is logging turned off?
		// Timestamp
		$text = '[' . date ( 'm/d/Y g:i A' ) . '] - ';
		
		// Success or failure being logged?
		
		if ($success)
			$text .= "SUCCESS!\n";
		
		else
			$text .= 'FAIL: ' . $this->last_error . "\n";
			
			// Log the POST variables
		
		$text .= "POST Vars from Sagepay:\n";
		
		foreach ( $this->ipn_data as $key => $value ) {
			
			$text .= "$key=$value, ";
		}
		
		// Write to log
		
		$fp = fopen ( $this->ipn_log_file, 'a' );
		
		fwrite ( $fp, $text . "\n\n" );
		
		fwrite ( $fp, var_export ( $_SESSION, true ) . "\n\n" );
		
		fclose ( $fp ); // close file
	}
	function dump_fields() {
		echo "<h3>sagepay_class->dump_fields() Output:</h3>";
		
		echo "<table width=\"95%\" border=\"1\" cellpadding=\"2\" cellspacing=\"0\">

            <tr>

               <td bgcolor=\"black\"><b><font color=\"white\">Field Name</font></b></td>

               <td bgcolor=\"black\"><b><font color=\"white\">Value</font></b></td>

            </tr>";
		
		ksort ( $this->fields );
		
		foreach ( $this->fields as $key => $value ) {
			
			echo "<tr><td>$key</td><td>" . urldecode ( $value ) . "&nbsp;</td></tr>";
		}
		
		echo "</table><br>";
	}
	function notify() {
		if ($this->validate_ipn ()) {
			$this->transactionId = $_REQUEST ['TxAuthNo'];
			$process = DT_Session::get ( 'Setting.process' );
			DT_Session::set ( $process . '.payment.transactionId', $this->transactionId );
			return true;
		} else {
			// pr($this->validate_ipn());
			return false;
		}
	}
	
	/*
	 * The getToken function. ** * NOTE: A function of convenience that extracts the value from the "name=value&name2=value2..." reply string ** * Works even if one of the values is a URL containing the & or = signs.
	 */
	function getToken($thisString) {
		
		// List the possible tokens
		$Tokens = array (
				"Status",
				"StatusDetail",
				"VendorTxCode",
				"VPSTxId",
				"TxAuthNo",
				"Amount",
				"AVSCV2",
				"AddressResult",
				"PostCodeResult",
				"CV2Result",
				"GiftAid",
				"3DSecureStatus",
				"CAVV",
				"AddressStatus",
				"CardType",
				"Last4Digits",
				"PayerStatus" 
		);
		
		// Initialise arrays
		$output = array ();
		$resultArray = array ();
		
		// Get the next token in the sequence
		for($i = count ( $Tokens ) - 1; $i >= 0; $i --) {
			// Find the position in the string
			$start = strpos ( $thisString, $Tokens [$i] );
			// If it's present
			if ($start !== false) {
				// Record position and token name
				$resultArray [$i]->start = $start;
				$resultArray [$i]->token = $Tokens [$i];
			}
		}
		
		// Sort in order of position
		sort ( $resultArray );
		// Go through the result array, getting the token values
		for($i = 0; $i < count ( $resultArray ); $i ++) {
			// Get the start point of the value
			$valueStart = $resultArray [$i]->start + strlen ( $resultArray [$i]->token ) + 1;
			// Get the length of the value
			if ($i == (count ( $resultArray ) - 1)) {
				$output [$resultArray [$i]->token] = substr ( $thisString, $valueStart );
			} else {
				$valueLength = $resultArray [$i + 1]->start - $resultArray [$i]->start - strlen ( $resultArray [$i]->token ) - 2;
				$output [$resultArray [$i]->token] = substr ( $thisString, $valueStart, $valueLength );
			}
		}
		
		// Return the ouput array
		return $output;
	}
	
	// Filters unwanted characters out of an input string based on type. Useful for tidying up FORM field inputs
	// Parameter strRawText is a value to clean.
	// Parameter filterType is a value from one of the CLEAN_INPUT_FILTER_ constants.
	function cleanInput($strRawText, $filterType) {
		$strAllowableChars = "";
		$blnAllowAccentedChars = FALSE;
		$strCleaned = "";
		$filterType = strtolower ( $filterType ); // ensures filterType matches constant values
		
		if ($filterType == CLEAN_INPUT_FILTER_TEXT) {
			$strAllowableChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 .,'/\\{}@():?-_&£$=%~*+\"\n\r";
			$strCleaned = $this->cleanInput2 ( $strRawText, $strAllowableChars, TRUE );
		} elseif ($filterType == CLEAN_INPUT_FILTER_NUMERIC) {
			$strAllowableChars = "0123456789 .,";
			$strCleaned = $this->cleanInput2 ( $strRawText, $strAllowableChars, FALSE );
		} elseif ($filterType == CLEAN_INPUT_FILTER_ALPHABETIC || $filterType == CLEAN_INPUT_FILTER_ALPHABETIC_AND_ACCENTED) {
			$strAllowableChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz";
			if ($filterType == CLEAN_INPUT_FILTER_ALPHABETIC_AND_ACCENTED)
				$blnAllowAccentedChars = TRUE;
			$strCleaned = $this->cleanInput2 ( $strRawText, $strAllowableChars, $blnAllowAccentedChars );
		} elseif ($filterType == CLEAN_INPUT_FILTER_ALPHANUMERIC || $filterType == CLEAN_INPUT_FILTER_ALPHANUMERIC_AND_ACCENTED) {
			$strAllowableChars = "0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
			if ($filterType == CLEAN_INPUT_FILTER_ALPHANUMERIC_AND_ACCENTED)
				$blnAllowAccentedChars = TRUE;
			$strCleaned = $this->cleanInput2 ( $strRawText, $strAllowableChars, $blnAllowAccentedChars );
		} else { // Widest Allowable Character Range
			$strAllowableChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 .,'/\\{}@():?-_&£$=%~*+\"\n\r";
			$strCleaned = $this->cleanInput2 ( $strRawText, $strAllowableChars, TRUE );
		}
		
		return $strCleaned;
	}
	
	// Filters unwanted characters out of an input string based on an allowable character set. Useful for tidying up FORM field inputs
	// Parameter strRawText is a value to clean.
	// Parameter "strAllowableChars" is a string of characters allowable in "strRawText" if its to be deemed valid.
	// Parameter "blnAllowAccentedChars" accepts a boolean value which determines if "strRawText" can contain Accented or High-order characters.
	function cleanInput2($strRawText, $strAllowableChars, $blnAllowAccentedChars) {
		$iCharPos = 0;
		$chrThisChar = "";
		$strCleanedText = "";
		
		// Compare each character based on list of acceptable characters
		while ( $iCharPos < strlen ( $strRawText ) ) {
			// Only include valid characters **
			$chrThisChar = substr ( $strRawText, $iCharPos, 1 );
			if (strpos ( $strAllowableChars, $chrThisChar ) !== FALSE) {
				$strCleanedText = $strCleanedText . $chrThisChar;
			} elseIf ($blnAllowAccentedChars == TRUE) {
				// Allow accented characters and most high order bit chars which are harmless **
				if (ord ( $chrThisChar ) >= 191) {
					$strCleanedText = $strCleanedText . $chrThisChar;
				}
			}
			
			$iCharPos = $iCharPos + 1;
		}
		
		return $strCleanedText;
	}
	
	/*
	 * Base 64 Encoding function ** * PHP does it natively but just for consistency and ease of maintenance, let's declare our own function *
	 */
	function base64Encode($plain) {
		// Initialise output variable
		$output = "";
		
		// Do encoding
		$output = base64_encode ( $plain );
		
		// Return the result
		return $output;
	}
	
	/*
	 * Base 64 decoding function ** * PHP does it natively but just for consistency and ease of maintenance, let's declare our own function *
	 */
	function base64Decode($scrambled) {
		// Initialise output variable
		$output = "";
		
		// Fix plus to space conversion issue
		$scrambled = str_replace ( " ", "+", $scrambled );
		
		// Do encoding
		$output = base64_decode ( $scrambled );
		
		// Return the result
		return $output;
	}
	
	/*
	 * The SimpleXor encryption algorithm ** * NOTE: This is a placeholder really. Future releases of Form will use AES or TwoFish. Proper encryption ** * This simple function and the Base64 will deter script kiddies and prevent the "View Source" type tampering ** * It won't stop a half decent hacker though, but the most they could do is change the amount field to something ** * else, so provided the vendor checks the reports and compares amounts, there is no harm done. It's still ** * more secure than the other PSPs who don't both encrypting their forms at all
	 */
	function simpleXor($InString, $Key) {
		// Initialise key array
		$KeyList = array ();
		// Initialise out variable
		$output = "";
		
		// Convert $Key into array of ASCII values
		for($i = 0; $i < strlen ( $Key ); $i ++) {
			$KeyList [$i] = ord ( substr ( $Key, $i, 1 ) );
		}
		
		// Step through string a character at a time
		for($i = 0; $i < strlen ( $InString ); $i ++) {
			// Get ASCII code from string, get ASCII code from key (loop through with MOD), XOR the two, get the character from the result
			// % is MOD (modulus), ^ is XOR
			$output .= chr ( ord ( substr ( $InString, $i, 1 ) ) ^ ($KeyList [$i % strlen ( $Key )]) );
		}
		
		// Return the result
		return $output;
	}
	
	// ** Wrapper function do encrypt an encode based on strEncryptionType setting **
	function encryptAndEncode($strIn, $strEncryptionType, $strEncryptionPassword) {
		if ($strEncryptionType == "XOR") {
			// ** XOR encryption with Base64 encoding **
			return $this->base64Encode ( $this->simpleXor ( $strIn, $strEncryptionPassword ) );
		} else {
			// ** AES encryption, CBC blocking with PKCS5 padding then HEX encoding - DEFAULT **
			// ** use initialization vector (IV) set from $strEncryptionPassword
			$strIV = $strEncryptionPassword;
			
			// ** add PKCS5 padding to the text to be encypted
			$strIn = $this->addPKCS5Padding ( $strIn );
			
			// ** perform encryption with PHP's MCRYPT module
			$strCrypt = mcrypt_encrypt ( MCRYPT_RIJNDAEL_128, $strEncryptionPassword, $strIn, MCRYPT_MODE_CBC, $strIV );
			
			// ** perform hex encoding and return
			return "@" . bin2hex ( $strCrypt );
		}
	}
	
	// ** Wrapper function do decode then decrypt based on header of the encrypted field **
	function decodeAndDecrypt($strIn, $strEncryptionPassword) {
		if (substr ( $strIn, 0, 1 ) == "@") {
			// ** HEX decoding then AES decryption, CBC blocking with PKCS5 padding - DEFAULT **
			// ** use initialization vector (IV) set from $strEncryptionPassword
			$strIV = $strEncryptionPassword;
			
			// ** remove the first char which is @ to flag this is AES encrypted
			$strIn = substr ( $strIn, 1 );
			
			// ** HEX decoding
			$strIn = pack ( 'H*', $strIn );
			
			// ** perform decryption with PHP's MCRYPT module
			return $this->removePKCS5Padding ( mcrypt_decrypt ( MCRYPT_RIJNDAEL_128, $strEncryptionPassword, $strIn, MCRYPT_MODE_CBC, $strIV ) );
		} else {
			// ** Base 64 decoding plus XOR decryption **
			return $this->simpleXor ( $this->base64Decode ( $strIn ), $strEncryptionPassword );
		}
	}
	
	// New function added 2011-12-29
	// Need to remove padding bytes from end of decoded string
	function removePKCS5Padding($decrypted) {
		$padChar = ord ( $decrypted [strlen ( $decrypted ) - 1] );
		return substr ( $decrypted, 0, - $padChar );
	}
	
	// ** PHP's mcrypt does not have built in PKCS5 Padding, so we use this
	function addPKCS5Padding($input) {
		$blocksize = 16;
		$padding = "";
		
		// Pad input to an even block size boundary
		$padlength = $blocksize - (strlen ( $input ) % $blocksize);
		for($i = 1; $i <= $padlength; $i ++) {
			$padding .= chr ( $padlength );
		}
		
		return $input . $padding;
	}
	
	// Inspects and validates user input for a name field. Returns TRUE if input value is valid as a name field.
	// Parameter "strInputValue" is the field value to validate.
	// Parameter "returnedResult" sets a result to a value from the list of field validation constants beginning with "FIELD_".
	function isValidNameField($strInputValue, &$returnedResult) {
		$strAllowableChars = " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-.'&\\";
		$strInputValue = trim ( $strInputValue );
		$returnedResult = $this->validateString ( $strInputValue, $strAllowableChars, TRUE, TRUE, 20, - 1 );
		if ($returnedResult == FIELD_VALID) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	
	// Inspects and validates user input for an Address field.
	// Parameter "blnIsRequired" specifies whether "strInputValue" must have a non-null and non-empty value.
	function isValidAddressField($strInputValue, $blnIsRequired, &$returnedResult) {
		$strAllowableChars = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-.',/\\()&:+\n\r";
		$strInputValue = trim ( $strInputValue );
		$returnedResult = $this->validateString ( $strInputValue, $strAllowableChars, TRUE, $blnIsRequired, 100, - 1 );
		
		if ($returnedResult == FIELD_VALID) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	
	// Inspects and validates user input for a City field.
	function isValidCityField($strInputValue, &$returnedResult) {
		$strAllowableChars = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-.',/\\()&:+\n\r";
		$strInputValue = trim ( $strInputValue );
		$returnedResult = $this->validateString ( $strInputValue, $strAllowableChars, TRUE, TRUE, 40, - 1 );
		
		if ($returnedResult == FIELD_VALID) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	
	// Inspects and validates user input for a Postcode/zip field.
	function isValidPostcodeField($strInputValue, &$returnedResult) {
		$strAllowableChars = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-";
		$strInputValue = trim ( $strInputValue );
		$returnedResult = $this->validateString ( $strInputValue, $strAllowableChars, FALSE, TRUE, 10, - 1 );
		
		if ($returnedResult == FIELD_VALID) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	
	// Inspects and validates user input for an email field.
	function isValidEmailField($strInputValue, &$returnedResult) {
		// The allowable e-mail address format accepted by the SagePay gateway must be RFC 5321/5322 compliant (see RFC 3696)
		$sEmailRegExpPattern = '/^[a-z0-9\xC0-\xFF\!#$%&amp;\'*+\/=?^_`{|}~\*-]+(?:\.[a-z0-9\xC0-\xFF\!#$%&amp;\'*+\/=?^_`{|}~*-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+(?:[a-z]{2,3}|com|org|net|gov|mil|biz|info|mobi|name|aero|jobs|museum|at|coop|travel)$/';
		$strInputValue = trim ( $strInputValue );
		$returnedResult = $this->validateStringWithRegExp ( $strInputValue, $sEmailRegExpPattern, FALSE );
		
		if ($returnedResult == FIELD_VALID) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	
	// Inspects and validates user input for a phone field.
	function isValidPhoneField($strInputValue, &$returnedResult) {
		$strAllowableChars = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-()+";
		$strInputValue = trim ( $strInputValue );
		$returnedResult = $this->validateString ( $strInputValue, $strAllowableChars, FALSE, FALSE, 20, - 1 );
		
		if ($returnedResult == FIELD_VALID) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	
	// A generic function used to inspect and validate a string from user input.
	// Parameter "strInputValue" is the value to perform validation on.
	// Parameter "strAllowableChars" is a string of characters allowable in "strInputValue" if its to be deemed valid.
	// Parameter "blnAllowAccentedChars" accepts a boolean value which determines if "strInputValue" can contain Accented or High-order characters.
	// Parameter "blnIsRequired" accepts a boolean value which specifies whether "strInputValue" must have a non-null and non-empty value.
	// Parameter "intMaxLength" accepts an integer which specifies the maximum allowable length of "strInputValue". Set to -1 for this to be ignored.
	// Parameter "intMinLength" specifies the miniumum allowable length of "strInputValue". Set to -1 for this to be ignored.
	// Returns a result from one of the field validation constants that begin with "FIELD_"
	function validateString($strInputValue, $strAllowableChars, $blnAllowAccentedChars, $blnIsRequired, $intMaxLength, $intMinLength) {
		if ($blnIsRequired == TRUE && strlen ( $strInputValue ) == 0) {
			return FIELD_INVALID_REQUIRED_INPUT_VALUE_MISSING;
		} elseif (($intMaxLength != - 1) && (strlen ( $strInputValue ) > $intMaxLength)) {
			return FIELD_INVALID_MAXIMUM_LENGTH_EXCEEDED;
		} elseif ($strInputValue != cleanInput2 ( $strInputValue, $strAllowableChars, $blnAllowAccentedChars )) {
			return FIELD_INVALID_BAD_CHARACTERS;
		} elseif (($blnIsRequired == TRUE) && (strlen ( $strInputValue ) < $intMinLength)) {
			return FIELD_INVALID_MINIMUM_LENGTH_NOT_MET;
		} elseif (($blnIsRequired == FALSE) && (strlen ( $strInputValue ) > 0) && (strlen ( $strInputValue ) < $intMinLength)) {
			return FIELD_INVALID_MINIMUM_LENGTH_NOT_MET;
		} else {
			return FIELD_VALID;
		}
	}
	
	// A generic function to inspect and validate a string from user input based on a Regular Expression pattern.
	// Parameter "strInputValue" is the value to perform validation on.
	// Parameter "strRegExPattern" is a Regular Expression string pattern used to validate against "strInputValue".
	// Parameter "blnIsRequired" accepts a boolean value which specifies whether "strInputValue" must have a non-null and non-empty value.
	// Returns a result from one of the field validation constants that begin with "FIELD_"
	function validateStringWithRegExp($strInputValue, $strRegExPattern, $blnIsRequired) {
		if ($blnIsRequired == TRUE && strlen ( $strInputValue ) == 0) {
			return FIELD_INVALID_REQUIRED_INPUT_VALUE_MISSING;
		} elseif (strlen ( $strInputValue ) > 0) {
			if (preg_match ( $strRegExPattern, $strInputValue )) {
				return FIELD_VALID;
			} else {
				return FIELD_INVALID_BAD_FORMAT;
			}
		} else {
			return FIELD_VALID;
		}
	}
	
	// Maps a Field Validation constant value to a string representing a user friendly validation error message.
	// Parameter "strFieldLabelName" is the display name of the form field to use in the returned message.
	function getValidationMessage($fieldValidationCode, $strFieldLabelName) {
		$strReturn = "";
		
		switch ($fieldValidationCode) {
			case FIELD_INVALID_BAD_CHARACTERS :
				$strReturn = "Please correct " . $strFieldLabelName . " as it contains disallowed characters.";
				break;
			case FIELD_INVALID_BAD_FORMAT :
				$strReturn = "Please correct " . $strFieldLabelName . " as the format is invalid.";
				break;
			case FIELD_INVALID_MINIMUM_LENGTH_NOT_MET :
				$strReturn = "Please correct " . $strFieldLabelName . " as the value is not long enough.";
				break;
			case FIELD_INVALID_MAXIMUM_LENGTH_EXCEEDED :
				$strReturn = "Please correct " . $strFieldLabelName . " as the value is too long.";
				break;
			case FIELD_INVALID_REQUIRED_INPUT_VALUE_MISSING :
				$strReturn = "Please enter a value for " . $strFieldLabelName . " where requested below.";
				break;
			case FIELD_INVALID_REQUIRED_INPUT_VALUE_NOT_SELECTED :
				$strReturn = "Please select a value for " . $strFieldLabelName . " where requested below.";
				break;
		}

		return $strReturn;
	}
	
}
