<?php

/**
* @version 3.1.7
* @package Joomla 3.x
* @subpackage DT Register
* @copyright Copyright (C) 2006 DTH Development
* @copyright contact dthdev@dthdevelopment.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

$_REQUEST['option'] = 'com_dtregister';
ob_start();
define( '_JEXEC', 1 );

global $oldpath;
$oldpath = getcwd();
chdir('../../');
define('JPATH_BASE', getcwd() );
define( 'DS', DIRECTORY_SEPARATOR );


//define('_JEXEC', 1);
//set_error_handler("errorHandler50");
//register_shutdown_function("shutdownHandler50");

function errorHandler50($error_level, $error_message, $error_file, $error_line, $error_context)
{
$error = "lvl: " . $error_level . " | msg:" . $error_message . " | file:" . $error_file . " | ln:" . $error_line;
switch ($error_level) {
    case E_ERROR:
    case E_CORE_ERROR:
    case E_COMPILE_ERROR:
    case E_PARSE:
        log500($error, "fatal");
        break;
    case E_USER_ERROR:
    case E_RECOVERABLE_ERROR:
        log500($error, "error");
        break;
    case E_WARNING:
    case E_CORE_WARNING:
    case E_COMPILE_WARNING:
    case E_USER_WARNING:
        log500($error, "warn");
        break;
    case E_NOTICE:
    case E_USER_NOTICE:
        log500($error, "info");
        break;
    case E_STRICT:
        log500($error, "debug");
        break;
    default:
        log500($error, "warn");
}
}

function shutdownHandler50() //will be called when php script ends.
{
$lasterror = error_get_last();
switch ($lasterror['type'])
{
    case E_ERROR:
    case E_CORE_ERROR:
    case E_COMPILE_ERROR:
    case E_USER_ERROR:
    case E_RECOVERABLE_ERROR:
    case E_CORE_WARNING:
    case E_COMPILE_WARNING:
    case E_PARSE:
        $error = "[SHUTDOWN] lvl:" . $lasterror['type'] . " | msg:" . $lasterror['message'] . " | file:" . $lasterror['file'] . " | ln:" . $lasterror['line'];
        log500($error, "fatal");
}
}

function log500($error, $errlvl)
{
  echo "<br/>".$error;
}

class RouterReplacor 
{
	/**
	 * @return  void
	 */
	public function AfterInitialise()
	{
		$app = JFactory::getApplication();
 
		// Get the router
		$router = $app->getRouter();
 
		// Create a callback array to call the replaceRoute method of this object
		$replaceRouteCallback = array($this, 'replaceRoute');
 
		// Attach the callback to the router
		$router->attachParseRule($replaceRouteCallback);
	}
 
	/**
	 * @param   JRouterSite  &$router  The Joomla Site Router
	 * @param   JURI         &$uri     The URI to parse
	 *
	 * @return  array  The array of processed URI variables
	 */
	public function replaceRoute(&$router, &$uri)
	{
		//$app = JFactory::getApplication('site');
		 $uri->setVar('lang','en');
		
 
		return array('lang'=>'en');
	}
}

$RouterReplacor = new RouterReplacor();
if (file_exists(JPATH_BASE . '/defines.php'))
{
	include_once JPATH_BASE . '/defines.php';
}

if (!defined('_JDEFINES'))
{
	define('JPATH_BASE', __DIR__);
	require_once JPATH_BASE . '/includes/defines.php';
}

require_once JPATH_BASE . '/includes/framework.php';
require_once JPATH_BASE . '/components/com_dtregister/lib/app.php';
// Mark afterLoad in the profiler.
JDEBUG ? $_PROFILER->mark('afterLoad') : null;
function myErrorHandler($errno, $errstr, $errfile, $errline) {
	$log = false;
    switch ($errno) {
        case E_NOTICE:
        case E_USER_NOTICE:
            $errors = "Notice";
            break;
        case E_WARNING:
        case E_USER_WARNING:
            $errors = "Warning";
            break;
        case E_ERROR:
        case E_USER_ERROR:
            $errors = "Fatal Error";
			$log = true;
            break;
        default:
		    $log = true;
            $errors = "Unknown";
            break;
        }

      $debug = sprintf ("<br />\n<b>%s</b>: %s in <b>%s</b> on line <b>%d</b><br /><br />\n", $errors, $errstr, $errfile, $errline);
   
      $debug .= sprintf("PHP %s:  %s in %s on line %d", $errors, $errstr, $errfile, $errline);
	  $debug = ob_get_clean();
	  $path = JPATH_BASE."/components/com_dtregister/lib/payment/ipnlog.html";
	  //if($log)
	  file_put_contents($path,$debug,FILE_APPEND);
     
    return true;
}
JRequest::setVar('controller','payment');
JRequest::setVar('option','com_dtregister');

$mainframe = JFactory::getApplication('dtapp');



$mainframe->initialise();
//$RouterReplacor->AfterInitialise();

JPluginHelper::importPlugin('system');
$lang = JFactory::getLanguage();
$lang->load('com_dtregister');

if(isset($_REQUEST['rvar_return'])) {
  $_REQUEST['return'] = $_REQUEST['rvar_return'];
}
if(!isset($_REQUEST['task'])){
   $_REQUEST['task'] = 'restore';
}
//set_error_handler("myErrorHandler");
$mailtxt = var_export($_REQUEST,true);

if($_REQUEST['task']=="notify"){ 
   $_REQUEST['task'] = "notification";
   }

if(!isset($_REQUEST['x_cust_id']) && $_REQUEST['task']=="cancel") {
	$Itemid = $_REQUEST['Itemid'];
	 
	  $baseurl = str_replace('components/com_dtregister/','',Juri::base()); 
	  
	  
	  $mainframe->redirect($baseurl.'index.php?option=com_dtregister&task=cancel&controller=payment&Itemid='.$Itemid);
    
   die;	
}
if (is_callable(array($mainframe, 'execute')))
{
  $mainframe->execute();
} 
else {
  $mainframe->dispatch();
}

die;
//chdir($oldpath);

die();
?>
