<?php

/**
 * @version 3.3
 * @package Joomla 3.x
 * @subpackage DT Register Events Module
 * @copyright Copyright (C) 2006 DTH Development
 * @copyright contact dthdev@dthdevelopment.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

defined('_JEXEC') or die;

class ModDtUpcomingEvent
{

    public static function  getevents($params)
    {

        global $now;

        $config = JFactory::getConfig();

        global $database,$Itemid;

        global $hide_full_event;

        $document = JFactory::getDocument();

        $eventTable = new TableEvent($database);
        $user = JFactory::getUser();
        $access_levels = $user->getAuthorisedViewLevels();
        $document->addStyleSheet('modules/mod_dt_upcoming_event/mod_dt_upcoming_event.css');
        $database = JFactory::getDBO();

        $pageItemId = $Itemid;

        $Itemid = self::getItemId();

        $linkType = intval($params->get('link_type', 1));

        $showPastEvent = intval($params->get('show_past_event', 0));

        $numberEvents = intval($params->get('number_events', 0));

        $show_category = intval($params->get('show_category', 0));

        $show_location = intval($params->get('show_location', 0));

        $show_cut_off_date = intval($params->get('show_cut_off_date', 0));

        $show_price = $params->get('show_price', '');

        $not_show_past_event = intval($params->get('not_show_past_event', 1));

        $category_link = $params->get('category_link', 0);

        $show_time = intval($params->get('show_time', 0));

        $catids = $params->get('catids', -1);

        $categories = "";
        $catJoin = "";
        if ($catids != -1) {

            if (!is_array($catids)) {

                $catids = array($catids);

            }

            $categories = " and c.categoryId in(" . implode(",", $catids) . ")";
			
			$catJoin = " left join #__dtregister_categories as c on c2.lft >= c.lft and c2.lft <= c.rgt ";

        }

        if (!$showPastEvent) {
            $sqlshowPastEvent = " and b.dtend >= '" . $now->toFormat('%Y-%m-%d') . "'   "; // and (b.startdate <= now() || b.startdate is null ) AND
        } else {
            $sqlshowPastEvent = "";
        }

        //$sqlshowPastEvent = "";
        if ($not_show_past_event) {

            $sqlNotShowPastEvent = " and b.dtstart >= '" . $now->toFormat('%Y-%m-%d') . "' ";

        } else {

            $sqlNotShowPastEvent = " ";

        }

//Get the list of created dtregister events
        $tables = $database->getTableList();
        $table_name = $database->getPrefix() . "jevents_vevdetail";
        $jeventId = "";
        $jeventJoin = "";
        $jevenSelect = "";
        if ((bool)(in_array($table_name, $tables))) {
            $jeventId = " ,r.rp_id ";
            $jeventJoin = "left join #__jevents_vevdetail a on a.evdet_id = b.eventId
		  left join #__jevents_repetition r on r.eventdetail_id = a.evdet_id ";
            $jevenSelect = ",a.*";
        }
        $sql = "select distinct(b.slabId), if(concat(b.startdate,' ',b.starttime) >= '" . $now->toMySQL(true) . "' and b.startdate is not null,'y','n') as future_event ,
        if(cut_off_date = 0000-00-00,'n',if('" . $now->toMySQL(true) . "'> concat(cut_off_date,' ',cut_off_time),'y','n')) as cut_off  ,b.cut_off_date,
		if('" . $now->toMySQL(true) . "' < concat(bird_discount_date,' ',bird_discount_time) and bird_discount_type<>0 and bird_discount_type <> 3,'y','n') as bird ,
		waiting_list $jevenSelect $jeventId ,  b.* , c2.categoryId , c2.categoryName from
		#__dtregister_group_event b

		left join  #__dtregister_event_categories ec on ec.event_id = b.slabId
		left join #__dtregister_categories as c2 on c2.categoryId = ec.category_id
		
		$catJoin 
		
		$jeventJoin

		where if(ec.event_id IS not NUll, (c2.published = 1 and c2.access in(" . implode(",", $access_levels) . ")),1) and b.publish=1 " . $sqlshowPastEvent . " " . $sqlNotShowPastEvent . " $categories group by b.slabId ORDER by b.dtstart asc ";

        if ($numberEvents) {

            $sql .= " limit 0,$numberEvents ";

        }

        $database->setQuery($sql);

        $rows = $database->loadObjectList();
        for ($i = 0, $n = count($rows); $i < $n; $i++) {

            $row = $rows[$i];

            $rows[$i]->registered = $eventTable->getTotalregistered($row->slabId);

        }
        foreach ($rows as &$row) {

            $dt_event = $eventTable;

            $dt_event->overrideGlobal($row->slabId);
            $reglink = "";

            if ($linkType == 1 && isset($row->evdet_id) && $row->evdet_id != "") {

                //Link to event detail page

                $reglink = "index.php?option=com_jevents&task=icalrepeat.detail&evid=$row->rp_id&Itemid=$Itemid";

            } elseif ($linkType == 3 && is_numeric($row->article_id) && $row->article_id > 0) {

                unset($article);

                unset($article_ItemId);

                $article = $dt_event->getArticle($row->article_id);

                $article_ItemId = $dt_event->getArticleItemid($article);
                $article->slug = $article->alias ? ($article->id . ':' . $article->alias) : $article->id;
                $article->catslug = isset($article->category_alias) && $article->category_alias ? ($article->catid . ':' . $article->category_alias) : $article->catid;
                $reglink = JRoute::_(ContentHelperRoute::getArticleRoute($article->slug, $article->catslug));
                //$reglink = JRoute::_('index.php?option=com_content&view=article&id='.$article->id.'&Itemid='.$article_ItemId,false);

                // $reglink = substr($reglink,(strlen(JUri::root(true ))+1));

            } else {

                //Link to registration page

                if (!$row->registered) {

                    $row->registered = 0;

                }

                if ($row->future_event == 'y' && $showPastEvent == 1) {

                    $task = "cut_off_date";

                } elseif (($row->cut_off == 'y') && ($row->cut_off_date != '0000-00-00'))

                    $task = "cut_off_date";

                elseif (($row->registered >= $row->max_registrations) && ($row->max_registrations) && ($row->waiting_list == '0'))

                    $task = "full_event_page";

                elseif (($row->registered >= $row->max_registrations) && ($row->max_registrations) && ($row->waiting_list == '1'))

                    $task = "full_event_page_msg";

                else

                $task = "event_register";

                $queryReg = "SELECT eventID,registration_type FROM #__dtregister_group_event WHERE slabId = " . $row->slabId;

                $database->setQuery($queryReg);

                $eventReg = $database->loadResult();

                $event = $database->loadObject();

                $eventId = $row->slabId;

                if ($row->slabId != "") {

                    $reglink = "index.php?option=com_dtregister&controller=event&Itemid=$Itemid&task=register&eventId=$eventId";
                }

            }

            $row->reglink = $reglink;

        }

        return $rows;

    }

    static function getItemId()
    {

        $mainframe = JFactory::getApplication();

        $database = JFactory::getDBO();

        $query = " SELECT m.id

					FROM #__extensions c

					INNER JOIN #__menu m ON c.extension_id = m.component_id

					WHERE c.name = 'com_dtregister'

					LIMIT 1 ";

        $database->setQuery($query);

        $Itemid = $database->loadResult();

        return $Itemid;

    }

}
